<?php
/**
 * Add header HTML element settings.
 *
 * @package Suit Blog
 */

$fields = [
    'header_html_group_fields' => [
        'type'              => 'group-field',
        'section'           => 'header_html_element_section',
        'priority'          => 5,
        'tabs'              => [
            'desktop'            => [
                'nicename'      => esc_html__( '&gt; 1200px', 'suit-blog' ),
                'preview'       => 'desktop',
                'active_tab'    => true,
                'controls'      => [
                    'header_html_sep_1',
                    'header_html_content',
                    'header_html_content_color',
                    'header_html_sep_2',
                    'header_html_container_padding',
                    'header_html_container_margin'
                ]
            ],
            'tablet'            => [
                'nicename'      => esc_html__( '&gt; 768px', 'suit-blog' ),
                'preview'       => 'tablet',
                'active_tab'    => false,
                'controls'      => [
                    'header_html_sep_2',
                    'header_html_container_md_padding',
                    'header_html_container_md_margin'

                ]
            ],
            'mobile'            => [
                'nicename'      => esc_html__( '&lt; 576px', 'suit-blog' ),
                'preview'       => 'mobile',
                'active_tab'    => false,
                'controls'      => [
                    'header_html_sep_2',
                    'header_html_container_sm_padding',
                    'header_html_container_sm_margin'
                ]
            ]
        ],
    ],
    'header_html_sep_1' => [
        'type'              => 'custom',
        'section'           => 'header_html_element_section',
        'default'           => '<h3 style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'CONTENT SETTING', 'suit-blog' ) . '</h3>',
        'priority'          => 10
    ],
    'header_html_content' => [
        'type'              => 'editor',
        'label'             => esc_html__( 'HTML', 'suit-blog' ),
        'description'       => esc_html__( 'You can add here some arbitrary HTML code.', 'suit-blog'),
        'section'           => 'header_html_element_section',
        'default'           => esc_html__( 'Sample Text', 'suit-blog' ),
        'priority'          => 10,
        'transport'         => 'postMessage',
        'js_vars'           => [
            [
                'element'   => '.site-header .header-html-inner',
                'function'  => 'html'
            ]
        ],
    ],
    'header_html_content_color' => [
        'type'              => 'color',
        'label'             => esc_html__( 'Text Color', 'suit-blog' ),
        'section'           => 'header_html_element_section',
        'choices'           => [
			'alpha'         => true,
		],
        'default'           => '',
        'priority'          => 10,
        'transport'         => 'auto',
        'priority'          => 10,
        'output'            => [
            [
                'element'   => '.site-header .header-html-inner',
                'property'  => 'color',
            ],
        ],
        
    ],
    'header_html_sep_2' => [
        'type'              => 'custom',
        'section'           => 'header_html_element_section',
        'default'           => '<h3 style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'CONTAINER SETTING', 'suit-blog' ) . '</h3>',
        'priority'          => 10
    ],
    'header_html_container_padding' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Padding', 'suit-blog' ),
        'description' => esc_html__( 'Set HTML container padding.', 'suit-blog' ),
        'section'     => 'header_html_element_section',
        'priority'    => 10,
        'default'     => [
            'padding-top'    => '',
            'padding-bottom' => '',
            'padding-left'   => '',
            'padding-right'  => '',
        ],
        'choices'     => [
            'labels'    => [
                'padding-top'    => esc_html__( 'Top', 'suit-blog' ),
                'padding-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
                'padding-left'   => esc_html__( 'Left', 'suit-blog' ),
                'padding-right'  => esc_html__( 'Right', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'choice'    => 'padding-top',
                'property'  => 'padding-top',
                'element'   => '.site-header .header-html-inner',
            ],
            [
                'choice'    => 'padding-bottom',
                'property'  => 'padding-bottom',
                'element'   => '.site-header .header-html-inner',
            ],
            [
                'choice'    => 'padding-left',
                'property'  => 'padding-left',
                'element'   => '.site-header .header-html-inner',
            ],
            [
                'choice'    => 'padding-right',
                'property'  => 'padding-right',
                'element'   => '.site-header .header-html-inner',
            ],
        ],
    ],
    'header_html_container_md_padding' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Padding', 'suit-blog' ),
        'description' => esc_html__( 'Set HTML container padding.', 'suit-blog' ),
        'section'     => 'header_html_element_section',
        'priority'    => 10,
        'default'     => [
            'padding-top'    => '',
            'padding-bottom' => '',
            'padding-left'   => '',
            'padding-right'  => '',
        ],
        'choices'     => [
            'labels'    => [
                'padding-top'    => esc_html__( 'Top', 'suit-blog' ),
                'padding-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
                'padding-left'   => esc_html__( 'Left', 'suit-blog' ),
                'padding-right'  => esc_html__( 'Right', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'padding-top',
                'property'      => 'padding-top',
                'element'       => '.site-header .header-html-inner',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'padding-bottom',
                'property'      => 'padding-bottom',
                'element'       => '.site-header .header-html-inner',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'padding-left',
                'property'      => 'padding-left',
                'element'       => '.site-header .header-html-inner',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'padding-right',
                'property'      => 'padding-right',
                'element'       => '.site-header .header-html-inner',
            ],
        ],
    ],
    'header_html_container_sm_padding' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Padding', 'suit-blog' ),
        'description' => esc_html__( 'Set HTML container padding.', 'suit-blog' ),
        'section'     => 'header_html_element_section',
        'priority'    => 10,
        'default'     => [
            'padding-top'    => '',
            'padding-bottom' => '',
            'padding-left'   => '',
            'padding-right'  => '',
        ],
        'choices'     => [
            'labels'    => [
                'padding-top'    => esc_html__( 'Top', 'suit-blog' ),
                'padding-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
                'padding-left'   => esc_html__( 'Left', 'suit-blog' ),
                'padding-right'  => esc_html__( 'Right', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'padding-top',
                'property'      => 'padding-top',
                'element'       => '.site-header .header-html-inner',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'padding-bottom',
                'property'      => 'padding-bottom',
                'element'       => '.site-header .header-html-inner',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'padding-left',
                'property'      => 'padding-left',
                'element'       => '.site-header .header-html-inner',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'padding-right',
                'property'      => 'padding-right',
                'element'       => '.site-header .header-html-inner',
            ],
        ],
    ],
    'header_html_container_margin' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Margin', 'suit-blog' ),
        'description' => esc_html__( 'Set HTML container margin.', 'suit-blog' ),
        'section'     => 'header_html_element_section',
        'priority'    => 10,
        'default'     => [
            'margin-top'    => '',
            'margin-bottom' => '',
            'margin-left'   => '',
            'margin-right'  => '',
        ],
        'choices'     => [
            'labels'    => [
                'margin-top'    => esc_html__( 'Top', 'suit-blog' ),
                'margin-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
                'margin-left'   => esc_html__( 'Left', 'suit-blog' ),
                'margin-right'  => esc_html__( 'Right', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'choice'    => 'margin-top',
                'property'  => 'margin-top',
                'element'   => '.site-header .header-html-inner',
            ],
            [
                'choice'    => 'margin-bottom',
                'property'  => 'margin-bottom',
                'element'   => '.site-header .header-html-inner',
            ],
            [
                'choice'    => 'margin-left',
                'property'  => 'margin-left',
                'element'   => '.site-header .header-html-inner',
            ],
            [
                'choice'    => 'margin-right',
                'property'  => 'margin-right',
                'element'   => '.site-header .header-html-inner',
            ],
        ],
    ],
    'header_html_container_md_margin' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Margin', 'suit-blog' ),
        'description' => esc_html__( 'Set HTML container margin.', 'suit-blog' ),
        'section'     => 'header_html_element_section',
        'priority'    => 10,
        'default'     => [
            'margin-top'    => '',
            'margin-bottom' => '',
            'margin-left'   => '',
            'margin-right'  => '',
        ],
        'choices'     => [
            'labels'    => [
                'margin-top'    => esc_html__( 'Top', 'suit-blog' ),
                'margin-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
                'margin-left'   => esc_html__( 'Left', 'suit-blog' ),
                'margin-right'  => esc_html__( 'Right', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'margin-top',
                'property'      => 'margin-top',
                'element'       => '.site-header .header-html-inner',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'margin-bottom',
                'property'      => 'margin-bottom',
                'element'       => '.site-header .header-html-inner',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'margin-left',
                'property'      => 'margin-left',
                'element'       => '.site-header .header-html-inner',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'margin-right',
                'property'      => 'margin-right',
                'element'       => '.site-header .header-html-inner',
            ],
        ],
    ],
    'header_html_container_sm_margin' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Margin', 'suit-blog' ),
        'description' => esc_html__( 'Set HTML container margin.', 'suit-blog' ),
        'section'     => 'header_html_element_section',
        'priority'    => 10,
        'default'     => [
            'margin-top'    => '',
            'margin-bottom' => '',
            'margin-left'   => '',
            'margin-right'  => '',
        ],
        'choices'     => [
            'labels'    => [
                'margin-top'    => esc_html__( 'Top', 'suit-blog' ),
                'margin-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
                'margin-left'   => esc_html__( 'Left', 'suit-blog' ),
                'margin-right'  => esc_html__( 'Right', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'margin-top',
                'property'      => 'margin-top',
                'element'       => '.site-header .header-html-inner',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'margin-bottom',
                'property'      => 'margin-bottom',
                'element'       => '.site-header .header-html-inner',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'margin-left',
                'property'      => 'margin-left',
                'element'       => '.site-header .header-html-inner',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'margin-right',
                'property'      => 'margin-right',
                'element'       => '.site-header .header-html-inner',
            ],
        ],
    ],
];
foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );

    Kirki::add_field( 'suit-blog', $field_args );
}