<?php
/**
 * Add primary menu element settings.
 *
 * @package Suit Blog
 */

$fields = [
    'header_wc_cart_group_fields' => [
        'type'              => 'group-field',
        'section'           => 'header_wc_cart_element_section',
        'priority'          => 5,
        'tabs'              => [
            'desktop'            => [
                'nicename'      => esc_html__( '&gt; 1100px', 'suit-blog' ),
                'preview'       => 'desktop',
                'active_tab'    => true,
                'controls'      => [
                    'header_wc_cart_sep',
                    'header_wc_cart_icon_size',
                    'header_wc_cart_parent_item_padding',
                    'header_wc_cart_sep_3',
                    'header_wc_cart_container_padding',
                    'header_wc_cart_container_margin'
                ]
            ],
            'tablet'            => [
                'nicename'      => esc_html__( '&gt; 768px', 'suit-blog' ),
                'preview'       => 'tablet',
                'active_tab'    => false,
                'controls'      => [
                    'header_wc_cart_sep_3',
                    'header_wc_cart_container_md_padding',
                    'header_wc_cart_container_md_margin'
                ]
            ],
            'mobile'            => [
                'nicename'      => esc_html__( '&lt; 576px', 'suit-blog' ),
                'preview'       => 'mobile',
                'active_tab'    => false,
                'controls'      => [
                    'header_wc_cart_sep_3',
                    'header_wc_cart_container_sm_padding',
                    'header_wc_cart_container_sm_margin'
                ]
            ]
        ],
    ],
    'header_wc_cart_sep' => [
        'type'              => 'custom',
        'section'           => 'header_wc_cart_element_section',
        'default'           => '<h3 style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'ICON', 'suit-blog' ) . '</h3>',
        'priority'          => 10
    ],
    'header_wc_cart_icon_size' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Spacing', 'suit-blog' ),
        'description'       => esc_html__( 'Set wc cart icon size.', 'suit-blog' ),
        'section'           => 'header_wc_cart_element_section',
        'default'           => 18,
        'choices'           => [
            'min'               => 00,
            'max'               => 50,
            'step'              => 1,
            'suffix'            => 'px'
        ],
        'priority'          => 10,
        'transport'         => 'auto',
        'output'            => [
            [
	            'property'      => 'font-size',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon i',
                'suffix'        => 'px'
            ]
        ],
    ],
    'header_wc_cart_sep_3' => [
        'type'              => 'custom',
        'section'           => 'header_wc_cart_element_section',
        'default'           => '<h3 style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'CONTAINER SETTING', 'suit-blog' ) . '</h3>',
        'priority'          => 10
    ],
    'header_wc_cart_container_padding' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Padding', 'suit-blog' ),
        'description' => esc_html__( 'Set wc cart container padding.', 'suit-blog' ),
        'section'     => 'header_wc_cart_element_section',
        'priority'    => 10,
        'default'     => [
            'padding-top'    => '',
            'padding-bottom' => '',
            'padding-left'   => '',
            'padding-right'  => '',
        ],
        'choices'     => [
            'labels'    => [
                'padding-top'    => esc_html__( 'Top', 'suit-blog' ),
                'padding-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
                'padding-left'   => esc_html__( 'Left', 'suit-blog' ),
                'padding-right'  => esc_html__( 'Right', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'choice'    => 'padding-top',
                'property'  => 'padding-top',
                'element'   => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'choice'    => 'padding-bottom',
                'property'  => 'padding-bottom',
                'element'   => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'choice'    => 'padding-left',
                'property'  => 'padding-left',
                'element'   => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'choice'    => 'padding-right',
                'property'  => 'padding-right',
                'element'   => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
        ],
    ],
    'header_wc_cart_container_md_padding' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Padding', 'suit-blog' ),
        'description' => esc_html__( 'Set wc cart container padding.', 'suit-blog' ),
        'section'     => 'header_wc_cart_element_section',
        'priority'    => 10,
        'default'     => [
            'padding-top'    => '',
            'padding-bottom' => '',
            'padding-left'   => '',
            'padding-right'  => '',
        ],
        'choices'     => [
            'labels'    => [
                'padding-top'    => esc_html__( 'Top', 'suit-blog' ),
                'padding-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
                'padding-left'   => esc_html__( 'Left', 'suit-blog' ),
                'padding-right'  => esc_html__( 'Right', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'padding-top',
                'property'      => 'padding-top',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'padding-bottom',
                'property'      => 'padding-bottom',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'padding-left',
                'property'      => 'padding-left',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'padding-right',
                'property'      => 'padding-right',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
        ],
    ],
    'header_wc_cart_container_sm_padding' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Padding', 'suit-blog' ),
        'description' => esc_html__( 'Set wc cart container padding.', 'suit-blog' ),
        'section'     => 'header_wc_cart_element_section',
        'priority'    => 10,
        'default'     => [
            'padding-top'    => '',
            'padding-bottom' => '',
            'padding-left'   => '',
            'padding-right'  => '',
        ],
        'choices'     => [
            'labels'    => [
                'padding-top'    => esc_html__( 'Top', 'suit-blog' ),
                'padding-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
                'padding-left'   => esc_html__( 'Left', 'suit-blog' ),
                'padding-right'  => esc_html__( 'Right', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'padding-top',
                'property'      => 'padding-top',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'padding-bottom',
                'property'      => 'padding-bottom',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'padding-left',
                'property'      => 'padding-left',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'padding-right',
                'property'      => 'padding-right',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
        ],
    ],
    'header_wc_cart_container_margin' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Margin', 'suit-blog' ),
        'description' => esc_html__( 'Set wc cart container margin.', 'suit-blog' ),
        'section'     => 'header_wc_cart_element_section',
        'priority'    => 10,
        'default'     => [
            'margin-top'    => '',
            'margin-bottom' => '',
            'margin-left'   => '',
            'margin-right'  => '',
        ],
        'choices'     => [
            'labels'    => [
                'margin-top'    => esc_html__( 'Top', 'suit-blog' ),
                'margin-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
                'margin-left'   => esc_html__( 'Left', 'suit-blog' ),
                'margin-right'  => esc_html__( 'Right', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'choice'    => 'margin-top',
                'property'  => 'margin-top',
                'element'   => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'choice'    => 'margin-bottom',
                'property'  => 'margin-bottom',
                'element'   => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'choice'    => 'margin-left',
                'property'  => 'margin-left',
                'element'   => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'choice'    => 'margin-right',
                'property'  => 'margin-right',
                'element'   => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
        ],
    ],
    'header_wc_cart_container_md_margin' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Margin', 'suit-blog' ),
        'description' => esc_html__( 'Set wc cart container margin.', 'suit-blog' ),
        'section'     => 'header_wc_cart_element_section',
        'priority'    => 10,
        'default'     => [
            'margin-top'    => '',
            'margin-bottom' => '',
            'margin-left'   => '',
            'margin-right'  => '',
        ],
        'choices'     => [
            'labels'    => [
                'margin-top'    => esc_html__( 'Top', 'suit-blog' ),
                'margin-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
                'margin-left'   => esc_html__( 'Left', 'suit-blog' ),
                'margin-right'  => esc_html__( 'Right', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'margin-top',
                'property'      => 'margin-top',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'margin-bottom',
                'property'      => 'margin-bottom',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'margin-left',
                'property'      => 'margin-left',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'media_query'   => '@media (max-width: 768px)',
                'choice'        => 'margin-right',
                'property'      => 'margin-right',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
        ],
    ],
    'header_wc_cart_container_sm_margin' => [
        'type'        => 'dimensions',
        'label'       => esc_html__( 'Margin', 'suit-blog' ),
        'description' => esc_html__( 'Set wc cart container margin.', 'suit-blog' ),
        'section'     => 'header_wc_cart_element_section',
        'priority'    => 10,
        'default'     => [
            'margin-top'    => '',
            'margin-bottom' => '',
            'margin-left'   => '',
            'margin-right'  => '',
        ],
        'choices'     => [
            'labels'    => [
                'margin-top'    => esc_html__( 'Top', 'suit-blog' ),
                'margin-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
                'margin-left'   => esc_html__( 'Left', 'suit-blog' ),
                'margin-right'  => esc_html__( 'Right', 'suit-blog' ),
            ],
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'margin-top',
                'property'      => 'margin-top',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'margin-bottom',
                'property'      => 'margin-bottom',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'margin-left',
                'property'      => 'margin-left',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
            [
                'media_query'   => '@media (max-width: 576px)',
                'choice'        => 'margin-right',
                'property'      => 'margin-right',
                'element'       => '.site-header .header-wc-cart-wrap .cart-icon',
            ],
        ],
    ],
];
foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );

    Kirki::add_field( 'suit-blog', $field_args );
}