<?php
/**
 * Add General Colors Settings
 *
 * @package Suit Blog
 */

$fields = [
    'accent_light_colors'  => [
        'type'              => 'multicolor',
        'label'             => esc_html__( 'Accent', 'suit-blog' ),
        'section'           => 'colors',
        'priority'          => 10,
        'choices'           => [
            'color_1'           => esc_html__( 'Primary', 'suit-blog' ),
            'color_2'           => esc_html__( 'Secondary', 'suit-blog' )
        ],
        'default'           => [
            'color_1'            => '#0258c7',
            'color_2'            => '#0e80e8'
        ],
        'transport' => 'auto',
        'output'    => [
            [
                'choice'   => 'color_1',
                'element'  => ':root',
                'property' => '--suit-blog-accent-color-1',
            ],
            [
                'choice'   => 'color_2',
                'element'  => ':root',
                'property' => '--suit-blog-accent-color-2',
            ],
        ],
    ],
    'heading_light_colors'  => [
        'type'              => 'multicolor',
        'label'             => esc_html__( 'Heading H1 - H6', 'suit-blog' ),
        'section'           => 'colors',
        'priority'          => 10,
        'choices'           => [
            'color_1'           => esc_html__( 'Color 1', 'suit-blog' )
        ],
        'default'           => [
            'color_1'           => '#3d4151'
        ],
        'transport' => 'auto',
        'output'    => [
            [
                'choice'   => 'color_1',
                'element'  => ':root',
                'property' => '--suit-blog-gray-900',
            ]
        ],
    ],
    'text_light_colors'  => [
        'type'              => 'multicolor',
        'label'             => esc_html__( 'Text', 'suit-blog' ),
        'section'           => 'colors',
        'priority'          => 10,
        'choices'           => [
            'color_1'           => esc_html__( 'Color 1', 'suit-blog' ),
            'color_2'           => esc_html__( 'Color 2', 'suit-blog' ),
            'color_3'           => esc_html__( 'Color 3', 'suit-blog' ),
            'color_4'           => esc_html__( 'Color 4', 'suit-blog' )
        ],
        'default'           => [
            'color_1'            => 'rgb(75 85 99)',
            'color_2'            => 'rgb(107 114 128)',
            'color_3'            => 'rgb(156 163 175)',
            'color_4'            => '#ffffff',
        ],
        'transport' => 'auto',
        'output'    => [
            [
                'choice'   => 'color_1',
                'element'  => ':root',
                'property' => '--suit-blog-gray-600',
            ],
            [
                'choice'   => 'color_2',
                'element'  => ':root',
                'property' => '--suit-blog-gray-500',
            ],
            [
                'choice'   => 'color_3',
                'element'  => ':root',
                'property' => '--suit-blog-gray-400',
            ],
            [
                'choice'   => 'color_4',
                'element'  => ':root',
                'property' => '--suit-blog-base-color',
            ]
        ],
    ],
    'background_light_colors'  => [
        'type'              => 'multicolor',
        'label'             => esc_html__( 'Background', 'suit-blog' ),
        'section'           => 'colors',
        'priority'          => 10,
        'choices'           => [
            'color_1'           => esc_html__( 'Bg Color 1', 'suit-blog' ),
            'color_2'           => esc_html__( 'Bg Color 2', 'suit-blog' ),
            'color_3'           => esc_html__( 'Bg Color 3', 'suit-blog' )
        ],
        'default'           => [
            'color_1'           => '#ffffff',
            'color_2'           => 'rgb(249 250 251)',
            'color_3'           => '#ffffff'
        ],
        'transport' => 'auto',
        'output'    => [
            [
                'choice'   => 'color_1',
                'element'  => ':root',
                'property' => '--suit-blog-base-background',
            ],
            [
                'choice'   => 'color_2',
                'element'  => ':root',
                'property' => '--suit-blog-gray-50',
            ],
            [
                'choice'   => 'color_3',
                'element'  => ':root',
                'property' => '--suit-blog-gray-100',
            ]
        ],
    ],
    'body_separator' => [
        'type'              => 'custom',
        'section'           => 'colors',
        'default'           => '<h3 style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'Body', 'suit-blog' ) . '</h3>',
        'priority'          => 20
    ],
    'body_background_color_image' => [
        'type'              => 'background',
        'section'           => 'colors',
        'priority'          => 20,
        'default'           => [
            'background-image'      => '',
            'background-repeat'     => 'repeat',
            'background-position'   => 'center center',
            'background-size'       => 'cover',
            'background-attachment' => 'scroll',
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'element'       => 'body',
            ],
        ],
    ],
    'buttons_separator' => [
        'type'              => 'custom',
        'section'           => 'colors',
        'default'           => '<h3 style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'Buttons', 'suit-blog' ) . '</h3>',
        'priority'          => 30
    ],
    'button_text_color'  => [
        'type'              => 'multicolor',
        'label'             => esc_html__( 'Text Color', 'suit-blog' ),
        'description'       => esc_html__( 'Set button text color.', 'suit-blog' ),
        'section'           => 'colors',
        'choices'           => [
            'color_1'           => esc_html__( 'Normal', 'suit-blog' ),
            'color_2'           => esc_html__( 'Hover', 'suit-blog' )
        ],
        'default'           => [
            'color_1'            => '',
            'color_2'            => ''
        ],
        'priority'          => 30,
        'output'            => [
            [
                'choice'   => 'color_1',
                'element'  => '
                input[type="button"] :not(.slick-arrow >*),
                            input[type="reset"],
                            .suit-blog-btn-primary,
                            .button
                            ',
                'property' => 'color',

            ],
            [
                'choice'   => 'color_1',
                'element'  => '.post-meta-single ul li.post-categories a,.wp-block-search__button, button, a.button, input[type="button"], input[type="reset"], input[type="submit"], .wc-proceed-to-checkout a,.read-more-wrap .btn,.read-more-wrap .btn:visited',
                'property' => '--suit-blog-base-color',

            ],
            [
                'choice'   => 'color_2',
                'element'  => '
                            input[type="button"]:hover :not(.slick-arrow >*),
                            input[type="reset"]:hover,
                            .suit-blog-btn-primary:hover,
                            .button:hover
                            ',
                'property' => 'color',
            ],
            [
                'choice'   => 'color_2',
                'element'  => '.post-meta-single ul li.post-categories a:hover,.wp-block-search__button:hover, input[type="submit"]:hover, button:hover, a.button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, .wc-proceed-to-checkout a:hover,.read-more-wrap .btn:hover',
                'property' => '--suit-blog-base-color',

            ],
        ]
    ],
    'button_background_color'  => [
        'type'              => 'multicolor',
        'label'             => esc_html__( 'Background Color', 'suit-blog' ),
        'description'       => esc_html__( 'Set button background color.', 'suit-blog' ),
        'section'           => 'colors',
        'choices'           => [
            'color_1'           => esc_html__( 'Normal', 'suit-blog' ),
            'color_2'           => esc_html__( 'Hover', 'suit-blog' )
        ],
        'default'           => [
            'color_1'            => '',
            'color_2'            => ''
        ],
        'priority'          => 30,
        'output'            => [
            [
                'choice'   => 'color_1',
                'element'  => '
                            input[type="button"] :not(.slick-arrow >*),
                            input[type="reset"],
                            .suit-blog-btn-primary,
                            .button
                            ',
                'property' => 'background-color',
            ],
            [
                'choice'   => 'color_1',
                'element'  => '.post-meta-single ul li.post-categories a,.wp-block-search__button, button, a.button, input[type="button"], input[type="reset"], input[type="submit"], .wc-proceed-to-checkout a,.read-more-wrap .btn-info',
                'property' => '--suit-blog-accent-color-1',

            ],
            [
                'choice'   => 'color_2',
                'element'  => '
                            input[type="button"]:hover :not(.slick-arrow >*),
                            input[type="reset"]:hover,
                            .suit-blog-btn-primary:hover,
                            .suit-blog-btn-primary.suit-blog-btn-transparent:hover,
                            .button:hover
                            ',
                'property' => 'background-color',
            ],
            [
                'choice'   => 'color_2',
                'element'  => '.post-meta-single ul li.post-categories a:hover,.wp-block-search__button:hover, input[type="submit"]:hover, button:hover, a.button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, .wc-proceed-to-checkout a:hover,.read-more-wrap .btn-info:hover,.read-more-wrap .btn-outline-info:hover',
                'property' => '--suit-blog-accent-color-2',

            ],
        ]
    ],
];
foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );

    Kirki::add_field( 'suit-blog', $field_args );
}