<?php
/**
 * Add Customizer -> Footer -> Footer Rows -> Top Row settings.
 *
 * @package Suit Blog
 */

$fields = array(
	'footer_widgets_group_fields'   => array(
		'type'     => 'group-field',
		'section'  => 'footer_widgets_section',
		'priority' => 5,
		'tabs'     => array(
			'desktop' => array(
				'nicename'   => esc_html__( '&gt; 1200px', 'suit-blog' ),
				'preview'    => 'desktop',
				'active_tab' => true,
				'controls'   => array(
					'footer_widgets_columns',
					'footer_widgets_background',
					'footer_widgets_section_padding',
				),
			),
			'tablet'  => array(
				'nicename'   => esc_html__( '&gt; 768px', 'suit-blog' ),
				'preview'    => 'tablet',
				'active_tab' => false,
				'controls'   => array(
					'footer_widgets_section_md_padding',
				),
			),
			'mobile'  => array(
				'nicename'   => esc_html__( '&lt; 576px', 'suit-blog' ),
				'preview'    => 'mobile',
				'active_tab' => false,
				'controls'   => array(
					'footer_widgets_section_sm_padding',
				),
			),
		),
	),
	'footer_widgets_columns' => [
        'type'              => 'select',
        'label'             => esc_html__( 'Number Of Columns', 'suit-blog' ),
        'section'           => 'footer_widgets_section',
        'default'           => '4',
        'choices'           => [
			'1'             => '1',
            '2'             => '2',
            '3'             => '3',
            '4'             => '4'
        ],
        'priority'          => 10,
    ],
	'footer_widgets_background'         => array(
		'type'      => 'background',
		'section'   => 'footer_widgets_section',
		'priority'  => 15,
		'default'   => array(
			'background-image'      => '',
			'background-repeat'     => 'repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		),
		'transport' => 'auto',
		'output'    => array(
			array(
				'element' => '.site-footer .site-footer-widgets',
			),
		),
	),
	'footer_widgets_section_padding'    => array(
		'type'        => 'dimensions',
		'label'       => esc_html__( 'Padding', 'suit-blog' ),
		'description' => esc_html__( 'Set footer widgets section top and bottom padding.', 'suit-blog' ),
		'section'     => 'footer_widgets_section',
		'priority'    => 20,
		'default'     => array(
			'padding-top'    => '',
			'padding-bottom' => '',
		),
		'choices'     => array(
			'labels' => array(
				'padding-top'    => esc_html__( 'Top', 'suit-blog' ),
				'padding-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
			),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'choice'   => 'padding-top',
				'property' => 'padding-top',
				'element'  => '.site-footer .site-footer-widgets',
			),
			array(
				'choice'   => 'padding-bottom',
				'property' => 'padding-bottom',
				'element'  => '.site-footer .site-footer-widgets',
			),
		),
	),
	'footer_widgets_section_md_padding' => array(
		'type'        => 'dimensions',
		'label'       => esc_html__( 'Padding', 'suit-blog' ),
		'description' => esc_html__( 'Set footer widgets section top and bottom padding.', 'suit-blog' ),
		'section'     => 'footer_widgets_section',
		'priority'    => 20,
		'default'     => array(
			'padding-top'    => '',
			'padding-bottom' => '',
		),
		'choices'     => array(
			'labels' => array(
				'padding-top'    => esc_html__( 'Top', 'suit-blog' ),
				'padding-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
			),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'media_query' => '@media (max-width: 768px)',
				'choice'      => 'padding-top',
				'property'    => 'padding-top',
				'element'     => '.site-footer .site-footer-widgets',
			),
			array(
				'media_query' => '@media (max-width: 768px)',
				'choice'      => 'padding-bottom',
				'property'    => 'padding-bottom',
				'element'     => '.site-footer .site-footer-widgets',
			),
		),
	),
	'footer_widgets_section_sm_padding' => array(
		'type'        => 'dimensions',
		'label'       => esc_html__( 'Padding', 'suit-blog' ),
		'description' => esc_html__( 'Set footer widgets section top and bottom padding.', 'suit-blog' ),
		'section'     => 'footer_widgets_section',
		'priority'    => 20,
		'default'     => array(
			'padding-top'    => '',
			'padding-bottom' => '',
		),
		'choices'     => array(
			'labels' => array(
				'padding-top'    => esc_html__( 'Top', 'suit-blog' ),
				'padding-bottom' => esc_html__( 'Bottom', 'suit-blog' ),
			),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'media_query' => '@media (max-width: 576px)',
				'choice'      => 'padding-top',
				'property'    => 'padding-top',
				'element'     => '.site-footer .site-footer-widgets',
			),
			array(
				'media_query' => '@media (max-width: 576px)',
				'choice'      => 'padding-bottom',
				'property'    => 'padding-bottom',
				'element'     => '.site-footer .site-footer-widgets',
			),
		),
	),

);
foreach ( $fields as $field_id => $field_args ) {
	// Settings
	$field_args['settings'] = str_replace( '-', '_', $field_id );

	Kirki::add_field( 'suit-blog', $field_args );
}
