<?php
/**
 * Add Front Page -> Box settings.
 *
 * @package Suit Blog
 */

$fields = [
    'box_home_page_enable'  => [
        'type'              => 'toggle',
        'label'             => esc_html__( 'Home Page', 'suit-blog' ),
        'description'       => esc_html__( 'Toggle to enable box section on home page only.', 'suit-blog' ),
        'section'           => 'box_section',
        'default'           => true,
        'priority'          => 10,
        'partial_refresh'    => [
            'box_home_page_enable' => [
                'selector'        => '.box-section .box-content-wrapper.position-relative .container.position-relative .box-section',
                'render_callback' => 'suit_blog_box_section',
            ],
        ],
    ],
    'box_single_pages_enable'  => [
        'type'              => 'toggle',
        'label'             => esc_html__( 'Single Pages', 'suit-blog' ),
        'description'       => esc_html__( 'Toggle to enable box section on all single pages.', 'suit-blog' ),
        'section'           => 'box_section',
        'default'           => false,
        'priority'          => 10,
        'partial_refresh'    => [
            'box_single_pages_enable' => [
                'selector'        => '.box-section .box-content-wrapper.position-relative .container.position-relative .box-section',
                'render_callback' => 'suit_blog_box_section',
            ],
        ],
    ],
    'box_single_posts_enable'  => [
        'type'              => 'toggle',
        'label'             => esc_html__( 'Single Posts', 'suit-blog' ),
        'description'       => esc_html__( 'Toggle to enable box section on all single posts.', 'suit-blog' ),
        'section'           => 'box_section',
        'default'           => false,
        'priority'          => 10,
        'partial_refresh'    => [
            'box_single_posts_enable' => [
                'selector'        => '.box-section .box-content-wrapper.position-relative .container.position-relative .box-section',
                'render_callback' => 'suit_blog_box_section',
            ],
        ],
        
    ],
    'box_title_sep' => [
        'type'              => 'custom',
        'section'           => 'box_section',
        'default'           => '<h3 style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'Heading', 'suit-blog' ) . '</h3>',
        'priority'          => 10
    ],

    'frontpage_box_heading'  => [
        'type'              => 'text',
        'label'             => esc_html__( 'Box Heading', 'suit-blog' ),
		'tooltip'      		=> esc_html__( 'Set custom heading for front page boxes. Empty = Disabled', 'suit-blog' ),
        'section'           => 'box_section',
        'default'     		=> esc_html__( 'Front Page Boxes', 'suit-blog' )
    ],

	    'boxes_sep' => [
        'type'              => 'custom',
        'section'           => 'box_section',
        'default'           => '<h3 style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'Boxes', 'suit-blog' ) . '</h3>',
        'priority'          => 10
    ],
	
'boxes_options' => [
        'type' => 'repeater',
        'section' => 'box_section',
        'priority' => 10,
        'row_label' => [
            'type' => 'field',
            'value' => esc_html__( 'Box', 'suit-blog' ),
            'field' => 'title'
        ],
        'button_label' => esc_html__( 'Add New', 'suit-blog' ),
        'settings' => 'boxes_frontpage_boxes_repeater',
        'default' => [],
        'fields' => [
            'title' => [
                'type'        => 'text',
                'label'       => esc_html__( 'Box Title', 'suit-blog' ),
                'description' => esc_html__( 'The box title.', 'suit-blog' ),
                'default'     => '',
            ],
            'image' => [
                'type'        => 'image',
                'label'       => esc_html__( 'Box Image', 'suit-blog' ),
                'description' => esc_html__( 'Upload box image.', 'suit-blog' ),
                'choices'     => [
                    'save_as' => 'url'
                ],
                'default'     => ''
            ],
            'icon'  => [
                'type'        => 'text',
                'label'       => esc_html__( 'Box Icon', 'suit-blog' ),
                'description' => sprintf( '%s <a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">%s</a> %s', esc_html__( 'Enter the', 'suit-blog' ), 'FontAwesome', esc_html__( 'icon name. ex: "fa-tablet"', 'suit-blog' ) ),
                'default'     => '',
            ],
            'icon_color' => [
                'type'        => 'color',
                'label'       => esc_html__( 'Icon Color', 'suit-blog' ),
                'description' => esc_html__( 'Select icon color.', 'suit-blog' ),
                'default'     => '#0258c7'
            ],
            'url' => [
                'type'        => 'link',
                'label'       => esc_html__( 'Box Image/Icon URL', 'suit-blog' ),
                'description' => esc_html__( 'Enter box icon/image url.', 'suit-blog' ),
                'default'     => ''
            ],
            'text' => [
                'type'        => 'textarea',
                'label'       => esc_html__( 'Box Text', 'suit-blog' ),
                'description' => esc_html__( 'Enter box text.', 'suit-blog' ),
                'default'     => ''
            ],
            
        ],
        'choices' => apply_filters( 'suit-blog/frontpage_boxes_choices', [ 'limit' => 4 ] )
    ]
];
foreach ( $fields as $field_id => $field_args ) {
    // Box Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );
    Kirki::add_field( 'suit-blog', $field_args );
}