<?php
/**
 * Add Customizer -> Single Post -> Post title settings.
 *
 * @package Suit Blog
 */

$fields = [
    'single_post_title_html_tag' => [
        'type'              => 'radio_buttonset',
        'label'             => esc_html__( 'HTML Tag', 'suit-blog' ),
        'section'           => 'single_post_title_section',
        'description'       => esc_html__( 'Set post title heading html tag.', 'suit-blog' ),
        'priority'          => 10,
        'default'           => 'h1',
        'choices'           => [
            'h1'                => esc_html__( 'H1', 'suit-blog' ),
            'h2'                => esc_html__( 'H2', 'suit-blog' ),
            'h3'                => esc_html__( 'H3', 'suit-blog' ),
            'h4'                => esc_html__( 'H4', 'suit-blog' ),
            'h5'                => esc_html__( 'H5', 'suit-blog' ),
            'h6'                => esc_html__( 'H6', 'suit-blog' )
        ],
    ]
];
foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );
    Kirki::add_field( 'suit-blog', $field_args );
}