<?php
/**
 * Add Customizer -> Single Post -> Post Navigation settings.
 *
 * @package Suit Blog
 */

$fields = [
    'single_post_navigation_group_fields' => [
        'type'              => 'group-field',
        'section'           => 'single_post_navigation_section',
        'priority'          => 5,
        'tabs'              => [
            'desktop'            => [
                'nicename'      => esc_html__( '&gt; 1200px', 'suit-blog' ),
                'preview'       => 'desktop',
                'active_tab'    => true,
                'controls'      => [
                    'single_post_navigation_sep_1',
                    'single_post_navigation_top_spacing'
                ]
            ],
            'tablet'            => [
                'nicename'      => esc_html__( '&gt; 768px', 'suit-blog' ),
                'preview'       => 'tablet',
                'active_tab'    => false,
                'controls'      => [
                    'single_post_navigation_sep_1',
                    'single_post_navigation_md_top_spacing'
                ]
            ],
            'mobile'            => [
                'nicename'      => esc_html__( '&lt; 576px', 'suit-blog' ),
                'preview'       => 'mobile',
                'active_tab'    => false,
                'controls'      => [
                    'single_post_navigation_sep_1',
                    'single_post_navigation_sm_top_spacing'
                ]
            ]
        ],
    ],
    'single_post_navigation_sep_1' => [
        'type'              => 'custom',
        'section'           => 'single_post_navigation_section',
        'default'           => '<h3 style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'Next/Prev', 'suit-blog' ) . '</h3>',
        'priority'          => 10
    ],
    'single_post_navigation_top_spacing' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Top Spacing', 'suit-blog' ),
        'description'       => esc_html__( 'Set pagination top spacing in PX.', 'suit-blog' ),
        'section'           => 'single_post_navigation_section',
        'priority'          => 10,
        'default'           => '30',
        'choices'           => [
            'suffix'            => 'px',
            'min'               => 0,
            'max'               => 100,
            'step'              => 1
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'element'   => '.single .section-post-container .element-navigation .post-navigation',
                'property'  => 'padding-top',
                'suffix'    => 'px'
            ],
        ],
    ],
    'single_post_navigation_md_top_spacing' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Top Spacing', 'suit-blog' ),
        'description'       => esc_html__( 'Set pagination top spacing in PX.', 'suit-blog' ),
        'section'           => 'single_post_navigation_section',
        'priority'          => 10,
        'default'           => '30',
        'choices'           => [
            'suffix'            => 'px',
            'min'               => 0,
            'max'               => 100,
            'step'              => 1
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query' => '@media (max-width: 768px)',
                'element'   => '.single .section-post-container .element-navigation .post-navigation',
                'property'  => 'padding-top',
                'suffix'    => 'px'
            ],
        ],
    ],
    'single_post_navigation_sm_top_spacing' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Top Spacing', 'suit-blog' ),
        'description'       => esc_html__( 'Set pagination top spacing in PX.', 'suit-blog' ),
        'section'           => 'single_post_navigation_section',
        'priority'          => 10,
        'default'           => '30',
        'choices'           => [
            'suffix'            => 'px',
            'min'               => 0,
            'max'               => 100,
            'step'              => 1
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 576px)',
                'element'   => '.single .section-post-container .element-navigation .post-navigation',
                'property'  => 'padding-top',
                'suffix'    => 'px'
            ],
        ],
    ],
];
foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );
    Kirki::add_field( 'suit-blog', $field_args );
}