<?php
/**
 * Add Customizer -> Blog Posts -> Post Meta settings.
 *
 * @package Suit Blog
 */

$fields = [
    'post_meta_elements' => [
        'type'        => 'sortable',
        'label'       => esc_html__( 'Post Meta', 'suit-blog' ),
        'description' => esc_html__( 'Enable/disable to show the list of post meta and sort them to re-arrange their order.', 'suit-blog' ),
        'section'     => 'post_meta_section',
        'default'     => [
            'post-author',
            'post-date'
        ],
        'choices'     => [
            'post-author'       => esc_html__( 'Post Author', 'suit-blog' ),
            'post-date'         => esc_html__( 'Post Date', 'suit-blog' ),
            'post-cats'         => esc_html__( 'Post Categories', 'suit-blog' ),
            'post-comments'     => esc_html__( 'post Comments', 'suit-blog' )
        ],
        'priority'    => 10,
    ],
];
foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );
    Kirki::add_field( 'suit-blog', $field_args );
}