<?php
/**
 * Add Customizer -> Blog Posts -> Read More Button settings.
 *
 * @package Suit Blog
 */

$fields = [
    'blog_post_read_more_btn_type' => [
        'type'              => 'radio_buttonset',
        'label'             => esc_html__( 'Read More Type', 'suit-blog' ),
        'section'           => 'blog_read_more_btn_section',
        'priority'          => 10,
        'default'           => 'link',
        'choices'           => [
            'link'              => esc_html__( 'Simple', 'suit-blog' ),
            'info'              => esc_html__( 'Button', 'suit-blog' ),
            'outline-info'      => esc_html__( 'Outline', 'suit-blog' )
        ],
    ]
];
foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );
    Kirki::add_field( 'suit-blog', $field_args );
}