<?php
/**
 * Add Customizer -> Blog Posts -> Post Excerpt settings.
 *
 * @package Suit Blog
 */

$fields = [
    'blog_post_excerpt_limit' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Excerpt Limit', 'suit-blog' ),
        'description'       => esc_html__( 'Set post excerpt limit in words.', 'suit-blog' ),
        'section'           => 'blog_post_excerpt_section',
        'priority'          => 10,
        'default'           => 40,
        'choices'           => [
            'min'               => 0,
            'max'               => 55,
            'step'              => 1,
        ]
    ],
];

foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );
    Kirki::add_field( 'suit-blog', $field_args );
}