<?php
/**
 * Add Customizer -> Blog Posts -> Pagination settings.
 *
 * @package Suit Blog
 */

$fields = [
    'blog_pagination_group_fields' => [
        'type'              => 'group-field',
        'section'           => 'blog_pagination_section',
        'priority'          => 5,
        'tabs'              => [
            'desktop'            => [
                'nicename'      => esc_html__( '&gt; 1200px', 'suit-blog' ),
                'preview'       => 'desktop',
                'active_tab'    => true,
                'controls'      => [
                    'blog_pagination_note',
                    'blog_pagination_type',
                    'blog_pagination_top_spacing'
                ]
            ],
            'tablet'            => [
                'nicename'      => esc_html__( '&gt; 768px', 'suit-blog' ),
                'preview'       => 'tablet',
                'active_tab'    => false,
                'controls'      => [
                    'blog_pagination_md_top_spacing'
                ]
            ],
            'mobile'            => [
                'nicename'      => esc_html__( '&lt; 576px', 'suit-blog' ),
                'preview'       => 'mobile',
                'active_tab'    => false,
                'controls'      => [
                    'blog_pagination_sm_top_spacing'
                ]
            ]
        ],
    ],
    'blog_pagination_note' => [
        'type'              => 'custom',
        'section'           => 'blog_pagination_section',
        'description'       => '<p style="border-width:1px 0;border-style: solid;border-color: #fff;margin:0 -11px;padding: 8px 12px;background: #fff;">' . esc_html__( 'NOTE:- All settings will apply for the archive,category,tags,search,author and custom taxonomy pages.', 'suit-blog' ) . '</p>',
        'priority'          => 10
    ],
    'blog_pagination_type' => [
        'type'        => 'select',
        'settings'    => 'blog_pagination_section',
        'label'       => esc_html__( 'Pagination Type', 'suit-blog' ),
        'section'     => 'blog_pagination_section',
        'default'     => 'standard',
        'placeholder' => esc_html__( 'Select an option...', 'suit-blog' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'standard'          => esc_html__( 'Standard', 'suit-blog' ),
            'next-prev'         => esc_html__( 'Next/Prev', 'suit-blog' ),
        ],
    ],
    'blog_pagination_top_spacing' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Top Spacing', 'suit-blog' ),
        'description'       => esc_html__( 'Set pagination top spacing.', 'suit-blog' ),
        'section'           => 'blog_pagination_section',
        'priority'          => 10,
        'default'           => '21',
        'choices'           => [
            'suffix'            => 'px',
            'min'               => 0,
            'max'               => 100,
            'step'              => 1
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'element'       => '.site-main .posts-navigation,.site-main .pagination',
                'property'      => 'margin-top',
                'suffix'        => 'px'
            ],
        ],
    ],
    'blog_pagination_md_top_spacing' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Top Spacing', 'suit-blog' ),
        'description'       => esc_html__( 'Set pagination top spacing for the current screen size.', 'suit-blog' ),
        'section'           => 'blog_pagination_section',
        'priority'          => 10,
        'default'           => '21',
        'choices'           => [
            'suffix'            => 'px',
            'min'               => 0,
            'max'               => 100,
            'step'              => 1
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 768px)',
                'element'       => '.site-main .posts-navigation,.site-main .pagination',
                'property'      => 'margin-top',
                'suffix'        => 'px'
            ],
        ],
    ],
    'blog_pagination_sm_top_spacing' => [
        'type'              => 'slider',
        'label'             => esc_html__( 'Top Spacing', 'suit-blog' ),
        'description'       => esc_html__( 'Set pagination top spacing for the current screen size.', 'suit-blog' ),
        'section'           => 'blog_pagination_section',
        'priority'          => 10,
        'default'           => '21',
        'choices'           => [
            'suffix'            => 'px',
            'min'               => 0,
            'max'               => 100,
            'step'              => 1
        ],
        'transport'         => 'auto',
        'output'            => [
            [
                'media_query'   => '@media (max-width: 576px)',
                'element'       => '.site-main .posts-navigation,.site-main .pagination',
                'property'      => 'margin-top',
                'suffix'        => 'px'
            ],
        ],
    ]
];
foreach ( $fields as $field_id => $field_args ) {
    // Settings
    $field_args['settings'] = str_replace( '-', '_', $field_id );
    Kirki::add_field( 'suit-blog', $field_args );
}