<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Suit Blog
 */

?>


<!doctype html>

<?php
/**
 * Functions hooked into suit_blog_html_before action
 *
 */
do_action( 'suit_blog_html_before' );
?>

<html <?php language_attributes(); ?>>

<head>

    <?php
    /**
     * Functions hooked into suit_blog_head_top action
     *
     */
    do_action( 'suit_blog_head_top' );
    ?>

    <?php
    /**
     * Functions hooked into suit_blog_head action
     *
     * @hooked suit_blog_head_meta - 10
     */
    do_action( 'suit_blog_head' );
    ?>

    <?php
    /**
     * Functions hooked into suit_blog_head_bottom action
     *
     */
    do_action( 'suit_blog_head_bottom' );
    ?>

    <?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php
/**
 * Functions hooked into suit_blog_body_top action
 *
 */
do_action( 'suit_blog_body_top' );
?>

<?php wp_body_open(); ?>

<div id="page" <?php suit_blog_site_class(); ?>>

    <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'suit-blog' ); ?></a>

    <?php
    /**
     * Functions hooked into suit_blog_header_before action
     *
     */
    do_action( 'suit_blog_header_before' );

    $header_classes = ['site-header'];
    if ( get_theme_mod('header_transparent','') ) {
		$header_classes[]  = 'fixed-site-header';
	}
    ?>

    <header id="masthead" class="<?php echo esc_attr( implode( ' ', $header_classes ) );?>">

        <?php
        /**
         * Functions hooked into suit_blog_header_top action
         *
         */
        do_action( 'suit_blog_header_top' );
        ?>

        <?php
        /**
         * Functions hooked into suit_blog_header action
         *
         * @hooked suit_blog_header_main - 10
         */
        do_action( 'suit_blog_header' );
        ?>

        <?php
        /**
         * Functions hooked into suit_blog_header_bottom action
         *
         */
        do_action( 'suit_blog_header_bottom' );
        ?>

    </header><!-- #masthead -->

    <?php
    /**
     * Functions hooked into suit_blog_header_after action
     *
     * @hooked suit_blog_hero_section - 5
     * @hooked suit_blog_box_section - 8
     * @hooked suit_blog_site_content_start - 10
     */
    do_action( 'suit_blog_header_after' );