<?php
/**
 * Suit functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Suit Blog
 */

/**
 * Define Constants
 */
define( 'Suit_Blog_THEME_VERSION', '1.0.0' );
define( 'Suit_Blog_THEME_DIR', trailingslashit( get_template_directory() ) );
define( 'Suit_Blog_THEME_URI', trailingslashit( esc_url( get_template_directory_uri() ) ) );

if ( ! function_exists( 'suit_blog_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function suit_blog_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Suit, use a find and replace
		 * to change 'suit-blog' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'suit-blog', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		/* Slider Thumbnail */
		add_image_size( 'suit-blog-1920-1080', 1920, 1080, true );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'menu-1' => esc_html__( 'Primary Menu', 'suit-blog' ),
				'menu-2' => esc_html__( 'Footer Menu', 'suit-blog' ),
				'menu-3' => esc_html__( 'Top Menu', 'suit-blog' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);

		// Adding excerpt option box for pages as well.
		add_post_type_support( 'page', 'excerpt' );

		// Enable support Gutenberg and Block styles.
        add_theme_support( 'align-wide' );
        add_theme_support( 'responsive-embeds' );
        add_theme_support( 'wp-block-styles' );
	}
endif;
add_action( 'after_setup_theme', 'suit_blog_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function suit_blog_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'suit_blog_content_width', 640 );
}
add_action( 'after_setup_theme', 'suit_blog_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function suit_blog_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'suit-blog' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'suit-blog' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Widgets', 'suit-blog' ),
			'id'            => 'footer-sidebar',
			'description'   => esc_html__( 'Add widgets here.', 'suit-blog' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	for ( $i = 1; $i <= 3; $i++ ) {
		register_sidebar(
			array(
				'name'          => esc_html__( 'Widget ', 'suit-blog' ) . ' ' . $i,
				'id'            => 'footer-sidebar-' . $i,
				'description'   => esc_html__( 'Add widgets here.', 'suit-blog' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="footer-item">',
				'after_widget'  => '</div></div>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);
	}
}
add_action( 'widgets_init', 'suit_blog_widgets_init' );

/**
 * Enqueue scripts and styles.
 */

function suit_blog_scripts() {

	// Google Fonts
	$fonts_url = suit_blog_fonts_url();
    if ( $fonts_url ) {
		require Suit_Blog_THEME_DIR . 'inc/wptt-webfont-loader.php';
		wp_enqueue_style( 'suit-blog-google-fonts', wptt_get_webfont_url( $fonts_url ) );
    	
    }

	// Bootstrap Style
	wp_enqueue_style( 'bootstrap', Suit_Blog_THEME_URI . 'assets/bootstrap/css/bootstrap.min.css' );

	// Font Awesome Style
	wp_enqueue_style( 'fontawesome', Suit_Blog_THEME_URI . '/assets/font-awesome/css/all.min.css' );

	// Meanmenu Style
	wp_enqueue_style( 'meanmenu', Suit_Blog_THEME_URI . '/assets/meanMenu/meanmenu.css' );

	// Theme Style
	wp_enqueue_style( 'suit-blog-style', get_stylesheet_uri(), array(), Suit_Blog_THEME_VERSION );
	wp_enqueue_style( 'suit-blog-main-style', Suit_Blog_THEME_URI . 'assets/css/main.css' );
	wp_enqueue_style( 'suit-blog-responsive', Suit_Blog_THEME_URI . 'assets/css/responsive.css' );

	// Add output of Customizer settings as inline style.
	wp_add_inline_style( 'suit-blog-main-style', suit_blog_Customizer_Inline_Style::css_output( 'front-end' ) );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// Scripts
	$scripts = array(
		array(
			'id'      => 'meanmenu',
			'url'     => Suit_Blog_THEME_URI . 'assets/meanMenu/jquery.meanmenu.min.js',
			'version' => '2.0.8',
			'footer'  => true,
		),
		array(
			'id'      => 'marquee',
			'url'     => Suit_Blog_THEME_URI . 'assets/marquee/jquery.marquee.min.js',
			'version' => '1.6.0',
			'footer'  => true,
		),
		array(
			'id'      => 'suit-blog-skip-link-focus-fix',
			'url'     => Suit_Blog_THEME_URI . 'assets/js/skip-link-focus-fix.js',
			'version' => Suit_Blog_THEME_VERSION,
			'footer'  => true,
		),
		array(
			'id'      => 'suit-blog-custom',
			'url'     => Suit_Blog_THEME_URI . 'assets/js/custom.js',
			'version' => Suit_Blog_THEME_VERSION,
			'footer'  => true,
		),
		array(
			'id'      => 'suit-blog-navigation',
			'url'     => Suit_Blog_THEME_URI . 'assets/js/navigation.js',
			'version' => Suit_Blog_THEME_VERSION,
			'footer'  => true,
		),
	);
	suit_blog_add_scripts( $scripts );
}

add_action( 'wp_enqueue_scripts', 'suit_blog_scripts' );

/**
 * Add script
 *
 * @since 1.0.0
 */
function suit_blog_add_scripts( $scripts ) {
	foreach ( $scripts as $key => $value ) {
		wp_enqueue_script( $value['id'], $value['url'], array( 'jquery' ), $value['version'], $value['footer'] );
	}
}

/**
 * Custom template tags for this theme.
 */
require Suit_Blog_THEME_DIR . 'inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require Suit_Blog_THEME_DIR . 'inc/template-functions.php';

/**
 * Trail Breadcrumb
 */
require Suit_Blog_THEME_DIR . 'inc/classes/Suit_Blog_Breadcrumb_Trail.php';

/**
 * Helper Functions
 */
require Suit_Blog_THEME_DIR . 'inc/helper-functions.php';

/**
 * Load theme meta box
 */
require Suit_Blog_THEME_DIR . 'inc/meta-boxes/Suit_Blog_Meta_Boxes.php';

/**
 * Required Plugins
 */
require Suit_Blog_THEME_DIR . 'inc/tgm/suit-blog-required-plugins.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require Suit_Blog_THEME_DIR . 'inc/compatibility/jetpack/jetpack.php';
}

/**
 * Load WooCommerce compatibility file.
 */
if ( class_exists( 'WooCommerce' ) ) {
	require Suit_Blog_THEME_DIR . 'inc/compatibility/woocommerce/woocommerce.php';
}

/**
 * Load hooks file.
 */
require Suit_Blog_THEME_DIR . 'inc/hooks/hooks.php';
require Suit_Blog_THEME_DIR . 'inc/hooks/functions.php';


/**
 * Customizer additions.
 */
require Suit_Blog_THEME_DIR . 'inc/customizer/class-suit-blog-customizer.php';

/**
 * Customizer outputs
 */
require Suit_Blog_THEME_DIR . 'inc/customizer/Suit_Blog_Customizer_Inline_Style.php';

/**
 * Kirki
 */
require Suit_Blog_THEME_DIR . 'inc/compatibility/kirki/Suit_Blog_Kirki.php';