<?php 
load_theme_textdomain('stripestheme');
$GLOBALS['content_width'] = 500;

function resize_youtube($content) {
	return str_replace("width=\"425\" height=\"344\"", "width=\"506\" height=\"406\"",$content);
}
add_filter('the_content','resize_youtube',999);

if ( function_exists('register_sidebar') ) {
    register_sidebar(array(
        'name' => __('Left sidebar','stripestheme'),
        'before_widget' => '',
        'after_widget' => '',
        'before_title' => '<h2>',
        'after_title' => '</h2>',
    ));
    register_sidebar(array(
        'name' => __('Right sidebar','stripestheme'),
        'before_widget' => '',
        'after_widget' => '',
        'before_title' => '<h2>',
        'after_title' => '</h2>',
    ));    
}

function comment_count2() {
	global $id;
	$comments_by_type = &separate_comments(get_comments('post_id=' . $id));
	return count($comments_by_type['comment']);
}

function set_canonical() {
  if ( is_single() ) {
    global $wp_query;
    echo '<link rel="canonical" href="'.get_permalink($wp_query->post->ID).'"/>';
  }
}
add_action('wp_head', 'set_canonical');

function comentario($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
   <li <?php comment_class(); ?> id="comment-<?php comment_ID() ?>">
      <div class="comment-avatar">
         <?php echo get_avatar($comment,$size='50'); ?>
      </div>
      <div class="comment-main">
        <div class="comment-metadata">
          <div class="comment-author"><?php comment_author_link(); ?></div>
          <div class="comment-date"><?php comment_date(__('CommentDateFormat','stripestheme')); ?></div>
          <?php edit_comment_link(__('Edit','stripestheme'),'',''); ?>
        </div>
        
        <div class="comment-text">
          <?php comment_text() ?>
        </div>
        
        <?php if ($comment->comment_approved == '0') : ?>
         <p><em><?php _e('Your comment has to be approved first.','stripestheme'); ?></em></p>
        <?php endif; ?>
      </div>      
<?php
}


function list_pings($comment, $args, $depth) {
       $GLOBALS['comment'] = $comment;
?>
        <li id="comment-<?php comment_ID(); ?>"><?php comment_author_link(); ?>
<?php } ?>
