<?php
/**
 * @package WordPress
 * @subpackage Default_Theme
 */

get_header();
?>

	<div id="content" class="narrowcolumn" role="main">

		<?php if (have_posts()) : ?>

 	  <?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
 	  <?php /* If this is a category archive */ if (is_category()) { ?>
		<h5 class="pagetitle">Archive for the &#8216;<?php single_cat_title(); ?>&#8217; Category</h5>
 	  <?php /* If this is a tag archive */ } elseif( is_tag() ) { ?>
		<h5 class="pagetitle">Posts Tagged &#8216;<?php single_tag_title(); ?>&#8217;</h5>
 	  <?php /* If this is a daily archive */ } elseif (is_day()) { ?>
		<h5 class="pagetitle">Archive for <?php the_time('F jS, Y'); ?></h5>
 	  <?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
		<h5 class="pagetitle">Archive for <?php the_time('F, Y'); ?></h5>
 	  <?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
		<h5 class="pagetitle">Archive for <?php the_time('Y'); ?></h5>
	  <?php /* If this is an author archive */ } elseif (is_author()) { ?>
		<h5 class="pagetitle">Author Archive</h5>
 	  <?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
		<h5 class="pagetitle">Blog Archives</h5>
 	  <?php } ?>


		<div class="navigation">
			<div class="alignleft"><?php next_posts_link('&laquo; Older Entries') ?></div>
			<div class="alignright"><?php previous_posts_link('Newer Entries &raquo;') ?></div>
		</div>

		<?php while (have_posts()) : the_post(); ?>
		<div <?php post_class() ?>>
				<h3 id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
				<small><?php the_time('l, F jS, Y') ?></small>

				<div class="entry">
					<?php the_content() ?>
				</div>

				<p class="postmetadata"><?php the_tags('Tags: ', ', ', '<br />'); ?> Posted in <?php the_category(', ') ?> | <?php edit_post_link('Edit', '', ' | '); ?>  <?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;'); ?></p>

			</div>

		<?php endwhile; ?>

		<div class="navigation">
			<div class="alignleft"><?php next_posts_link('&laquo; Older Entries') ?></div>
			<div class="alignright"><?php previous_posts_link('Newer Entries &raquo;') ?></div>
		</div>
	<?php else :

		if ( is_category() ) { // If this is a category archive
			printf("<h5 class='center'>Sorry, but there aren't any posts in the %s category yet.</h5>", single_cat_title('',false));
		} else if ( is_date() ) { // If this is a date archive
			echo("<h5>Sorry, but there aren't any posts with this date.</h5>");
		} else if ( is_author() ) { // If this is a category archive
			$userdata = get_userdatabylogin(get_query_var('author_name'));
			printf("<h5 class='center'>Sorry, but there aren't any posts by %s yet.</h5>", $userdata->display_name);
		} else {
			echo("<h5 class='center'>No posts found.</h5>");
		}
		get_search_form();

	endif;
?>

	</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
