<?php
/**
	 * Must Read section
	 */
	// Must Read section
	$wp_customize->add_section(
		'storyplus_must_read',
		array(
			'title' => esc_html__( 'Must Read Post', 'storyplus' ),
			'panel' => 'writely_blog_home_panel',
		)
	);

	// Must Read Section enable setting
	$wp_customize->add_setting(
		'storyplus_must_read_section_enable',
		array(
			'sanitize_callback' => 'writely_blog_sanitize_checkbox',
			'default' => false,
		)
	);

	$wp_customize->add_control(
		'storyplus_must_read_section_enable',
		array(
			'section'		=> 'storyplus_must_read',
			'label'			=> esc_html__( 'Enable Must Read Section.', 'storyplus' ),
			'type'			=> 'checkbox',
		)
	);

	// Must Read title setting
	$wp_customize->add_setting(
		'storyplus_must_read_title',
		array(
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'storyplus_must_read_title',
		array(
			'section'		=> 'storyplus_must_read',
			'label'			=> esc_html__( 'Title:', 'storyplus' ),
		)
	);


	// Slider number setting
	$wp_customize->add_setting(
		'storyplus_must_read_secion_excerpt',
		array(
			'sanitize_callback' => 'writely_blog_sanitize_number_range',
			'default' => 50,
			'transport'	=> 'postMessage',
		)
	);

	$must_read_num = get_theme_mod( 'storyplus_must_read_num', 6 );
	for ( $i=1; $i <= $must_read_num; $i++ ) { 

		// Popular post setting
		$wp_customize->add_setting(
			'storyplus_must_read_post_' . $i,
			array(
				'sanitize_callback' => 'writely_blog_sanitize_dropdown_pages',
			)
		);

		$wp_customize->add_control(
			'storyplus_must_read_post_' . $i,
			array(
				'section'		=> 'storyplus_must_read',
				'label'			=> esc_html__( 'Post ', 'storyplus' ) . $i,
				
				'type'			=> 'select',
				'choices'		=> writely_blog_get_post_choices(),
			)
		);
		
	}
?>