<?php
/**
	 * Popular section
	 */
	// Popular section
	$wp_customize->add_section(
		'storyplus_popular',
		array(
			'title' => esc_html__( 'Popular Post', 'storyplus' ),
			'panel' => 'writely_blog_home_panel',
		)
	);

	// Popular Section enable setting
	$wp_customize->add_setting(
		'storyplus_popular_section_enable',
		array(
			'sanitize_callback' => 'writely_blog_sanitize_checkbox',
			'default' => true,
		)
	);

	$wp_customize->add_control(
		'storyplus_popular_section_enable',
		array(
			'section'		=> 'storyplus_popular',
			'label'			=> esc_html__( 'Enable Popular Section.', 'storyplus' ),
			'type'			=> 'checkbox',
		)
	);

	// Popular title setting
	$wp_customize->add_setting(
		'storyplus_popular_title',
		array(
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'storyplus_popular_title',
		array(
			'section'		=> 'storyplus_popular',
			'label'			=> esc_html__( 'Title:', 'storyplus' ),
		)
	);

	// Popular number setting
	$wp_customize->add_setting(
		'storyplus_popular_num',
		array(
			'sanitize_callback' => 'writely_blog_sanitize_number_range',
			'default' => 5,
			'transport'	=> 'postMessage',
		)
	);

	$wp_customize->add_control(
		'storyplus_popular_num',
		array(
			'section'		=> 'storyplus_popular',
			'label'			=> esc_html__( 'Number of popular:', 'storyplus' ),
			'description'			=> esc_html__( 'Min: 1 | Max: 21', 'storyplus' ),
			
			'type'			=> 'number',
			'input_attrs'	=> array( 'min' => 1,'max' => 21,'step' => 1 ),
		)
	);
	// Popular Excerpt setting
	$wp_customize->add_setting(
		'storyplus_popular_secion_excerpt',
		array(
			'sanitize_callback' => 'writely_blog_sanitize_number_range',
			'default' => 20,
			'transport'	=> 'postMessage',
		)
	);

	$wp_customize->add_control(
		'storyplus_popular_secion_excerpt',
		array(
			'section'		=> 'storyplus_popular',
			'label'			=> esc_html__( 'Excerpt Length', 'storyplus' ),
			'description'			=> esc_html__( 'Min: 10 | Max: 300', 'storyplus' ),
			
			'type'			=> 'number',
			'input_attrs'	=> array( 'min' => 10, 'max' => 300 ),
		)
	);
	// Popular category setting
	$wp_customize->add_setting(
		'storyplus_popular_cat',
		array(
			'sanitize_callback' => 'writely_blog_sanitize_select',
		)
	);

	$wp_customize->add_control(
		'storyplus_popular_cat',
		array(
			'section'		=> 'storyplus_popular',
			'label'			=> esc_html__( 'Category:', 'writely-blog-pro' ),
			'type'			=> 'select',
			'choices'		=> writely_blog_get_post_cat_choices(),
		)
	);

?>