<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( ! function_exists( 'storyplus_enqueue_styles' ) ) :
    /**
     * Load assets.
     *
     * @since 1.0.0
     */
    function storyplus_enqueue_styles() {
        wp_enqueue_style( 'storyplus-style-parent', get_template_directory_uri() . '/style.css' );
        wp_enqueue_style( 'storyplus-style', get_stylesheet_directory_uri() . '/style.css', array( 'storyplus-style-parent' ), '1.0.0' );
        wp_enqueue_script( 'storyplus-body-custom', get_theme_file_uri( '/body-class.js' ), array( 'jquery' ), '20151215', true );
    }
endif;
add_action( 'wp_enqueue_scripts', 'storyplus_enqueue_styles', 10 );

if ( ! function_exists( 'storyplus_customize_backend_styles' ) ) :
    /**
     * Load assets.
     *
     * @since 1.0.0
     */
    function storyplus_customize_backend_styles() {
        wp_enqueue_style( 'storyplus-style', get_stylesheet_directory_uri() . '/customizer-style.css' );
    }
endif;
add_action( 'customize_controls_enqueue_scripts', 'storyplus_customize_backend_styles', 99 );

require get_stylesheet_directory() . '/inc/customizer/customizer.php';

function storyplus_body_classes( $classes ) {

if ( writely_blog_is_frontpage_blog() || writely_blog_is_latest_posts() ) { // When global post sidebar is checked.
    $page_id = get_option( 'page_for_posts' );
      $writely_blog_page_sidebar_meta = get_post_meta( $page_id, 'writely-blog-select-sidebar', true);
      if ( ! empty( $writely_blog_page_sidebar_meta ) ) {
        $classes[] = esc_attr( $writely_blog_page_sidebar_meta ) . '-sidebar';
        } else {
        $blog_post_sidebar = get_theme_mod( 'writely_blog_blog_sidebar', 'no' ); 
        $classes[] = esc_attr( $blog_post_sidebar ) . '-sidebar';
      }
  }
}