<?php
function storewise_css() {
	$parent_style = 'storebiz-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'storewise-style', get_stylesheet_uri(), array( $parent_style ));
	
	wp_enqueue_style('storewise-media-query',get_stylesheet_directory_uri().'/assets/css/responsive.css');
	wp_dequeue_style('storebiz-media-query');
}
add_action( 'wp_enqueue_scripts', 'storewise_css',999);
   	

/**
 * Import Options From Parent Theme
 *
 */
function storewise_parent_theme_options() {
	$storebiz_mods = get_option( 'theme_mods_storebiz' );
	if ( ! empty( $storebiz_mods ) ) {
		foreach ( $storebiz_mods as $storebiz_mod_k => $storebiz_mod_v ) {
			set_theme_mod( $storebiz_mod_k, $storebiz_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'storewise_parent_theme_options' );


require( get_stylesheet_directory() . '/inc/customizer/customizer-pro/class-customize.php');