<?php


?>

<div id="storeprima-tabs-container" class="storeprima-tabs-one-container">
	
	<div class="storeprima-tabs-one-heading">
		
		<span data-storeprima-tab="rated" class="storeprima-tabs-active"><?php esc_html_e( "Top Rated", "store-prima" ); ?></span><span data-storeprima-tab="sales"><?php esc_html_e( "Most Sales", "store-prima" ); ?></span><!--<span data-storeprima-tab="viewed">Most Wishlisted</span>-->
		
	</div>
	
	<div class="storeprima-tabs-one-content">
		
		<div class="storeprima-tabs-one-content-inner">
		
			<div data-storeprima-tab="rated" class="storeprima-tabs-one-content-rated">

				<?php 
				
					$store_prima_rated_query = '';
				
					if( class_exists( 'WooCommerce' ) ):
					$store_prima_rated_query_args = array(
						'posts_per_page' => (int)get_theme_mod('store_prima_tabs_item_num', 6),
						'no_found_rows'  => 0,
						'post_status'    => 'publish',
						'post_type'      => 'product',
						'meta_key'       => '_wc_average_rating',
						'orderby'        => 'meta_value_num',
						'order'          => 'DESC',
						'meta_query'     => WC()->query->get_meta_query(),
						'tax_query'      => WC()->query->get_tax_query(),
					); // WPCS: slow query ok.
				
					$store_prima_rated_query = new WP_Query( $store_prima_rated_query_args );
					if ( $store_prima_rated_query->have_posts() ): 
					while ( $store_prima_rated_query->have_posts() ):
					$store_prima_rated_query->the_post();
				
					$store_prima_rated_product_id = get_the_ID();
				
					$store_prima_rated_product = wc_get_product( $store_prima_rated_product_id );
				
					$store_prima_rated_product_image = wp_get_attachment_image_src( $store_prima_rated_product->get_image_id(), 'full' );
				
					$store_prima_products_product_orig_price = $store_prima_rated_product->get_regular_price();
					$store_prima_products_product_sale_price = $store_prima_rated_product->get_sale_price();
					$store_prima_products_product_on_sale = $store_prima_rated_product->is_on_sale();
					$store_prima_products_product_currency = get_woocommerce_currency_symbol();
					$store_prima_products_product_type = $store_prima_rated_product->get_type();				
				
				?>
				<div class="storeprima-tabs-one-content-item">

					<div class="storeprima-tabs-one-content-item-image">
						<img src="<?php echo esc_url($store_prima_rated_product_image[0]); ?>" />
					</div>
					<div class="storeprima-tabs-one-content-item-content">

						<h3><a href="<?php echo esc_url($store_prima_rated_product->get_permalink()); ?>"><?php echo esc_html($store_prima_rated_product->get_name()); ?></a></h3>
						<p><?php echo esc_html($store_prima_rated_product->get_short_description()); ?></p>
						<p>
							<?php if( "variable" == $store_prima_products_product_type ): ?>

								<span class="storeprima-tabs-one-item-price-sale"><?php echo esc_html($store_prima_rated_product->get_price_html()); ?></span>

							<?php else : ?>

								<?php if( "" != $store_prima_products_product_sale_price ): ?>

									<span class="storeprima-tabs-one-item-price-orig"><s><?php echo esc_html($store_prima_products_product_currency) .'' . esc_html($store_prima_products_product_orig_price); ?></s></span>
									<span class="storeprima-tabs-one-item-price-sale"><?php echo esc_html($store_prima_products_product_currency) .'' . esc_html($store_prima_products_product_sale_price); ?></span>

								<?php else : ?>

									<span class="storeprima-tabs-one-item-price-sale"><?php echo esc_html($store_prima_products_product_currency) .'' . esc_html($store_prima_products_product_orig_price); ?></span>

								<?php endif; ?>						

							<?php endif; ?>								
						</p>
						<p class="storeprima-tabs-one-content-item-content-add-to-cart"><a href="<?php echo esc_url($store_prima_rated_product->get_permalink()); ?>"><?php esc_html_e( "Details", "store-prima" ); ?></a></p>

					</div>			

				</div>
				<?php endwhile; endif; wp_reset_postdata(); endif;?>
				
				<?php if( !class_exists( 'WooCommerce' ) || ( class_exists( 'WooCommerce' ) && !$store_prima_rated_query->have_posts()) ): ?>
				
				<div class="storeprima-tabs-one-content-item">

					<div class="storeprima-tabs-one-content-item-image">
						<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
					</div>
					<div class="storeprima-tabs-one-content-item-content">

						<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
						<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
						<p>
							<span class="storeprima-tabs-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
						</p>
						<p class="storeprima-tabs-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

					</div>			

				</div>				
				
				<div class="storeprima-tabs-one-content-item">

					<div class="storeprima-tabs-one-content-item-image">
						<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
					</div>
					<div class="storeprima-tabs-one-content-item-content">

						<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
						<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
						<p>
							<span class="storeprima-tabs-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
						</p>
						<p class="storeprima-tabs-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

					</div>			

				</div>
				
				<div class="storeprima-tabs-one-content-item">

					<div class="storeprima-tabs-one-content-item-image">
						<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
					</div>
					<div class="storeprima-tabs-one-content-item-content">

						<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
						<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
						<p>
							<span class="storeprima-tabs-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
						</p>
						<p class="storeprima-tabs-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

					</div>			

				</div>
				
				<div class="storeprima-tabs-one-content-item">

					<div class="storeprima-tabs-one-content-item-image">
						<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
					</div>
					<div class="storeprima-tabs-one-content-item-content">

						<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
						<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
						<p>
							<span class="storeprima-tabs-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
						</p>
						<p class="storeprima-tabs-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

					</div>			

				</div>				
				
				<?php endif;?>

			</div>

			<div data-storeprima-tab="sales" class="storeprima-tabs-one-content-sales">

				<?php 
				
					$store_prima_sold_query = '';
				
					if( class_exists( 'WooCommerce' ) ):
				
					$store_prima_sold_query_args = array(
						'posts_per_page' => (int)get_theme_mod('store_prima_tabs_item_num', 6),
						'no_found_rows'  => 1,
						'post_status'    => 'publish',
						'post_type'      => 'product',
						'meta_key'       => 'total_sales',
						'orderby'        => 'meta_value_num',
						'order'          => 'DESC',
						'meta_query'     => WC()->query->get_meta_query(),
						'tax_query'      => WC()->query->get_tax_query(),
					); // WPCS: slow query ok.
				
					$store_prima_sold_query = new WP_Query( $store_prima_sold_query_args );
					if ( $store_prima_sold_query->have_posts() ): 
					while ( $store_prima_sold_query->have_posts() ):
					$store_prima_sold_query->the_post();
				
					$store_prima_sold_product_id = get_the_ID();
				
					$store_prima_sold_product = wc_get_product( $store_prima_sold_product_id );
				
					$store_prima_sold_product_image = wp_get_attachment_image_src( $store_prima_sold_product->get_image_id(), 'full' );
				
					$store_prima_products_product_orig_price = $store_prima_sold_product->get_regular_price();
					$store_prima_products_product_sale_price = $store_prima_sold_product->get_sale_price();
					$store_prima_products_product_on_sale = $store_prima_sold_product->is_on_sale();
					$store_prima_products_product_currency = get_woocommerce_currency_symbol();
					$store_prima_products_product_type = $store_prima_sold_product->get_type();				
				
				?>
				<div class="storeprima-tabs-one-content-item">

					<div class="storeprima-tabs-one-content-item-image">
						<img src="<?php echo esc_url($store_prima_sold_product_image[0]); ?>" />
					</div>
					<div class="storeprima-tabs-one-content-item-content">

						<h3><a href="<?php echo esc_url($store_prima_sold_product->get_permalink()); ?>"><?php echo esc_html($store_prima_sold_product->get_name()); ?></a></h3>
						<p><?php echo esc_html($store_prima_sold_product->get_short_description()); ?></p>
						<p>
							<?php if( "variable" == $store_prima_products_product_type ): ?>

								<span class="storeprima-tabs-one-item-price-sale"><?php echo esc_html($store_prima_sold_product->get_price_html()); ?></span>

							<?php else : ?>

								<?php if( "" != $store_prima_products_product_sale_price ): ?>

									<span class=".storeprima-tabs-one-item-price-orig"><s><?php echo esc_html($store_prima_products_product_currency) .'' . esc_html($store_prima_products_product_orig_price); ?></s></span>
									<span class="storeprima-tabs-one-item-price-sale"><?php echo esc_html($store_prima_products_product_currency) .'' . esc_html($store_prima_products_product_sale_price); ?></span>

								<?php else : ?>

									<span class="storeprima-tabs-one-item-price-sale"><?php echo esc_html($store_prima_products_product_currency) .'' . esc_html($store_prima_products_product_orig_price); ?></span>

								<?php endif; ?>						

							<?php endif; ?>	
						</p>
						<p class="storeprima-tabs-one-content-item-content-add-to-cart"><a href="<?php echo esc_url($store_prima_sold_product->get_permalink()); ?>"><?php esc_html_e( "Details", "store-prima" ) ?></a></p>

					</div>			

				</div>
				<?php endwhile; endif; wp_reset_postdata(); endif; ?>	
				
				<?php if( !class_exists( 'WooCommerce' ) || ( class_exists( 'WooCommerce' ) && !$store_prima_sold_query->have_posts()) ): ?>
				<div class="storeprima-tabs-one-content-item">

					<div class="storeprima-tabs-one-content-item-image">
						<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
					</div>
					<div class="storeprima-tabs-one-content-item-content">

						<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
						<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
						<p>
							<span class="storeprima-tabs-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
						</p>
						<p class="storeprima-tabs-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

					</div>			

				</div>			
				
				<div class="storeprima-tabs-one-content-item">

					<div class="storeprima-tabs-one-content-item-image">
						<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
					</div>
					<div class="storeprima-tabs-one-content-item-content">

						<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
						<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
						<p>
							<span class="storeprima-tabs-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
						</p>
						<p class="storeprima-tabs-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

					</div>			

				</div>
				
				<div class="storeprima-tabs-one-content-item">

					<div class="storeprima-tabs-one-content-item-image">
						<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
					</div>
					<div class="storeprima-tabs-one-content-item-content">

						<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
						<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
						<p>
							<span class="storeprima-tabs-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
						</p>
						<p class="storeprima-tabs-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

					</div>			

				</div>
				
				<div class="storeprima-tabs-one-content-item">

					<div class="storeprima-tabs-one-content-item-image">
						<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
					</div>
					<div class="storeprima-tabs-one-content-item-content">

						<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
						<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
						<p>
							<span class="storeprima-tabs-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
						</p>
						<p class="storeprima-tabs-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

					</div>			

				</div>				
				
				<?php endif;?>

			</div>

			<div data-storeprima-tab="viewed" class="storeprima-tabs-one-content-viewed">

	

			</div>			
			
		</div>		
		
	</div>	
	
</div>