<div id="storeprima-slider-container" class="storeprima-slider-one-container">

	<?php
		
		global $store_prima_meta_options;
	
		$store_prima_featured_products = get_posts(
			array(
				'post_type'=>"product", 
				'meta_key'   => 'store_prima_show_in_product_slider',
				'meta_value' => 'yes',
				'ignore_sticky_posts' => 1,
				'posts_per_page'=> get_theme_mod('store_prima_product_slider_num', 5),
				'fields' => 'ids',
			)
		);

		$store_prima_featured_product_num = 0;
	
		if( !empty($store_prima_featured_products) ):
		foreach( $store_prima_featured_products as $i ) :
	
			$store_prima_featured_product_orig_price = "";
			$store_prima_featured_product_sale_price = "";
			$store_prima_featured_product_on_sale = false;
			$store_prima_featured_product_currency = "";
			$store_prima_featured_product_type = "";
			$store_prima_featured_product_name = "";
			$store_prima_featured_product_desc = "";
			$store_prima_featured_product_currency = get_woocommerce_currency_symbol();
			$store_prima_featured_product_slide_type = 'storeprima-slider-one-item-type-two';
			$store_prima_featured_product_slide_bg = get_template_directory_uri() . '/assets/images/product-bg-01.jpg';
			$store_prima_featured_product_slide_bg_position = "top right";

			if( ctype_digit( $i ) ){

				$store_prima_featured_product = wc_get_product( $i );

				$store_prima_featured_product_orig_price = $store_prima_featured_product->get_regular_price();
				$store_prima_featured_product_sale_price = $store_prima_featured_product->get_sale_price();
				$store_prima_featured_product_on_sale = $store_prima_featured_product->is_on_sale();
				$store_prima_featured_product_type = $store_prima_featured_product->get_type();
				$store_prima_featured_product_image = wp_get_attachment_image_src( $store_prima_featured_product->get_image_id(), 'full' );
				$store_prima_featured_product_name = $store_prima_featured_product->get_name();
				$store_prima_featured_product_desc = $store_prima_featured_product->get_short_description();			

			}

			$store_prima_featured_product_slide_type_setting = get_post_meta($i, "store_prima_product_slide_type", true );
			$store_prima_featured_product_slide_overlay_type_setting = get_post_meta($i, "store_prima_product_slide_overlay_type", true );
			if( 'select' != $store_prima_featured_product_slide_type_setting && '' != $store_prima_featured_product_slide_type_setting ){
				
				$store_prima_featured_product_slide_overlay_type = "storeprima-slider-one-item-type-one-black";
				
				if( 'one' == $store_prima_featured_product_slide_type_setting ){
					$store_prima_featured_product_slide_type = 'storeprima-slider-one-item-type-one';
					$store_prima_featured_product_slide_bg = $store_prima_featured_product_image[0];
					$store_prima_featured_product_slide_bg_position = "top right";
				}
				if( 'two' == $store_prima_featured_product_slide_type_setting ){
					$store_prima_featured_product_slide_type = 'storeprima-slider-one-item-type-two';
					$store_prima_featured_product_slide_bg = get_template_directory_uri() . '/assets/images/product-bg-01.jpg';
					$store_prima_featured_product_slide_bg_position = "top right";
				}				
				if( 'three' == $store_prima_featured_product_slide_type_setting ){
					$store_prima_featured_product_slide_type = 'storeprima-slider-one-item-type-three';
					$store_prima_featured_product_slide_bg = $store_prima_featured_product_image[0];
					$store_prima_featured_product_slide_bg_position = "top left";
				}				
				
			}
	
			foreach( $store_prima_meta_options['overlay_type'] as $key => $value ){
						
				if( $key == $store_prima_featured_product_slide_overlay_type_setting ){
					$store_prima_featured_product_slide_overlay_type = $store_prima_featured_product_slide_type . '-' . $key;
				}
						
			}
	
			$store_prima_featured_product_slide_bg_setting = get_post_meta($i, "store_prima_product_slide_bg_position", true );
			if( 'select' != $store_prima_featured_product_slide_bg_setting && '' != $store_prima_featured_product_slide_bg_setting ){
				$store_prima_featured_product_slide_bg_position = $store_prima_featured_product_slide_bg_setting;
			}

	?>
	

	<div class="storeprima-slider-one-item <?php echo esc_attr($store_prima_featured_product_slide_type) . ' ' . esc_attr($store_prima_featured_product_slide_overlay_type); ?>" style="background:url('<?php echo esc_url($store_prima_featured_product_slide_bg); ?>') <?php echo esc_attr($store_prima_featured_product_slide_bg_position); ?> no-repeat">

		<div class="storeprima-slider-one-item-overlay">
		
			<div class="storeprima-slider-one-item-image">
				<img src="<?php echo esc_url($store_prima_featured_product_image[0]); ?>" />
			</div>
		
			<div class="storeprima-slider-one-item-content">
				<h3><?php echo esc_html($store_prima_featured_product_name); ?></h3>
				<p><?php echo esc_html($store_prima_featured_product_desc); ?></p>
				<p>
					<?php if( "variable" == $store_prima_featured_product_type ): ?>
					
						<span class="storeprima-slider-one-item-price-sale"><?php echo esc_html($store_prima_featured_product->get_price_html()); ?></span>
					
					<?php else : ?>
					
						<?php if( "" != $store_prima_featured_product_sale_price ): ?>

							<span class="storeprima-slider-one-item-price-orig"><s><?php echo esc_html($store_prima_featured_product_currency) .'' . esc_html($store_prima_featured_product_orig_price); ?></s></span>
							<span class="storeprima-slider-one-item-price-sale"><?php echo esc_html($store_prima_featured_product_currency) .'' . esc_html($store_prima_featured_product_sale_price); ?></span>

						<?php else : ?>

							<span class="storeprima-slider-one-item-price-sale"><?php echo esc_html($store_prima_featured_product_currency) .'' . esc_html($store_prima_featured_product_orig_price); ?></span>

						<?php endif; ?>						
					
					<?php endif; ?>		
				</p>
				<p><a href="<?php echo esc_url($store_prima_featured_product->get_permalink()); ?>" ><?php esc_html_e('Buy Now', 'store-prima'); ?></a></p>
			</div>
		
		</div>	
	
	</div>
	<?php endforeach; else:?>
		
	<div class="storeprima-slider-one-item storeprima-slider-one-item-type-three" style="background:url('<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/slide-04.jpg') bottom left no-repeat">
		

		<div class="storeprima-slider-one-item-overlay storeprima-slider-slide-2" style="">
		
			<div class="storeprima-slider-one-item-image">
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/slide-01.jpg" />
			</div>
		
			<div class="storeprima-slider-one-item-content" style="padding: 7% 0 7% 60%;">
				<h3 ><?php esc_html_e('New year Sale - UpTo 75% Off', 'store-prima'); ?></h3>
				<p ><?php esc_html_e('This is demo text, please add some products and vanish me. This is demo text, please add some products and vanish me.', 'store-prima'); ?></p>
				<p>
					<span class="storeprima-slider-one-item-price-sale" ><?php esc_html_e('$44', 'store-prima'); ?></span>		
				</p>
				<p><a  href="#" ><?php esc_html_e('Shop Now', 'store-prima'); ?></a></p>
			</div>
					
		</div>	
	
	</div>		
		
	<?php endif; ?>	

</div>