<?php

		$store_prima_sale_query = array();

		$store_prima_sale_num = get_theme_mod('store_prima_sale_num', 6);
		$store_prima_sale_num_now = 0;

		if( class_exists( 'WooCommerce' ) ){
			$store_prima_sale_query = wc_get_product_ids_on_sale();
		}

?>

<div id="storeprima-sale-container" class="storeprima-sale-one-container">

	<div class="storeprima-sale-one-heading">
	
		<div class="storeprima-sale-one-heading-inner">
			
			<h2><?php echo esc_html(get_theme_mod('store_prima_sale_heading', 'New Year Sale')); ?></h2>
			<h4><?php echo esc_html(get_theme_mod('store_prima_sale_sub_heading', '30% OFF on All items')); ?></h4>
			<p><?php echo esc_html(get_theme_mod('store_prima_sale_text', 'Nullam commodo, neque quis ullamcorper pulvinar')); ?></p>			
			
		</div>
		
	</div>
	<div class="storeprima-sale-one-content">
		
		<div class="storeprima-sale-one-content-inner">
			
			<?php 
				
				if( !empty($store_prima_sale_query) ):
				foreach( $store_prima_sale_query as $i ): if($store_prima_sale_num_now < $store_prima_sale_num): $store_prima_sale_num_now++;
				$storeprima_products_product = wc_get_product( $i );
			
					$storeprima_products_product_id = $i;
					$storeprima_products_product_orig_price = "";
					$storeprima_products_product_sale_price = "";
					$storeprima_products_product_on_sale = false;
					$storeprima_products_product_currency = "";
					$storeprima_products_product_type = "";
					$storeprima_products_product_name = "";
					$storeprima_products_product_desc = "";
					$storeprima_products_product_sale_amount = (int)0;
					$storeprima_products_product_variations = "";
					$storeprima_products_product_variation_name = "";
					$storeprima_products_product_variation_value = array();
					$storeprima_products_product_has_variations = "no";
					$storeprima_products_product_variation_array = array();

					$storeprima_products_product_orig_price = $storeprima_products_product->get_regular_price();
					$storeprima_products_product_sale_price = $storeprima_products_product->get_sale_price();
					$storeprima_products_product_on_sale = $storeprima_products_product->is_on_sale();
					$storeprima_products_product_currency = get_woocommerce_currency_symbol();
					$storeprima_products_product_type = $storeprima_products_product->get_type();
					$storeprima_products_product_image = wp_get_attachment_image_src( $storeprima_products_product->get_image_id(), 'full' );
					$storeprima_products_product_name = $storeprima_products_product->get_name();
					$storeprima_products_product_desc = $storeprima_products_product->get_short_description();
			
					$storeprima_products_product_is_variation = get_post_type( $i );
				
					if( $storeprima_products_product->is_type( 'variable' ) ){
						
						$storeprima_products_product_has_variations = "yes";
						
						$storeprima_products_product_variations = $storeprima_products_product->get_available_variations();
						
						foreach( $storeprima_products_product_variations as $i ){

							$storeprima_products_product_variation_array[$i["variation_id"]] = array();
							
							foreach( $i["attributes"] as $key => $value){
								$storeprima_products_product_variation_name = str_replace('attribute_','',$key);
								$storeprima_products_product_variation_value[] = $value;
								$storeprima_products_product_variation_array[$i["variation_id"]]['value'] = $value;
							}
							
							//$storeprima_products_product_variation_id[] = $i["variation_id"];
							$storeprima_products_product_variation_array[$i["variation_id"]]["display_price"] = $i["display_price"];
							$storeprima_products_product_variation_array[$i["variation_id"]]["display_regular_price"] = $i["display_regular_price"];

						}						
						
					}
				
					
				
					if( "" != $storeprima_products_product_sale_price ){
						
						$storeprima_products_product_sale_amount = ( ( floor($storeprima_products_product_orig_price * 100) - floor($storeprima_products_product_sale_price * 100) ) / 100 );
						
					}
			
					if( "product_variation" != $storeprima_products_product_is_variation ):
			
			?>
			<div data-storeprima-product-id="<?php echo esc_attr($storeprima_products_product_id); ?>" class="storeprima-sale-one-content-item">

				<div class="storeprima-sale-one-content-item-image">
					<img src="<?php echo esc_url($storeprima_products_product_image[0]); ?>" />
				</div>
				<div class="storeprima-sale-one-content-item-content">
					
					<h3><a href="<?php echo esc_url($storeprima_products_product->get_permalink()); ?>"><?php echo esc_html($storeprima_products_product_name); ?></a></h3>
					<p><?php echo esc_html($storeprima_products_product_desc); ?></p>
					<p>

						<?php if( "variable" == $storeprima_products_product_type ): ?>

							<span class="storeprima-sale-one-item-price-sale"><?php echo esc_html($storeprima_products_product->get_price_html()); ?></span>

						<?php else : ?>

							<?php if( "" != $storeprima_products_product_sale_price ): ?>

								<span class="storeprima-sale-one-item-price-orig"><s><?php echo esc_html($storeprima_products_product_currency) .'' . esc_html($storeprima_products_product_orig_price); ?></s></span>
								<span class="storeprima-sale-one-item-price-sale"><?php echo esc_html($storeprima_products_product_currency) .'' . esc_html($storeprima_products_product_sale_price); ?></span>

							<?php else : ?>

								<span class="storeprima-sale-one-item-price-sale"><?php echo esc_html($storeprima_products_product_currency) .'' . esc_html($storeprima_products_product_orig_price); ?></span>

							<?php endif; ?>						

						<?php endif; ?>							
					</p>
					<p class="storeprima-sale-one-content-item-content-add-to-cart"><a href="<?php echo esc_url($storeprima_products_product->get_permalink()); ?>"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

				</div>
				<div class="storeprima-products-one-item-badge-container">
					<div class="storeprima-products-one-item-badge">
						<?php if( 'no' == $storeprima_products_product_has_variations ): ?>
							<h3><span><?php esc_html_e( "SALE", "store-prima" ) ?></span><?php echo esc_html($storeprima_products_product_currency) . esc_html($storeprima_products_product_sale_amount); ?><span><?php esc_html_e( "off", "store-prima" ) ?></span></h3>
						<?php else : ?>
							<h3><span><?php esc_html_e( "ON", "store-prima" ) ?></span><span><?php esc_html_e( "SALE", "store-prima" ) ?></span></h3>					
						<?php endif; ?>
					</div>
				</div>				

			</div>
			<?php endif; endif; endforeach; else: ?>
			
			<div class="storeprima-sale-one-content-item">

				<div class="storeprima-sale-one-content-item-image">
					<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				</div>
				<div class="storeprima-sale-one-content-item-content">
					
					<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
					<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
					<p>
						<span class="storeprima-sale-one-item-price-orig"><s><?php esc_html_e( "$59", "store-prima" ) ?></s></span>
						<span class="storeprima-sale-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
					</p>
					<p class="storeprima-sale-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

				</div>
				<div class="storeprima-products-one-item-badge-container">
					<div class="storeprima-products-one-item-badge">
						<h3><span><?php esc_html_e( "SALE", "store-prima" ) ?></span><?php esc_html_e( "$20", "store-prima" ) ?><span><?php esc_html_e( "off", "store-prima" ) ?></span></h3>
					</div>
				</div>				

			</div>
			<div class="storeprima-sale-one-content-item">

				<div class="storeprima-sale-one-content-item-image">
					<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				</div>
				<div class="storeprima-sale-one-content-item-content">
					
					<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
					<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
					<p>
						<span class="storeprima-sale-one-item-price-orig"><s><?php esc_html_e( "$59", "store-prima" ) ?></s></span>
						<span class="storeprima-sale-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
					</p>
					<p class="storeprima-sale-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

				</div>
				<div class="storeprima-products-one-item-badge-container">
					<div class="storeprima-products-one-item-badge">
						<h3><span><?php esc_html_e( "SALE", "store-prima" ) ?></span><?php esc_html_e( "$20", "store-prima" ) ?><span><?php esc_html_e( "off", "store-prima" ) ?></span></h3>
					</div>
				</div>				

			</div>
			<div class="storeprima-sale-one-content-item">

				<div class="storeprima-sale-one-content-item-image">
					<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				</div>
				<div class="storeprima-sale-one-content-item-content">
					
					<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
					<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
					<p>
						<span class="storeprima-sale-one-item-price-orig"><s><?php esc_html_e( "$59", "store-prima" ) ?></s></span>
						<span class="storeprima-sale-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
					</p>
					<p class="storeprima-sale-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

				</div>
				<div class="storeprima-products-one-item-badge-container">
					<div class="storeprima-products-one-item-badge">
						<h3><span><?php esc_html_e( "SALE", "store-prima" ) ?></span><?php esc_html_e( "$20", "store-prima" ) ?><span><?php esc_html_e( "off", "store-prima" ) ?></span></h3>
					</div>
				</div>				

			</div>
			<div class="storeprima-sale-one-content-item">

				<div class="storeprima-sale-one-content-item-image">
					<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				</div>
				<div class="storeprima-sale-one-content-item-content">
					
					<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
					<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
					<p>
						<span class="storeprima-sale-one-item-price-orig"><s><?php esc_html_e( "$59", "store-prima" ) ?></s></span>
						<span class="storeprima-sale-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
					</p>
					<p class="storeprima-sale-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

				</div>
				<div class="storeprima-products-one-item-badge-container">
					<div class="storeprima-products-one-item-badge">
						<h3><span><?php esc_html_e( "SALE", "store-prima" ) ?></span><?php esc_html_e( "$20", "store-prima" ) ?><span><?php esc_html_e( "off", "store-prima" ) ?></span></h3>
					</div>
				</div>				

			</div>
			<div class="storeprima-sale-one-content-item">

				<div class="storeprima-sale-one-content-item-image">
					<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				</div>
				<div class="storeprima-sale-one-content-item-content">
					
					<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
					<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
					<p>
						<span class="storeprima-sale-one-item-price-orig"><s><?php esc_html_e( "$59", "store-prima" ) ?></s></span>
						<span class="storeprima-sale-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
					</p>
					<p class="storeprima-sale-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

				</div>
				<div class="storeprima-products-one-item-badge-container">
					<div class="storeprima-products-one-item-badge">
						<h3><span><?php esc_html_e( "SALE", "store-prima" ) ?></span><?php esc_html_e( "$20", "store-prima" ) ?><span><?php esc_html_e( "off", "store-prima" ) ?></span></h3>
					</div>
				</div>				

			</div>
			<div class="storeprima-sale-one-content-item">

				<div class="storeprima-sale-one-content-item-image">
					<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				</div>
				<div class="storeprima-sale-one-content-item-content">
					
					<h3><a href="#"><?php esc_html_e( "Test Product", "store-prima" ) ?></a></h3>
					<p><?php esc_html_e( "Test Product description comes here. Add some products, put some products on sale.", "store-prima" ) ?></p>
					<p>
						<span class="storeprima-sale-one-item-price-orig"><s><?php esc_html_e( "$59", "store-prima" ) ?></s></span>
						<span class="storeprima-sale-one-item-price-sale"><?php esc_html_e( "$20", "store-prima" ) ?></span>
					</p>
					<p class="storeprima-sale-one-content-item-content-add-to-cart"><a href="#"><?php esc_html_e( "View Details", "store-prima" ) ?></a></p>

				</div>
				<div class="storeprima-products-one-item-badge-container">
					<div class="storeprima-products-one-item-badge">
						<h3><span><?php esc_html_e( "SALE", "store-prima" ) ?></span><?php esc_html_e( "$20", "store-prima" ) ?><span><?php esc_html_e( "off", "store-prima" ) ?></span></h3>
					</div>
				</div>				

			</div>			
			
			
			<?php endif; ?>
			
		</div>
		
	</div>	

</div>