	<header id="masthead" class="site-header">
		
		<div class="site-branding">
			
			<?php
			
				$store_prima_custom_logo_id = get_theme_mod( 'custom_logo' );
				$store_prima_logo = wp_get_attachment_image_src( $store_prima_custom_logo_id , 'full' );
				if ( has_custom_logo() ) {
						echo '<a href="' . esc_url( home_url( '/' ) ) . '"><img src="'. esc_url( $store_prima_logo[0] ) .'"></a>';
				} else {
						echo '<h1><a href="' . esc_url( home_url( '/' ) ) . '">'. esc_html(get_bloginfo( 'name' )) .'</a></h1>';
						$store_prima_description = get_bloginfo( 'description', 'display' );
						if ( $store_prima_description || is_customize_preview() ){
							echo '<p class="site-description">' . esc_html($store_prima_description) . '</p>';
						}
				}			
			
			?>
			
			<?php if( class_exists( 'WooCommerce' ) ): ?>
			<a class="store-prima-cart-button" href="<?php echo esc_url(get_permalink( get_option('woocommerce_cart_page_id') )); ?>"><span></span></a>
			<?php endif; ?>
			<?php if( class_exists( 'WooCommerce' ) ): ?>
			<a class="account-button" href="<?php echo esc_url(get_permalink( get_option('woocommerce_myaccount_page_id') )); ?>"><span></span></a>
			<?php endif; ?>
			<a href="#" class="search-button"></a>			
			<a href="#" class="menu-button"></a>

		</div><!-- .site-branding -->

		<nav id="site-navigation" class="main-navigation">
		
			<div class="site-search">
				<?php get_search_form(); ?>
			</div><!-- .site-search -->

			<div class="menu-container">
			
				<?php
				wp_nav_menu( array(
					'theme_location' => 'menu-1',
					'menu_id'        => 'primary-menu',
					'depth' => 1,
				) );
				?>
			
			</div><!-- .menu-container -->			
			
			<div class="site-buttons">
				
				<?php if( class_exists( 'WooCommerce' ) ): ?>
				<a href="<?php echo esc_url(get_permalink( get_option('woocommerce_cart_page_id') )); ?>"><span class="store-prima-cart-button"></span></a>
				<a href="<?php echo esc_url(get_permalink( get_option('woocommerce_myaccount_page_id') )); ?>"><span class="account-button"></span></a>
				<?php endif; ?>
				<a href="#" class="search-button"></a>	
			
			</div><!-- .site-buttons -->

		</nav><!-- #site-navigation -->
		
	</header><!-- #masthead -->