<div id="storeprima-categories-container" class="storeprima-categories-one-container">

	<?php
	
		$store_prima_cat_ids = get_terms( array( 
			'taxonomy' => 'product_cat',
			'fields' => 'ids',
			'meta_query' => array(
			  array(
				 'key'       => 'store-prima-show-on-front',
				 'value'     => 'yes',
				 'compare'   => '='
			  )
			),
		) );
		if( !empty($store_prima_cat_ids) ):
		foreach( $store_prima_cat_ids as $store_prima_cat ):
	
		$store_prima_cat_id = $store_prima_cat;
		$store_prima_cat_term = get_term_by( 'id', $store_prima_cat_id, 'product_cat' );
		$store_prima_cat_term_name = $store_prima_cat_term->name;
		$store_prima_cat_term_desc = $store_prima_cat_term->description;
	
		//$store_prima_cat_image_id = get_woocommerce_term_meta( $store_prima_cat_id, 'thumbnail_id', true );
		$store_prima_cat_image_id = get_term_meta( $store_prima_cat_id, 'thumbnail_id', true );
		$store_prima_cat_image_src = wp_get_attachment_image_src( $store_prima_cat_image_id, 'full' );
		if( false === $store_prima_cat_image_src ):
			$store_prima_cat_image_src = array(esc_url(get_template_directory_uri()) . '/assets/images/product.png');
		endif;
		$store_prima_cat_term_link = get_term_link( (int)$store_prima_cat_id, 'product_cat' );

	?>	
	<div class="storeprima-categories-one-block">
	
		<div class="storeprima-categories-one-cover">
			
			<img src="<?php echo esc_url($store_prima_cat_image_src[0]); ?>" />
			<div class="storeprima-categories-one-cover-overlay">
				
			</div>
			<div class="storeprima-categories-one-cover-content">
				
				<h3><?php echo esc_html($store_prima_cat_term_name); ?></h3>
				<p><?php echo esc_html($store_prima_cat_term_desc); ?></p>
				
			</div>			
			
		</div>
		
		<?php
			
			$store_prima_cat_products_args = array(
				'category' => array( $store_prima_cat_term->slug ),
				'return' => 'ids',
				'limit' => get_theme_mod( 'store_prima_category_item_num', 3 ),
			);
			$store_prima_cat_products = wc_get_products( $store_prima_cat_products_args );
			foreach( $store_prima_cat_products as $store_prima_cat_product_id ):
		
			$store_prima_cat_product = wc_get_product($store_prima_cat_product_id);
			$store_prima_cat_product_type = $store_prima_cat_product->get_type();
			$store_prima_cat_product_image = wp_get_attachment_image_src( $store_prima_cat_product->get_image_id(), 'full' );
			$store_prima_cat_product_currency = get_woocommerce_currency_symbol();
			$store_prima_cat_product_orig_price = $store_prima_cat_product->get_regular_price();
			$store_prima_cat_product_sale_price = $store_prima_cat_product->get_sale_price();		
			
		
			//var_dump($store_prima_cat_product);
		
		?>
		<div class="storeprima-categories-one-item">
			
			<div class="storeprima-categories-one-item-image">
				
				<img src="<?php echo esc_url($store_prima_cat_product_image[0]); ?>" />
				
			</div>
			<div class="storeprima-categories-one-item-content">
				
				<h4><a href="<?php echo esc_url($store_prima_cat_product->get_permalink()); ?>"><?php echo esc_html($store_prima_cat_product->get_name()); ?></a></h4>
				<p>
				<?php if( "variable" == $store_prima_cat_product_type ): ?>

					<span class="storeprima-categories-one-item-price-sale"><?php echo esc_html($store_prima_cat_product->get_price_html()); ?></span>

				<?php else : ?>

					<?php if( "" != $store_prima_cat_product_sale_price ): ?>

						<span class="storeprima-categories-one-item-price-orig"><s><?php echo esc_html($store_prima_cat_product_currency) .'' . esc_html($store_prima_cat_product_orig_price); ?></s></span>
						<span class="storeprima-categories-one-item-price-sale"><?php echo esc_html($store_prima_cat_product_currency) .'' . esc_html($store_prima_cat_product_sale_price); ?></span>

					<?php else : ?>

						<span class="storeprima-categories-one-item-price-sale"><?php echo esc_html($store_prima_cat_product_currency) .'' . esc_html($store_prima_cat_product_orig_price); ?></span>

					<?php endif; ?>						

				<?php endif; ?>				
				</p>
				<p><a href="<?php echo esc_url($store_prima_cat_product->get_permalink()); ?>"><?php esc_html_e( "Details", "store-prima" ); ?></a></p>
				
			</div>			
			
		</div>
		<?php endforeach; ?>
		
		<div class="storeprima-categories-one-more">
			
			<a href="<?php echo esc_url($store_prima_cat_term_link); ?>"><?php esc_html_e( "View More", "store-prima" ); ?></a>
			
		</div>
	
	</div>
	<?php endforeach; else: ?>
	
	<div class="storeprima-categories-one-block">
	
		<div class="storeprima-categories-one-cover">
			
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
			<div class="storeprima-categories-one-cover-overlay">
				
			</div>
			<div class="storeprima-categories-one-cover-content">
				
				<h3><?php esc_html_e( "Test Category", "store-prima" ); ?></h3>
				<p><?php esc_html_e( "Description for this dummy category", "store-prima" ); ?></p>
				
			</div>			
			
		</div>
		
		<div class="storeprima-categories-one-item">
			
			<div class="storeprima-categories-one-item-image">
				
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				
			</div>
			<div class="storeprima-categories-one-item-content">
				
				<h4><a href="#"><?php esc_html_e( "Test Product", "store-prima" ); ?></a></h4>
				<p>
					<span class="storeprima-categories-one-item-price-sale"><?php esc_html_e( "$34", "store-prima" ); ?></span>			
				</p>
				<p><a href="#"><?php esc_html_e( "Details", "store-prima" ); ?></a></p>
				
			</div>			
			
		</div>
		<div class="storeprima-categories-one-item">
			
			<div class="storeprima-categories-one-item-image">
				
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				
			</div>
			<div class="storeprima-categories-one-item-content">
				
				<h4><a href="#"><?php esc_html_e( "Test Product", "store-prima" ); ?></a></h4>
				<p>
					<span class="storeprima-categories-one-item-price-sale"><?php esc_html_e( "$34", "store-prima" ); ?></span>			
				</p>
				<p><a href="#"><?php esc_html_e( "Details", "store-prima" ); ?></a></p>
				
			</div>			
			
		</div>
		<div class="storeprima-categories-one-item">
			
			<div class="storeprima-categories-one-item-image">
				
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				
			</div>
			<div class="storeprima-categories-one-item-content">
				
				<h4><a href="#"><?php esc_html_e( "Test Product", "store-prima" ); ?></a></h4>
				<p>
					<span class="storeprima-categories-one-item-price-sale"><?php esc_html_e( "$34", "store-prima" ); ?></span>			
				</p>
				<p><a href="#"><?php esc_html_e( "Details", "store-prima" ); ?></a></p>
				
			</div>			
			
		</div>
				
		<div class="storeprima-categories-one-more">
			
			<a href="#"><?php esc_html_e( "View More", "store-prima" ); ?></a>
			
		</div>
	
	</div>
		
	<div class="storeprima-categories-one-block">
	
		<div class="storeprima-categories-one-cover">
			
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
			<div class="storeprima-categories-one-cover-overlay">
				
			</div>
			<div class="storeprima-categories-one-cover-content">
				
				<h3><?php esc_html_e( "Test Category", "store-prima" ); ?></h3>
				<p><?php esc_html_e( "Description for this dummy category", "store-prima" ); ?></p>
				
			</div>			
			
		</div>
		
		<div class="storeprima-categories-one-item">
			
			<div class="storeprima-categories-one-item-image">
				
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				
			</div>
			<div class="storeprima-categories-one-item-content">
				
				<h4><a href="#"><?php esc_html_e( "Test Product", "store-prima" ); ?></a></h4>
				<p>
					<span class="storeprima-categories-one-item-price-sale"><?php esc_html_e( "$34", "store-prima" ); ?></span>			
				</p>
				<p><a href="#"><?php esc_html_e( "Details", "store-prima" ); ?></a></p>
				
			</div>			
			
		</div>
		<div class="storeprima-categories-one-item">
			
			<div class="storeprima-categories-one-item-image">
				
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				
			</div>
			<div class="storeprima-categories-one-item-content">
				
				<h4><a href="#"><?php esc_html_e( "Test Product", "store-prima" ); ?></a></h4>
				<p>
					<span class="storeprima-categories-one-item-price-sale"><?php esc_html_e( "$34", "store-prima" ); ?></span>			
				</p>
				<p><a href="#"><?php esc_html_e( "Details", "store-prima" ); ?></a></p>
				
			</div>			
			
		</div>
		<div class="storeprima-categories-one-item">
			
			<div class="storeprima-categories-one-item-image">
				
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				
			</div>
			<div class="storeprima-categories-one-item-content">
				
				<h4><a href="#"><?php esc_html_e( "Test Product", "store-prima" ); ?></a></h4>
				<p>
					<span class="storeprima-categories-one-item-price-sale"><?php esc_html_e( "$34", "store-prima" ); ?></span>			
				</p>
				<p><a href="#"><?php esc_html_e( "Details", "store-prima" ); ?></a></p>
				
			</div>			
			
		</div>
				
		<div class="storeprima-categories-one-more">
			
			<a href="#"><?php esc_html_e( "View More", "store-prima" ); ?></a>
			
		</div>
	
	</div>
		
	<div class="storeprima-categories-one-block">
	
		<div class="storeprima-categories-one-cover">
			
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
			<div class="storeprima-categories-one-cover-overlay">
				
			</div>
			<div class="storeprima-categories-one-cover-content">
				
				<h3><?php esc_html_e( "Test Category", "store-prima" ); ?></h3>
				<p><?php esc_html_e( "Description for this dummy category", "store-prima" ); ?></p>
				
			</div>			
			
		</div>
		
		<div class="storeprima-categories-one-item">
			
			<div class="storeprima-categories-one-item-image">
				
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				
			</div>
			<div class="storeprima-categories-one-item-content">
				
				<h4><a href="#"><?php esc_html_e( "Test Product", "store-prima" ); ?></a></h4>
				<p>
					<span class="storeprima-categories-one-item-price-sale"><?php esc_html_e( "$34", "store-prima" ); ?></span>			
				</p>
				<p><a href="#"><?php esc_html_e( "Details", "store-prima" ); ?></a></p>
				
			</div>			
			
		</div>
		<div class="storeprima-categories-one-item">
			
			<div class="storeprima-categories-one-item-image">
				
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				
			</div>
			<div class="storeprima-categories-one-item-content">
				
				<h4><a href="#"><?php esc_html_e( "Test Product", "store-prima" ); ?></a></h4>
				<p>
					<span class="storeprima-categories-one-item-price-sale"><?php esc_html_e( "$34", "store-prima" ); ?></span>			
				</p>
				<p><a href="#"><?php esc_html_e( "Details", "store-prima" ); ?></a></p>
				
			</div>			
			
		</div>
		<div class="storeprima-categories-one-item">
			
			<div class="storeprima-categories-one-item-image">
				
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/product.png" />
				
			</div>
			<div class="storeprima-categories-one-item-content">
				
				<h4><a href="#"><?php esc_html_e( "Test Product", "store-prima" ); ?></a></h4>
				<p>
					<span class="storeprima-categories-one-item-price-sale"><?php esc_html_e( "$34", "store-prima" ); ?></span>			
				</p>
				<p><a href="#"><?php esc_html_e( "Details", "store-prima" ); ?></a></p>
				
			</div>			
			
		</div>
				
		<div class="storeprima-categories-one-more">
			
			<a href="#"><?php esc_html_e( "View More", "store-prima" ); ?></a>
			
		</div>
	
	</div>
	
	<?php endif; ?>
	
</div>