	<div class="storeprima-about-one-container">

		<div class="storeprima-about-one-contact">

			<?php if( 'no' != get_theme_mod( 'store_prima_show_about', 'yes' ) ): ?>
			<div class="storeprima-about-one-info">

				<?php
				
				if( '' != get_theme_mod( 'store_prima_footer_about_id' ) && 'select' != get_theme_mod( 'store_prima_footer_about_id' ) ){
					
					$store_prima_footer_post_id = get_theme_mod( 'store_prima_footer_about_id' );
					
				}else{
					
					$store_prima_footer_post_id = store_prima_get_random_post();
					
				}
				
				//$store_prima_footer_post_id = get_theme_mod( 'store_prima_footer_about_id', store_prima_get_random_post() );
				$store_prima_footer_about_post = get_post($store_prima_footer_post_id);	
					
				?>
				
				<h4><?php echo esc_html($store_prima_footer_about_post->post_title); ?></h4>
				<p><?php echo  esc_html(store_prima_limitedstring($store_prima_footer_about_post->post_content)); ?></p>

			</div>
			<?php endif; ?>

			<div class="storeprima-about-one-phone">

				<span></span>
				<p><?php esc_html_e( 'Call Us', 'store-prima' ); ?></p>
				<h4><?php echo esc_html(get_theme_mod( 'store_prima_phone', '' )); ?></h4>

			</div>

			<div class="storeprima-about-one-email">

				<span></span>
				<p><?php esc_html_e( 'Email Us', 'store-prima' ); ?></p>
				<h4><?php echo esc_html(get_theme_mod( 'store_prima_email', '' )); ?></h4>

			</div>	

			<div class="storeprima-about-one-social">

				<?php if( '' != get_theme_mod( 'store_prima_facebook_url', '' ) ): ?>
				<a class="storeprima-facebook" href="<?php echo esc_url(get_theme_mod( 'store_prima_facebook_url' )); ?>"></a>
				<?php endif; ?>	

				<?php if( '' != get_theme_mod( 'store_prima_instagram_url', '' ) ): ?>
				<a class="storeprima-instagram" href="<?php echo esc_url(get_theme_mod( 'store_prima_instagram_url' )); ?>"></a>
				<?php endif; ?>	

				<?php if( '' != get_theme_mod( 'store_prima_twitter_url', '' ) ): ?>
				<a class="storeprima-twitter" href="<?php echo esc_url(get_theme_mod( 'store_prima_twitter_url' )); ?>"></a>
				<?php endif; ?>

			</div>		


		</div>

		<div class="storeprima-about-one-blog">

			<?php

				$store_prima_blog_cat = get_theme_mod('store_prima_about_posts_cat', 1);
				$store_prima_blog_args = array(
					'posts_per_page' => 3,
					'post_status'    => 'publish',
					'ignore_sticky_posts' => 1,
					'cat' => $store_prima_blog_cat,
				); // WPCS: slow query ok.

				$store_prima_blog = new WP_Query( $store_prima_blog_args );

				if ( $store_prima_blog->have_posts() ):
				while ( $store_prima_blog->have_posts() ):
				$store_prima_blog->the_post();

			?>
			<div class="storeprima-about-one-blog-item">

				<?php

					//$store_prima_blog_item_image = get_template_directory_uri() . '/assets/images/voltshop-hero-six-04.jpg';

					if( has_post_thumbnail() ){

						echo '<span><img src="' . esc_url(get_the_post_thumbnail_url()) . '"/></span>';

					}else{

						echo '<span><img src="' . esc_url(get_template_directory_uri()) . '/assets/images/voltshop-hero-six-04.jpg"/></span>';

					}			

				?>

				<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
				<p><?php the_excerpt(); ?></p>			

			</div>
			<?php

				endwhile;
				wp_reset_postdata();	
				endif;

			?>

			<div class="storeprima-about-one-blog-link">
				<a href="<?php echo esc_url(get_category_link( $store_prima_blog_cat )); ?>"><?php esc_html_e( 'More', 'store-prima' ); ?></a>
			</div>

		</div>	

		<?php if( 'yes' == get_theme_mod('store_prima_show_footer_features') ): ?>
		<div class="storeprima-about-one-features">

			<?php
			
				$store_prima_footer_features = array(
					'store_prima_footer_feature_one_post', 'store_prima_footer_feature_two_post', 'store_prima_footer_feature_three_post'
				);
				foreach( $store_prima_footer_features as $store_prima_footer_feature ):
				
					$store_prima_footer_feature_id = get_theme_mod($store_prima_footer_feature);
			
					if( '' == $store_prima_footer_feature_id || 'select' == $store_prima_footer_feature_id ){
						$store_prima_footer_feature_id = store_prima_get_random_post();
					}
					
					$store_prima_footer_feature_id = (int)$store_prima_footer_feature_id;
			
					$store_prima_footer_feature_post = get_post($store_prima_footer_feature_id);
						
					$store_prima_footer_feature_post_url = get_the_post_thumbnail_url($store_prima_footer_feature_id,'full');
					if( empty($store_prima_footer_feature_post_url) ){
						$store_prima_footer_feature_post_url = get_template_directory_uri() . '/assets/images/voltshop-hero-six-04.jpg';
					}
			
			?>
			<div class="storeprima-about-one-features-item">

				<span><img src="<?php echo esc_url($store_prima_footer_feature_post_url); ?>" /></span>
				<h4><?php echo esc_html($store_prima_footer_feature_post->post_title); ?></h4>
				<p><?php echo  esc_html(store_prima_limitedstring($store_prima_footer_feature_post->post_content, 50)); ?></p>

			</div>
			<?php endforeach; ?>

		</div>
		<?php endif; ?>

	</div>