<?php
//namespace store_prima;
use WPTRT\Customize\Section\Button;

// Register the "button" section.

add_action( 'customize_register', function( $manager ) {

	$manager->register_section_type( Button::class );

	$manager->add_section(
		new Button( $manager, 'store-prima-upgrade', [
			'title'       => __( 'Get Pro Version', 'store-prima' ),
			'button_text' => __( 'Purchase',        'store-prima' ),
			'button_url'  => 'https://wpenclave.com/theme',
			'priority' => 10,
		] )
	);

} );

add_action( 'customize_controls_enqueue_scripts', function() {

	$version = wp_get_theme()->get( 'Version' );

	wp_enqueue_script(
		'store-prima-wptrt-customize-section-button',
		get_template_directory_uri() .'/assets/js/customize-controls.js',
		[ 'customize-controls' ],
		$version,
		true
	);

	wp_enqueue_style(
		'store-prima-wptrt-customize-section-button',
		get_template_directory_uri() .'/assets/css/customize-controls.css',
		[ 'customize-controls' ],
 		$version
	);

} );