<?php
/**
 * store prima Theme Customizer
 *
 * @package store prima
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function store_prima_customize_register( $wp_customize ) {

	global $store_prima_options_array;
	
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'store_prima_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'store_prima_customize_partial_blogdescription',
		) );
	}
	
	$wp_customize->add_panel( 'store_prima_general_settings', array(
		
		'title'      => __('General Settings', 'store-prima'),
		'priority'   => 20,
		'active_callback' => '',
		
	) );
	$wp_customize->get_section( 'title_tagline' )->panel = 'store_prima_general_settings';
	$wp_customize->get_section( 'colors' )->panel = 'store_prima_general_settings';
	$wp_customize->get_section( 'background_image' )->panel = 'store_prima_general_settings';
	$wp_customize->get_section( 'custom_css' )->panel = 'store_prima_general_settings';	
	
	$wp_customize->add_panel( 'store_prima_settings', array(
		
		'title'      => __('Homepage Settings', 'store-prima'),
		'priority'   => 20,
		'active_callback' => '',
		
	) );
	
	$wp_customize->get_section( 'static_front_page' )->panel = 'store_prima_general_settings';
	$wp_customize->get_section( 'static_front_page' )->priority = 10;
	$wp_customize->get_section( 'static_front_page' )->title = 'FrontPage Settings';
	
	/* Slider/Header */
	$wp_customize->add_section( 'store_prima_slider_settings', array(
		
		'title'      => __('Header Settings', 'store-prima'),
		'description'      => __('This header is used when frontpage is not set to show WooCommerce layout', 'store-prima'),
		'priority'   => 20,
		'panel'		=> 'store_prima_general_settings',
		'active_callback' => '',
		
	) );	
	
	$wp_customize->add_setting( 'store_prima_show_slider',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_yes_no',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize, //Pass the $wp_customize object (required)
	'store_prima_show_slider', //Set a unique ID for the control
		array(
		'label'      => __( 'Show Header', 'store-prima' ),
		'settings'   => 'store_prima_show_slider',
		'priority'   => 10,
		'section'    => 'store_prima_slider_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['yesno'],
	 	)
	) );	
	
	$wp_customize->add_setting( 'store_prima_slider_id',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_post_select',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize, //Pass the $wp_customize object (required)
	'store_prima_slider_id', //Set a unique ID for the control
		array(
		'label'      => __( 'Header Post', 'store-prima' ),
		'description' => __( 'This post will be shown as header.', 'store-prima'),
		'settings'   => 'store_prima_slider_id',
		'priority'   => 11,
		'section'    => 'store_prima_slider_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['posts'],
	 	)
	) );
	
	$wp_customize->add_panel( 'store_prima_woo_settings', array(
		
		'title'      => __('StorePrima WooCommerce Layout Settings', 'store-prima'),
		'priority'   => 30,
		'active_callback' => '',
		
	) );
	
	/* Product Slider */
	$wp_customize->add_section( 'store_prima_product_slider_settings', array(
		
		'title'      => __('Slider Settings', 'store-prima'),
		'priority'   => 10,
		'panel'		=> 'store_prima_woo_settings',
		'active_callback' => '',
		
	) );
	$wp_customize->add_setting( 'store_prima_show_product_slider',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_yes_no',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_show_product_slider',
		array(
		'label'      => __( 'Show Product Slider?', 'store-prima' ),
		'description' => __( 'Select if you want to show Product Slider in WooCommerce layout', 'store-prima'),
		'settings'   => 'store_prima_show_product_slider',
		'priority'   => 10,
		'section'    => 'store_prima_product_slider_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['yesno'],
	 	)
	) );
	
	$wp_customize->add_setting( 'store_prima_product_slider_num',
	 array(
		'default'    => '5',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'absint',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	 $wp_customize, //Pass the $wp_customize object (required)
	 'store_prima_product_slider_num', //Set a unique ID for the control
	 array(
		'label'      => __( 'How many slides', 'store-prima' ),
		'description' => __( 'Select how many slides to show in slider.', 'store-prima'),
		'settings'   => 'store_prima_product_slider_num',
		'priority'   => 20,
		'section'    => 'store_prima_product_slider_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['slides'],
	 )
	) );
	
	/* Store Features */
	$wp_customize->add_section( 'store_prima_store_features_settings', array(
		
		'title'      => __('Store features Settings', 'store-prima'),
		'priority'   => 30,
		'panel'		=> 'store_prima_woo_settings',
		'active_callback' => '',
		
	) );
	
	$wp_customize->add_setting( 'store_prima_show_features',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_yes_no',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_show_features',
		array(
		'label'      => __( 'Show Store features?', 'store-prima' ),
		'description' => __( 'Select if you want to show features section', 'store-prima'),
		'settings'   => 'store_prima_show_features',
		'priority'   => 10,
		'section'    => 'store_prima_store_features_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['yesno'],
	 	)
	) );	
	$wp_customize->add_setting( 'store_prima_store_feature_one_id',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_post_select',
	 ) 
	);
	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_store_feature_one_id',
		array(
		'label'      => __( 'Feature One', 'store-prima' ),
		'description' => __( 'This post will be shown as feature one, Post title as heading, post text as sub heading, featured image as image.', 'store-prima'),
		'settings'   => 'store_prima_store_feature_one_id',
		'priority'   => 20,
		'section'    => 'store_prima_store_features_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['posts'],
	 	)
	) );	
	$wp_customize->add_setting( 'store_prima_store_feature_two_id',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_post_select',
	 ) 
	);
	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_store_feature_two_id',
		array(
		'label'      => __( 'Feature Two', 'store-prima' ),
		'description' => __( 'This post will be shown as feature two, Post title as heading, post text as sub heading, featured image as image.', 'store-prima'),
		'settings'   => 'store_prima_store_feature_two_id',
		'priority'   => 20,
		'section'    => 'store_prima_store_features_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['posts'],
	 	)
	) );
	$wp_customize->add_setting( 'store_prima_store_feature_three_id',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_post_select',
	 ) 
	);
	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_store_feature_three_id',
		array(
		'label'      => __( 'Feature Three', 'store-prima' ),
		'description' => __( 'This post will be shown as feature three, Post title as heading, post text as sub heading, featured image as image.', 'store-prima'),
		'settings'   => 'store_prima_store_feature_three_id',
		'priority'   => 20,
		'section'    => 'store_prima_store_features_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['posts'],
	 	)
	) );
	
	/* Sale */
	$wp_customize->add_section( 'store_prima_store_sale_settings', array(
		
		'title'      => __('Sale Settings', 'store-prima'),
		'priority'   => 40,
		'panel'		=> 'store_prima_woo_settings',
		'active_callback' => '',
		
	) );
	$wp_customize->add_setting( 'store_prima_show_sale',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_yes_no',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_show_sale',
		array(
		'label'      => __( 'Show Store features?', 'store-prima' ),
		'description' => __( 'Select if you want to show sale section', 'store-prima'),
		'settings'   => 'store_prima_show_sale',
		'priority'   => 10,
		'section'    => 'store_prima_store_sale_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['yesno'],
	 	)
	) );	
	$wp_customize->add_setting( 'store_prima_sale_heading',
	 array(
		'default'    => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_sale_heading',
		array(
		'label'      => __( 'Sale Heading :', 'store-prima' ),
		'settings'   => 'store_prima_sale_heading',
		'priority'   => 20,
		'section'    => 'store_prima_store_sale_settings',
		'type'    => 'text',
	 	)
	) );
	$wp_customize->add_setting( 'store_prima_sale_sub_heading',
	 array(
		'default'    => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_sale_sub_heading',
		array(
		'label'      => __( 'Sale Sub Heading :', 'store-prima' ),
		'settings'   => 'store_prima_sale_sub_heading',
		'priority'   => 30,
		'section'    => 'store_prima_store_sale_settings',
		'type'    => 'text',
	 	)
	) );
	$wp_customize->add_setting( 'store_prima_sale_text',
	 array(
		'default'    => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_sale_text',
		array(
		'label'      => __( 'Sale Text :', 'store-prima' ),
		'settings'   => 'store_prima_sale_text',
		'priority'   => 40,
		'section'    => 'store_prima_store_sale_settings',
		'type'    => 'text',
	 	)
	) );
	
	$wp_customize->add_setting( 'store_prima_sale_num',
	 array(
		'default'    => '6',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'absint',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	 $wp_customize, //Pass the $wp_customize object (required)
	 'store_prima_sale_num', //Set a unique ID for the control
	 array(
		'label'      => __( 'How many products', 'store-prima' ),
		'description' => __( 'Select how many products to show in sale section.', 'store-prima'),
		'settings'   => 'store_prima_sale_num',
		'priority'   => 11,
		'section'    => 'store_prima_store_sale_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['slides'],
	 )
	) );	
	
	/* Tabs */
	$wp_customize->add_section( 'store_prima_store_tabs_settings', array(
		
		'title'      => __('Tabs Settings', 'store-prima'),
		'priority'   => 40,
		'panel'		=> 'store_prima_woo_settings',
		'active_callback' => '',
		
	) );
	$wp_customize->add_setting( 'store_prima_show_tabs',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_yes_no',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_show_tabs',
		array(
		'label'      => __( 'Show Store features?', 'store-prima' ),
		'description' => __( 'Select if you want to show features section', 'store-prima'),
		'settings'   => 'store_prima_show_tabs',
		'priority'   => 10,
		'section'    => 'store_prima_store_tabs_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['yesno'],
	 	)
	) );	
	
	$wp_customize->add_setting( 'store_prima_tabs_item_num',
	 array(
		'default'    => '4',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'absint',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	 $wp_customize, //Pass the $wp_customize object (required)
	 'store_prima_tabs_item_num', //Set a unique ID for the control
	 array(
		'label'      => __( 'How many products', 'store-prima' ),
		'description' => __( 'Select how many products to show in tabs section.', 'store-prima'),
		'settings'   => 'store_prima_tabs_item_num',
		'priority'   => 20,
		'section'    => 'store_prima_store_tabs_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['slides'],
	 )
	) );	
	
	/* Latest */
	$wp_customize->add_section( 'store_prima_store_latest_settings', array(
		
		'title'      => __('Latest Settings', 'store-prima'),
		'priority'   => 50,
		'panel'		=> 'store_prima_woo_settings',
		'active_callback' => '',
		
	) );
	$wp_customize->add_setting( 'store_prima_show_latest',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_yes_no',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_show_latest',
		array(
		'label'      => __( 'Show Store features?', 'store-prima' ),
		'description' => __( 'Select if you want to show features section', 'store-prima'),
		'settings'   => 'store_prima_show_latest',
		'priority'   => 10,
		'section'    => 'store_prima_store_latest_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['yesno'],
	 	)
	) );	
	$wp_customize->add_setting( 'store_prima_latest_heading',
	 array(
		'default'    => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_latest_heading',
		array(
		'label'      => __( 'latest Heading :', 'store-prima' ),
		'settings'   => 'store_prima_latest_heading',
		'priority'   => 20,
		'section'    => 'store_prima_store_latest_settings',
		'type'    => 'text',
	 	)
	) );
	$wp_customize->add_setting( 'store_prima_latest_text',
	 array(
		'default'    => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_latest_text',
		array(
		'label'      => __( 'Latest Text :', 'store-prima' ),
		'settings'   => 'store_prima_latest_text',
		'priority'   => 30,
		'section'    => 'store_prima_store_latest_settings',
		'type'    => 'text',
	 	)
	) );
	$wp_customize->add_setting( 'store_prima_latest_item_num',
	 array(
		'default'    => '8',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'absint',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	 $wp_customize, //Pass the $wp_customize object (required)
	 'store_prima_latest_item_num', //Set a unique ID for the control
	 array(
		'label'      => __( 'How many products', 'store-prima' ),
		'description' => __( 'Select how many products to show in latest section.', 'store-prima'),
		'settings'   => 'store_prima_latest_item_num',
		'priority'   => 40,
		'section'    => 'store_prima_store_latest_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['slides'],
	 )
	) );
	
	/* Categories */
	$wp_customize->add_section( 'store_prima_categories_settings', array(
		
		'title'      => __('Categories Settings', 'store-prima'),
		'priority'   => 50,
		'panel'		=> 'store_prima_woo_settings',
		'active_callback' => '',
		
	) );
	$wp_customize->add_setting( 'store_prima_show_categories',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_yes_no',
	 ) 
	);
	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_show_categories',
		array(
		'label'      => __( 'Show categories?', 'store-prima' ),
		'description' => __( 'Select if you want to show categories section', 'store-prima'),
		'settings'   => 'store_prima_show_categories',
		'priority'   => 10,
		'section'    => 'store_prima_categories_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['yesno'],
	 	)
	) );
	$wp_customize->add_setting( 'store_prima_category_item_num',
	 array(
		'default'    => '3',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'absint',
	 ) 
	);
	$wp_customize->add_control( new WP_Customize_Control(
	 $wp_customize, //Pass the $wp_customize object (required)
	 'store_prima_category_item_num', //Set a unique ID for the control
	 array(
		'label'      => __( 'How many products per category', 'store-prima' ),
		'description' => __( 'Select how many products to show in each category block.', 'store-prima'),
		'settings'   => 'store_prima_category_item_num',
		'priority'   => 11,
		'section'    => 'store_prima_categories_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['slides'],
	 )
	) );	
	
	
	/* Testimonials */
	$wp_customize->add_section( 'store_prima_testimonials_settings', array(
		
		'title'      => __('Testimonials Settings', 'store-prima'),
		'priority'   => 70,
		'panel'		=> 'store_prima_woo_settings',
		'active_callback' => '',
		
	) );	
	$wp_customize->add_setting( 'store_prima_show_testimonials',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_yes_no',
	 ) 
	);
	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_show_testimonials',
		array(
		'label'      => __( 'Show testimonials?', 'store-prima' ),
		'description' => __( 'Select if you want to show testimonials section', 'store-prima'),
		'settings'   => 'store_prima_show_testimonials',
		'priority'   => 10,
		'section'    => 'store_prima_testimonials_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['yesno'],
	 	)
	) );	
	$wp_customize->add_setting( 'store_prima_testimonials_cat',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_category_select',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize, //Pass the $wp_customize object (required)
	'store_prima_testimonials_cat', //Set a unique ID for the control
		array(
		'label'      => __( 'Testimonials Category', 'store-prima' ),
		'description' => __( 'Posts from this category will show up in testimonials.', 'store-prima'),
		'settings'   => 'store_prima_testimonials_cat',
		'priority'   => 10,
		'section'    => 'store_prima_testimonials_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['categories'],
	 	)
	) );
	
	$wp_customize->add_setting( 'store_prima_testimonials_num',
	 array(
		'default'    => '5',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'absint',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	 $wp_customize, //Pass the $wp_customize object (required)
	 'store_prima_testimonials_num', //Set a unique ID for the control
	 array(
		'label'      => __( 'How many testimonials', 'store-prima' ),
		'description' => __( 'Select how many testimonials to show.', 'store-prima'),
		'settings'   => 'store_prima_testimonials_num',
		'priority'   => 20,
		'section'    => 'store_prima_testimonials_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['slides'],
	 )
	) );
	
	$wp_customize->add_section( 'store_prima_about_settings', array(
		
		'title'      => __('About Settings', 'store-prima'),
		'priority'   => 80,
		'panel'		=> 'store_prima_woo_settings',
		'active_callback' => '',
		
	) );
	$wp_customize->add_setting( 'store_prima_show_about',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_yes_no',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_show_about',
		array(
		'label'      => __( 'Show About Post?', 'store-prima' ),
		'description' => __( 'Select if you want to show about section', 'store-prima'),
		'settings'   => 'store_prima_show_about',
		'priority'   => 10,
		'section'    => 'store_prima_about_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['yesno'],
	 	)
	) );	
	$wp_customize->add_setting( 'store_prima_footer_about_id',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_post_select',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_footer_about_id',
		array(
		'label'      => __( 'About Post', 'store-prima' ),
		'description' => __( 'This post will be shown as about heading and desc.', 'store-prima'),
		'settings'   => 'store_prima_footer_about_id',
		'priority'   => 20,
		'section'    => 'store_prima_about_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['posts'],
	 	)
	) );
	
	$wp_customize->add_setting( 'store_prima_phone',
	 array(
		'default'    => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_phone',
		array(
		'label'      => __( 'Phone Number :', 'store-prima' ),
		'settings'   => 'store_prima_phone',
		'priority'   => 30,
		'section'    => 'store_prima_about_settings',
		'type'    => 'text',
	 	)
	) );
	$wp_customize->add_setting( 'store_prima_email',
	 array(
		'default'    => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_email',
		array(
		'label'      => __( 'Email :', 'store-prima' ),
		'settings'   => 'store_prima_email',
		'priority'   => 40,
		'section'    => 'store_prima_about_settings',
		'type'    => 'text',
	 	)
	) );
	
	$wp_customize->add_setting( 'store_prima_facebook_url',
	 array(
		'default'    => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_facebook_url',
		array(
		'label'      => __( 'Facebook Url :', 'store-prima' ),
		'settings'   => 'store_prima_facebook_url',
		'priority'   => 50,
		'section'    => 'store_prima_about_settings',
		'type'    => 'url',
	 	)
	) );
	$wp_customize->add_setting( 'store_prima_instagram_url',
	 array(
		'default'    => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_instagram_url',
		array(
		'label'      => __( 'Instagram Url :', 'store-prima' ),
		'settings'   => 'store_prima_instagram_url',
		'priority'   => 50,
		'section'    => 'store_prima_about_settings',
		'type'    => 'url',
	 	)
	) );
	$wp_customize->add_setting( 'store_prima_twitter_url',
	 array(
		'default'    => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_twitter_url',
		array(
		'label'      => __( 'Twitter Url :', 'store-prima' ),
		'settings'   => 'store_prima_twitter_url',
		'priority'   => 60,
		'section'    => 'store_prima_about_settings',
		'type'    => 'url',
	 	)
	) );	
	
	$wp_customize->add_setting( 'store_prima_about_posts_cat',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_category_select',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize, //Pass the $wp_customize object (required)
	'store_prima_about_posts_cat', //Set a unique ID for the control
		array(
		'label'      => __( 'Blog Posts Category', 'store-prima' ),
		'description' => __( 'Posts from this category will show up as blog posts.', 'store-prima'),
		'settings'   => 'store_prima_about_posts_cat',
		'priority'   => 100,
		'section'    => 'store_prima_about_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['categories'],
	 	)
	) );	

	
	$wp_customize->add_setting( 'store_prima_show_footer_features',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_yes_no',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize,
	'store_prima_show_footer_features',
		array(
		'label'      => __( 'Show Footer Features?', 'store-prima' ),
		'description' => __( 'Select if you want to show footer features section', 'store-prima'),
		'settings'   => 'store_prima_show_footer_features',
		'priority'   => 101,
		'section'    => 'store_prima_about_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['yesno'],
	 	)
	) );	
	$wp_customize->add_setting( 'store_prima_footer_feature_one_post',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_post_select',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize, //Pass the $wp_customize object (required)
	'store_prima_footer_feature_one_post', //Set a unique ID for the control
		array(
		'label'      => __( 'Footer Feature One', 'store-prima' ),
		'description' => __( 'This post will be shown as footer feature one.', 'store-prima'),
		'settings'   => 'store_prima_footer_feature_one_post',
		'priority'   => 110,
		'section'    => 'store_prima_about_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['posts'],
	 	)
	) );
	$wp_customize->add_setting( 'store_prima_footer_feature_two_post',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_post_select',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize, //Pass the $wp_customize object (required)
	'store_prima_footer_feature_two_post', //Set a unique ID for the control
		array(
		'label'      => __( 'Footer Feature Two', 'store-prima' ),
		'description' => __( 'This post will be shown as footer feature two.', 'store-prima'),
		'settings'   => 'store_prima_footer_feature_two_post',
		'priority'   => 110,
		'section'    => 'store_prima_about_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['posts'],
	 	)
	) );
	$wp_customize->add_setting( 'store_prima_footer_feature_three_post',
	 array(
		'default'    => 'select',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'store_prima_sanitize_post_select',
	 ) 
	);

	$wp_customize->add_control( new WP_Customize_Control(
	$wp_customize, //Pass the $wp_customize object (required)
	'store_prima_footer_feature_three_post', //Set a unique ID for the control
		array(
		'label'      => __( 'Footer Feature Three', 'store-prima' ),
		'description' => __( 'This post will be shown as footer feature three.', 'store-prima'),
		'settings'   => 'store_prima_footer_feature_three_post',
		'priority'   => 110,
		'section'    => 'store_prima_about_settings',
		'type'    => 'select',
		'choices' => $store_prima_options_array['posts'],
	 	)
	) );
	
}
add_action( 'customize_register', 'store_prima_customize_register' );

$store_prima_options_array = array();
$store_prima_options_array['categories'] = array( 'select' => __( 'Select', 'store-prima' ) );
$store_prima_options_array['slides'] = array( '1' => __( '1', 'store-prima' ), '2' => __( '2', 'store-prima' ), '3' => __( '3', 'store-prima' ), '4' => __( '4', 'store-prima' ), '5' => __( '5', 'store-prima' ), '6' => __( '6', 'store-prima' ), '7' => __( '7', 'store-prima' ), '8' => __( '8', 'store-prima' ), '9' => __( '9', 'store-prima' ), '10' => __( '10', 'store-prima' ) );

$store_prima_categories_raw = get_categories( array( 'orderby' => 'name', 'order' => 'ASC', 'hide_empty' => 0, ) );

foreach( $store_prima_categories_raw as $store_prima_category ){
	
	$store_prima_options_array['categories'][$store_prima_category->term_id] = $store_prima_category->name;
	
}

$store_prima_options_array['yesno'] = array(
	'select' => __('Select', 'store-prima'),
	'yes' => __('Yes', 'store-prima'),
	'no' => __('No', 'store-prima'),
);

$store_prima_options_array['posts'] = array(
	'select' => __('Select a post/page', 'store-prima'),
);

$store_prima_posts_args = array(
	
	// Change these category SLUGS to suit your use.
	'ignore_sticky_posts' => 1,
	'post_type' => array('post', 'page'),
	'orderby' => 'date',
	'posts_per_page' => -1,
	'post_status' => 'publish',
	
);
$store_prima_posts_query = new WP_Query( $store_prima_posts_args );
	
if ( $store_prima_posts_query->have_posts() ) :
							
	while ( $store_prima_posts_query->have_posts() ) : $store_prima_posts_query->the_post();
			
		$store_prima_posts_id = get_the_ID();
		if(get_the_title() != ''){
				$store_prima_posts_title = get_the_title();
		}else{
				$store_prima_posts_title = get_the_ID();
		}
		$store_prima_options_array['posts'][$store_prima_posts_id] = $store_prima_posts_title;
	   
	endwhile; wp_reset_postdata();
							
endif;

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function store_prima_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function store_prima_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function store_prima_customize_preview_js() {
	wp_enqueue_script( 'store-prima-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'store_prima_customize_preview_js' );

function store_prima_sanitize_yes_no( $value ){
	
	global $store_prima_options_array;
	
	if( ! array_key_exists( $value, $store_prima_options_array['yesno'] ) ){
		
		$value = 'select';
		
	}
	return $value;
	
}

function store_prima_sanitize_category_select( $value ){
	
	global $store_prima_options_array;
	
	if( ! array_key_exists( $value, $store_prima_options_array['categories'] ) ){
		
		$value = 'select';
		
	}
	return $value;
	
}

function store_prima_sanitize_slider_slides( $value ){
	
	global $store_prima_options_array;
	
	if( ! array_key_exists( $value, $store_prima_options_array['slides'] ) ){
		
		$value = '5';
		
	}
	return $value;
	
}

function store_prima_sanitize_post_select( $value ){
	
	global $store_prima_options_array;
	
	if( ! array_key_exists( $value, $store_prima_options_array['posts'] ) ){
		
		$value = 'select';
		
	}
	return $value;
	
}
