<?php
/**
 * The front page file
 *
 *
 * @package store prima
 */

get_header();
?>

<?php if( 'page' == get_option( 'show_on_front' ) ): ?>

	

		<?php if( 'page2.php' == get_page_template_slug() ): ?>

			<?php get_template_part( 'template-parts/woo/index' ); ?>

		<?php else : ?>
		<?php get_template_part("template-parts/header"); ?>
		<?php get_template_part("template-parts/slider"); ?>
		<div id="content" class="site-content">
			<div id="primary" class="content-area-full">
				<main id="main" class="site-main">
					<?php get_template_part( 'template-parts/content', 'page' ); ?>
				</main>	  
			</div>
		</div>
		<?php get_template_part("template-parts/footer"); ?>
		<?php endif; ?>	

	
	
<?php else : ?>
<?php get_template_part("template-parts/header"); ?>
<?php get_template_part("template-parts/slider"); ?>
<div id="content" class="site-content">	

	<div id="primary" class="content-area-full">
		
		<main id="main" class="site-main">

		<?php
		if ( have_posts() ) :

			echo '<div class="front-page-posts-container">';
			echo '<div class="front-page-posts">';
			
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();

				/*
				 * Include the Post-Type-specific template for the content.
				 * If you want to override this in a child theme, then include a file
				 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
				 */
				?> 
				<div class="front-page-post">
				
					<div class="front-page-post-image">
					<?php
						if ( has_post_thumbnail() ) {
							the_post_thumbnail();
						}else{
							echo '<img src="' . esc_url( get_template_directory_uri() ) . '/assets/images/front-page-post.jpg" />';
						}						
					?>
					</div><!-- .front-page-post-image -->
					
					<div class="front-page-post-content">
					
						<a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title( '<h3 class="entry-title">', '</h3>' ); ?></a>
						<p><?php the_excerpt(); ?></p>
						<p class="front-page-post-link">
							<a href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e('Read more', 'store-prima'); ?></a>
						</p>
					
					</div>					
				
				</div><!-- .front-page-post -->
				<?php
				
			endwhile;

			echo '</div><!-- .front-page-posts -->';
			
			the_posts_navigation();
			
			echo '</div><!-- .front-page-posts-container -->';

		else :

			get_template_part( 'template-parts/content', 'none' );

		endif;
		?>

		
		</main><!-- #main -->
		
	</div><!-- #primary -->

</div><!-- #content -->		

<?php get_template_part("template-parts/footer"); ?>

<?php endif; ?>	

<?php
get_footer();
