<?php
class startkit_social_icon_widget extends WP_Widget{
		// Construct
		public function __construct() {
		
			parent::__construct(
				"Social_Widget", 
				"StartKit : Social Widget",
				array("description" => __( 'Social Icon Widgets', 'startkit' ), ) 
			);	
			
			$this->defaults = array(
				'title' => __( 'Social Icon', 'startkit' ),				
				'social' => array()
			);
		
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		}
		function enqueue_scripts() {
			
			wp_enqueue_style( 'social-icon-widget' );
		}
		
		// Widget Form Section  
		function form( $instance ) {
		 
		$instance = wp_parse_args( (array) $instance, $this->defaults );

		$social_links = startkit_widget_get_social();
?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e( 'Title', 'startkit' ); ?>:</label>
			<input id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" type="text" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr($instance['title']); ?>" class="widefat" />
		</p>
		<ul class="mks_social_container mks-social-sortable">
		  <?php foreach ( $instance['social'] as $link ) : ?>
			  <li>
			  	<?php $this->draw_social( $this, $social_links, $link ); ?>
			  </li>
			<?php endforeach; ?>
		</ul>


		<p>
	  	<a href="#" class="mks_add_social button"><?php _e( 'Add Icon', 'startkit' ); ?></a>
	  </p>

	  <div class="mks_social_clone" style="display:none">
			<?php $this->draw_social( $this, $social_links ); ?>
	  </div>
		
<?php
	}

	function draw_social( $widget, $social_links, $selected = array( 'icon' => '', 'url' => '' ) ) { ?>

				<label class="mks-sw-icon"><?php _e( 'Icon', 'startkit' ); ?> :</label>
				<select type="text" class="iconPicker" name="<?php echo esc_attr($widget->get_field_name( 'social_icon' )); ?>[]" value="<?php echo esc_attr($selected['icon']); ?>" style="font-family: 'FontAwesome', Arial; width: 82%">
					<?php foreach ( $social_links as $key => $link ) : ?>
						<option value="<?php echo esc_attr($key); ?>" <?php selected( $key, $selected['icon'] ); ?>><?php echo esc_html($link); ?></option>
					<?php endforeach; ?>
				</select>
				</br>
				<label class="mks-sw-icon"><?php _e( 'Url', 'startkit' ); ?> :</label>
				<input type="text" name="<?php echo esc_attr($widget->get_field_name( 'social_url' )); ?>[]" value="<?php echo esc_attr($selected['url']); ?>" placeholder="Example.com" style="width: 82%">


				<span class="mks-remove-social dashicons dashicons-no-alt"></span>

	<?php }
	
	// Upadte data
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );	
		$instance['social'] = array();
		if ( !empty( $new_instance['social_icon'] ) ) {
			$protocols = wp_allowed_protocols();
			$protocols[] = 'skype'; 
			for ( $i=0; $i < ( count( $new_instance['social_icon'] ) - 1 ); $i++ ) {
				$temp = array( 'icon' => $new_instance['social_icon'][$i], 'url' => esc_url( $new_instance['social_url'][$i], $protocols ) );
				$instance['social'][] = $temp;
			}
		}
			
		return $instance;
	}
	
	// Front page data
	function widget( $args, $instance ) {

		extract( $args );

		$instance = wp_parse_args( (array) $instance, $this->defaults );
		
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo $before_widget;

		if ( !empty( $title ) ) {
			echo $before_title . $title . $after_title;
		}
?>
		
		
		<ul class="header-social d-inline-block">
		  <?php foreach ( $instance['social'] as $item ) : ?>
		 		<li><a href="<?php echo esc_url($item['url']); ?>" class="socicon-<?php echo esc_attr( $item['icon'] ); ?> "><i class="fa <?php echo esc_attr($item['icon']); ?>"></i></a></li>
		 	<?php endforeach; ?>
		</ul>
		


		<?php
		echo $after_widget;
	}
	
	
	
	// Define social icon List
	protected function get_social_title( $social_name ) {
		$items = $this->startkit_widget_get_social();
		return $items[$social_name];
	}
}