<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package started
 */
?>

	</div><!-- #content -->

	<footer id="colophon" class="site-footer" role="contentinfo">
		<div class="inner">
			<?php if( has_nav_menu( 'footer-menu', 'started' ) ) { ?>
				<?php wp_nav_menu( array(
									   'container'      => '',
									   'fallback_cb'    => false,
									   'menu_class'     => 'footer-menu',
									   'theme_location' => 'footer-menu'
								   )
				);
				?>
			<?php } ?>
			<div class="site-info">
				<?php _e( 'Copyright', 'started' ); ?> &copy; <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
				<span class="sep"> | </span>
				<a href="<?php echo esc_url( __( 'http://wordpress.org/', 'started' ) ); ?>"><?php printf( __( 'Powered by %s', 'started' ), 'WordPress' ); ?></a>
				<span class="sep"> | </span>
				<?php printf( __( 'Theme: %1$s by %2$s.', 'started' ), 'started', '<a href="https://qdkfweb.cn/" rel="designer">Jack</a>' ); ?>
			</div><!-- .site-info -->
		</div>
	</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
