<?php
  if ( function_exists('register_sidebar') )
register_sidebar(array(
'before_widget' => '<li id="%1$s" class="widget %2$s">',
'after_widget' => '</li>',
'before_title' => '<h2 class="title2">',
'after_title' => '</h2>',
));?>
<?php 
function mytheme_comment($comment, $args, $depth) {
	
   $GLOBALS['comment'] = $comment; ?>
   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
     <div id="comment-<?php comment_ID(); ?>">
      <div class="comment-author vcard">
         <?php echo get_avatar($comment,$size='36',$default='<path_to_url>' ); ?>
         <?php printf(__('<cite class="fn">%s</cite> <span class="says">says:</span>'), get_comment_author_link()) ?>
      </div>
      <?php if ($comment->comment_approved == '0') : ?>
         <em><?php _e('Your comment is awaiting moderation.') ?></em>
         <br />
      <?php endif; ?>

      <div class="comment-meta commentmetadata"><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(__('%1$s at %2$s'), get_comment_date(),  get_comment_time()) ?></a><?php edit_comment_link(__('(Edit)'),'  ','') ?></div>

      <?php comment_text() ?>

      <div class="reply">
         <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
      </div>
     </div>
         <?php  }
define('HEADER_IMAGE', '%s/images/' . get_starocean_option('header')); // %s is theme directory URI
define('HEADER_IMAGE_WIDTH', 958);
define('HEADER_IMAGE_HEIGHT', 108);
define('NO_HEADER_TEXT', true);
add_custom_image_header('', 'starocean_admin_header_style');


function starocean_admin_header_style() { ?>
	<style type="text/css">
	#headimg {
		height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;
		width: <?php echo HEADER_IMAGE_WIDTH; ?>px;
	}
	#headimg h1, #headimg #desc {
		display: none;
	}
	</style>
<?php }
/**
 * class Options
 * 
 * The Options class handles the retrieval and setting of starocean's options,
 * although an external function, save_starocean_options(), saves updated
 * options to the database (via WordPress's API functions). Options can be
 * set on the starocean Options page, which can be found in the WP admin panel:
 * Presentation > starocean Options, or /wp-admin/themes.php?page=starocean-options
 * in your WordPress directory.
 * @package starocean
 * @since 2.0
 */
class Options {
	
	var $installed;
	var $deleted;
	var $update_notification;
	var $sidebar_pp_type;
	var $header;
	var $display_title;
	var $display_tagline;
	var $nav_pages;
	var $collapsed_pages;
	var $home_link_name;
	var $nav_extlinkcat;
	var $style;
	var $asidescategory;
	var $centred_theme;
	var $swap_sides;
	var $tags_everywhere;
	var $show_categories;
	var $show_authors;
	var $use_pages;
	
	/**
	 * starocean_options_defaults() - Sets Options object's properties to their default values.
	 * 
	 * @since 2.0
	 */
function get_starocean_option($name) {
	global $starocean_options;
	
	if(!is_object($starocean_options))
		flush_starocean_options();
	
	return $starocean_options->$name;
}
function flush_starocean_options() {
	global $starocean_options;
	$starocean_options = new Options;
	$starocean_options->starocean_options_get();
	
	if(!get_option('starocean_options') || isset($starocean_options->deleted))
		$starocean_options->starocean_options_defaults();
}	/**
	 * starocean_options_get() - Sets Options properties to the values retrieved from the database.
	 * 
	 * @since 2.0
	 */
	function starocean_options_get() {
		$saved_options = maybe_unserialize(get_option('starocean_options'));
		
		if(!empty($saved_options) && is_object($saved_options)) {
			foreach($saved_options as $name => $value) {
				$this->$name = $value;
			}
		}
	}
	function theme_version() {
	$themedata = get_theme_data(TEMPLATEPATH . '/style.css');
	$version = trim($themedata['Version']);
	
	if (strlen($version) > 0)
		return $version;
}
	/**
	 * starocean_options_defaults() - Sets Options object's properties to their default values.
	 * 
	 * @since 2.0
	 */
function starocean_options_defaults() {
		$this->update_notification = true;
		$this->sidebar_pp_type = 'main';
		$this->header = 'header.jpg';
		$this->display_title = true;
		$this->display_tagline = true;
		$this->nav_pages = false;
		$this->collapsed_pages = '';
		$this->home_link_name = __('Home','starocean');
		$this->nav_extlinkcat = 0;
		$this->style = false;
		$this->asidescategory = 0;
		$this->centred_theme = true;
		$this->swap_sides = false;
		$this->swap_title_order = false;
		$this->tags_everywhere = false;
		$this->show_categories = true;
		$this->show_authors = true;
		$this->use_pages = true;
	}
	

	/**
	 * starocean_options_update() - Sets Options properties to the values set on the Options page.
	 * 
	 * Note that this function doesn't save anything to the database, that's the
	 * preserve of save_starocean_options().
	 * @since 2.0
	 * @see save_starocean_options()
	 */
	function starocean_options_update() {
		if(($_POST['delete_options'] == 1)) {
			$this->deleted = time();
		} elseif($_POST['restore_options'] == 1) {
			unset($this->deleted);
		} else {
			if($_POST['update_notification'] == 'off')
				$this->update_notification = false;
			elseif($_POST['update_notification'] == 'on')
				$this->update_notification = true;
			
			$header = $_POST['header_image'];
			if(isset($header)) {
				$header = str_replace('-thumb', '', $header);
				$this->header = $header;
			}
			
			$nav_pages = $_POST['nav_pages'];
			if(isset($nav_pages)) {
				$nav_pages = implode(',', $nav_pages);
				$this->nav_pages = $nav_pages;
			} else {
				$this->nav_pages = false;
			}
			
			$collapsed_pages = $_POST['collapsed_pages'];
			if(isset($collapsed_pages)) {
				$this->collapsed_pages = $collapsed_pages;
			} else {
				$this->collapsed_pages = '';
			}
			
			$stylefile = $_POST['alternate_style'];
			if(is_valid_starocean_style($stylefile))
				$this->style = $stylefile;
			elseif(!$stylefile)
				$this->style = false;
			
			$this->display_title = (bool) $_POST['display_title'];
			$this->display_tagline = (bool) $_POST['display_tagline'];
			$this->show_categories = (bool) $_POST['show_categories'];
			$this->tags_everywhere = (bool) $_POST['tags_everywhere'];
			$this->use_pages = (bool) $_POST['use_pages'];
			$this->centred_theme = (bool) $_POST['centred_theme'];
			$this->swap_sides = (bool) $_POST['swap_sides'];
			$this->swap_title_order = (bool) $_POST['swap_title_order'];
			$this->asidescategory = $_POST['asides_category'];
			$this->nav_extlinkcat = $_POST['nav_extlinkcat'];
			$this->home_link_name = $_POST['home_link_name'];
			$this->sidebar_type = $_POST['sidebar_type'];
			$this->sidebar_pp_type = $_POST['sidebar_pp_type'];			
			$this->show_authors = starocean_should_show_authors();
			unset($this->deleted);
		}
	}

}

/**
 * save_starocean_options() - Saves a new set of starocean options.
 * 
 * If the starocean Options page request includes a $_POST call
 * and it's been generated by hitting the 'submit' button, this
 * function will generate a new Options object, set its properties
 * to the existing set of options, and then save the new options
 * over the old ones. It then flushes the options so the Options
 * page, which executes after this function, will display the new
 * values rather than the old ones.
 * @see staroceanupdate() which it replaces
 * @since 2.0
 */
function save_starocean_options() {
	$starocean_options = new Options;
	$starocean_options->starocean_options_get();
	
	if(ready_to_delete_options($starocean_options->deleted)) {
		delete_option('starocean_options');
		flush_starocean_options();
		return;
	}
	
	starocean_upgrade_and_flush_options();
	
	if(isset($_POST['submit'])) {
		$starocean_options->starocean_options_update();
		update_option('starocean_options', serialize($starocean_options));
	}
	
	flush_starocean_options();
}

/**
 * flush_starocean_options() - Flushes starocean's options for use by the theme.
 * 
 * Creates a new Options object, and gets the current options. If
 * no options have been set in the database, it will return the
 * defaults. Additionally, if the 'deleted' property has been set
 * then the function will check to see if it was set more than two
 * hours ago--if it was, the starocean_options database row will be
 * dropped. If the 'deleted' property has been set, then the defaults
 * will be returned regardless of whether other options are set.
 * @since 1.4
 * @global object $starocean_options
 * @return object $starocean_options
 */
function flush_starocean_options() {
	global $starocean_options;
	$starocean_options = new Options;
	$starocean_options->starocean_options_get();
	
	if(!get_option('starocean_options') || isset($starocean_options->deleted))
		$starocean_options->starocean_options_defaults();
}

/**
 * update_starocean_option() - Updates the given starocean option with a new value.
 * 
 * This function can be used either to update a particular option
 * with a new value, or to delete that option altogether by setting
 * $drop to true.
 * @since 1.4
 * @param string $option
 * @param string $value
 * @param boolean $drop
 * @global object $starocean_options
 */
function update_starocean_option($option, $value) {
	$starocean_options = new Options;
	$starocean_options->starocean_options_get();
		
	if(empty($value))
		unset($starocean_options->$option);
	else
		$starocean_options->$option = $value;
		
	update_option('starocean_options', serialize($starocean_options));
	flush_starocean_options();
}

/**
 * get_starocean_option() - Returns the given starocean option.
 * 
 * @since 1.4
 * @param string $name
 * @return mixed
 */
function get_starocean_option($name) {
	global $starocean_options;
	
	if(!is_object($starocean_options))
		flush_starocean_options();
	
	return $starocean_options->$name;
}
function starocean_headerimage() {
	if(get_theme_mod('header_image')) {
		$header_img_url = get_header_image();
	} elseif(get_starocean_option('header')) {
		if(get_starocean_option('header') != 'blank.gif') {
			$header_img_url = get_bloginfo('template_directory') . '/images/' . get_starocean_option('header');
		}
	} else {
		$header_img_url = get_bloginfo('template_directory') . '/images/header.jpg';
	}
	
	if($header_img_url) {
		if(get_starocean_option('display_title')) {
			$header_img_alt = __('Header image','starocean');		
		} else {
			$header_img_alt = get_bloginfo('name');
		}

		$header_img_tag = "<div id=\"img_bg\" style=\"background:url($header_img_url)\"><h1><a href=\"". get_option('home')."\">" .get_bloginfo('name') . "</a></h1><div class=\"description\">". get_bloginfo('description')."</div>";

		if(!get_starocean_option('display_title') && !is_wp_front_page()) {
			$header_img_tag = sprintf(
				'<a title="%1$s" rel="home" href="%2$s">%3$s</a>',
				__('Return to main page','starocean'),
				user_trailingslashit(get_bloginfo('url')),
				$header_img_tag
			);
		}
		
		echo '<div id="header-image">' . $header_img_tag.'</div></div>';}}
        ?>
