<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package stag-blocks
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php stagblocks_post_categories(); ?>
		<?php
		if ( is_singular() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		if ( 'post' === get_post_type() ) :
			?>
			<div class="entry-meta">
				<?php
					stagblocks_posted_by();
					stagblocks_posted_on();
				?>
			</div><!-- .entry-meta -->
			<?php
		endif;
		?>
	</header><!-- .entry-header -->

	<?php stagblocks_sticky_badge(); ?>
	<?php stagblocks_post_thumbnail(); ?>

	<div class="entry-content">
		<?php
		if ( is_singular() ) :
			the_content(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'stag-blocks' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				)
			);
		else :
			the_excerpt();
		endif;

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'stag-blocks' ),
				'after'  => '</div>',
			)
		);
		?>
	</div><!-- .entry-content -->

	<?php if ( is_singular() ) : ?>
	<footer class="entry-footer">
		<?php
		stagblocks_post_tags();
		stagblocks_edit_post_link();
		?>
	</footer><!-- .entry-footer -->
	<?php endif; ?>
	<hr />

	<?php
	if ( is_singular() ) :
		stagblocks_the_author_bio();
	endif;
	?>

</article><!-- #post-<?php the_ID(); ?> -->

<?php
if ( is_singular() ) :
	the_post_navigation(
		array(
			'prev_text' => '<div class="post-navigation-sub">' . esc_html__( 'Previous', 'stag-blocks' ) . '<img class="arrow-right" src="' . esc_url( get_theme_file_uri( '/images/back.svg' ) ) . '" alt="arrow-right" /></div><h3>%title</h3>',
			'next_text' => '<div class="post-navigation-sub"><img class="arrow-left" src="' . esc_url( get_theme_file_uri( '/images/back.svg' ) ) . '" alt="arrow-left" />' . esc_html__( 'Next', 'stag-blocks' ) . '</div><h3>%title</h3>',
		)
	);

	// If comments are open or we have at least one comment, load up the comment template.
	if ( comments_open() || get_comments_number() ) :
		comments_template();
	endif;
endif;
