<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package stag-blocks
 */

get_header(); ?>

	<main id="primary" class="site-main">

	<?php
			/**
			 * Include the component stylesheet for the content.
			 * This call runs only once on index and archive pages.
			 * At some point, override functionality should be built in similar to the template part below.
			 */
		wp_print_styles( array( 'stag-blocks-content' ) ); // Note: If this was already done it will be skipped.


	if ( have_posts() ) :


		/* Display the appropriate header when required. */
		stagblocks_index_header();

		/* Start the Loop. */
		while ( have_posts() ) :
			the_post();

			/*
			 * Include the Post-Type-specific template for the content.
			 * If you want to override this in a child theme, then include a file
			 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
			 */
			get_template_part( 'template-parts/content', get_post_type() );

		endwhile;

		if ( ! is_singular() ) :
			the_posts_navigation(
				array(
					'prev_text' => '<h5>' . esc_html__( 'Older Posts', 'stag-blocks' ) . '</h5><div class="separator"></div><img class="arrow-right" src="' . esc_url( get_theme_file_uri( '/images/back.svg' ) ) . '" alt="arrow-right" />',
					'next_text' => '<img class="arrow-left" src="' . esc_url( get_theme_file_uri( '/images/back.svg' ) ) . '" alt="arrow-left" /><div class="separator"></div><h5>' . esc_html__( 'Newer Posts', 'stag-blocks' ) . '</h5>',
				)
			);
		endif;

	else :

		get_template_part( 'template-parts/content', 'none' );

	endif;
	?>

	</main><!-- #primary -->

<?php
get_footer();
