<?php
/**
 * Jetpack Compatibility File
 *
 * @link https://jetpack.com/
 *
 * @package stag-blocks
 */

/**
 * Jetpack setup function.
 *
 * See: https://jetpack.com/support/infinite-scroll/
 * See: https://jetpack.com/support/responsive-videos/
 * See: https://jetpack.com/support/content-options/
 */
function stagblocks_jetpack_setup() {
	// Add theme support for Infinite Scroll.
	add_theme_support(
		'infinite-scroll', array(
			'container' => 'main',
			'render'    => 'stagblocks_infinite_scroll_render',
			'footer'    => 'page',
		)
	);

	// Add theme support for Responsive Videos.
	add_theme_support( 'jetpack-responsive-videos' );

	// Add theme support for Content Options.
	add_theme_support(
		'jetpack-content-options', array(
			'author-bio'   => true, // display or not the author bio: true or false.
			'post-details' => array(
				'stylesheet' => 'stag-blocks-base-style',
				'date'       => '.posted-on',
				'categories' => '.cat-links',
				'tags'       => '.tags-links',
				'author'     => '.byline',
			),
		)
	);

	add_theme_support( 'jetpack-social-menu' );
}
add_action( 'after_setup_theme', 'stagblocks_jetpack_setup' );

/**
 * Custom render function for Infinite Scroll.
 */
function stagblocks_infinite_scroll_render() {
	while ( have_posts() ) {
		the_post();
		if ( is_search() ) :
			get_template_part( 'template-parts/content', 'search' );
		else :
			get_template_part( 'template-parts/content', get_post_type() );
		endif;
	}
}

/**
 * Author Bio Avatar Size.
 */
function stagblocks_author_bio_avatar_size() {
	return 160; // in px.
}
add_filter( 'jetpack_author_bio_avatar_size', 'stagblocks_author_bio_avatar_size' );
