<?php
/**
 * Stag Blocks Theme Customizer
 *
 * @package stag-blocks
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function stagblocks_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname', array(
				'selector'        => '.site-title a',
				'render_callback' => 'stagblocks_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription', array(
				'selector'        => '.site-description',
				'render_callback' => 'stagblocks_customize_partial_blogdescription',
			)
		);
	}

	/**
	 * Theme options.
	 */
	$wp_customize->add_panel(
		'theme_options', array(
			'title'    => __( 'Theme Options', 'stag-blocks' ),
			'priority' => 130, // Before Additional CSS.
		)
	);

	// Accent Color Settings.
	$wp_customize->add_setting(
		'accent_color', array(
			'default'           => '#3575ff',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_hex_color', // The hue is stored as a positive integer.
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'accent_color', array(
				'section'  => 'colors',
				'priority' => 1,
				'label'    => __( 'Accent Color', 'stag-blocks' ),
			)
		)
	);

	// Lazy Loading.
	$wp_customize->add_section(
		'stagblocks_lazy_load_media', array(
			'title' => __( 'Lazy Load Images', 'stag-blocks' ),
			'panel' => 'theme_options',
		)
	);

	if ( function_exists( 'stagblocks_lazyload_images' ) ) {
		$wp_customize->add_setting(
			'lazy_load_media', array(
				'default'           => 'lazyload',
				'sanitize_callback' => 'stagblocks_sanitize_lazy_load_media',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			'lazy_load_media', array(
				'label'       => __( 'Lazy-load images', 'stag-blocks' ),
				'section'     => 'stagblocks_lazy_load_media',
				'type'        => 'radio',
				'description' => __( 'Lazy-loading images means images are loaded only when they are in view. Improves performance, but can result in content jumping around on slower connections.', 'stag-blocks' ),
				'choices'     => array(
					'lazyload'    => __( 'Lazy-load on (default)', 'stag-blocks' ),
					'no-lazyload' => __( 'Lazy-load off', 'stag-blocks' ),
				),
			)
		);
	}

	// Footer Options.
	$wp_customize->add_section(
		'footer_options', array(
			'title' => __( 'Footer', 'stag-blocks' ),
			'panel' => 'theme_options',
		)
	);

	$wp_customize->add_setting(
		'theme_credits', array(
			'default'           => false,
			'sanitize_callback' => 'stagblocks_sanitize_checkbox',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'theme_credits', array(
			'label'   => __( 'Hide Theme Credits', 'stag-blocks' ),
			'section' => 'footer_options',
			'type'    => 'checkbox',
		)
	);
}
add_action( 'customize_register', 'stagblocks_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function stagblocks_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function stagblocks_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function stagblocks_customize_preview_js() {
	wp_enqueue_script( 'stag-blocks-customizer', get_theme_file_uri( '/js/customizer.js' ), array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'stagblocks_customize_preview_js' );

/**
 * Sanitize the lazy-load media options.
 *
 * @param string $input Lazy-load setting.
 */
function stagblocks_sanitize_lazy_load_media( $input ) {
	$valid = array(
		'lazyload'    => __( 'Lazy-load images', 'stag-blocks' ),
		'no-lazyload' => __( 'Load images immediately', 'stag-blocks' ),
	);

	if ( array_key_exists( $input, $valid ) ) {
		return $input;
	}

	return '';
}

/**
 * Sanitize checkbox booleans.
 *
 * @param boolean $checked checkbox setting.
 */
function stagblocks_sanitize_checkbox( $checked ) {
	return ( ( ! empty( $checked ) ) ? true : false );
}
