<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package stag-blocks
 */

?>
<!doctype html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php if ( ! stagblocks_is_amp() ) : ?>
		<script>document.documentElement.classList.remove("no-js");</script>
	<?php endif; ?>

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'stag-blocks' ); ?></a>
		<header id="masthead" class="site-header">
			<?php if ( has_header_image() ) : ?>
				<figure class="header-image">
					<?php the_header_image_tag(); ?>
				</figure>
			<?php endif; ?>
			<div class="header-container">
				<div class="site-branding">
					<?php the_custom_logo(); ?>
					<?php if ( is_front_page() && is_home() ) : ?>
						<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
					<?php else : ?>
						<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
					<?php endif; ?>

					<?php $stagblocks_description = get_bloginfo( 'description', 'display' ); ?>
					<?php if ( $stagblocks_description || is_customize_preview() ) : ?>
						<p class="site-description"><?php echo $stagblocks_description; /* WPCS: xss ok. */ ?></p>
					<?php endif; ?>
				</div><!-- .site-branding -->

				<nav id="site-navigation" class="main-navigation" aria-label="<?php esc_attr_e( 'Main menu', 'stag-blocks' ); ?>"
					<?php if ( stagblocks_is_amp() ) : ?>
						[class]=" siteNavigationMenu.expanded ? 'main-navigation toggled-on' : 'main-navigation' "
					<?php endif; ?>
				>
					<?php if ( stagblocks_is_amp() ) : ?>
						<amp-state id="siteNavigationMenu">
							<script type="application/json">
								{
									"expanded": false
								}
							</script>
						</amp-state>
					<?php endif; ?>

					<button class="menu-toggle" aria-label="<?php esc_attr_e( 'Open menu', 'stag-blocks' ); ?>" aria-controls="primary-menu" aria-expanded="false"
						<?php if ( stagblocks_is_amp() ) : ?>
							on="tap:AMP.setState( { siteNavigationMenu: { expanded: ! siteNavigationMenu.expanded } } )"
							[aria-expanded]="siteNavigationMenu.expanded ? 'true' : 'false'"
						<?php endif; ?>
					>
					<img class="menu-toggle-icon" src="<?php echo esc_url( get_theme_file_uri( '/images/menu.svg' ) ); ?>" alt="menu-icon">
					</button>

					<div class="primary-menu-container">

					<button class="menu-close-btn">
						<img class="menu-close-icon" src="<?php echo esc_url( get_theme_file_uri( '/images/close-button.svg' ) ); ?>" alt="menu-close-icon">
					</button>
						<?php

						wp_nav_menu(
							array(
								'theme_location' => 'primary',
								'menu_id'        => 'primary-menu',
								'container'      => 'ul',
							)
						);
						?>
						<span class="search-toggle">
							<img class="search-icon" src="<?php echo esc_url( get_theme_file_uri( '/images/search.svg' ) ); ?>" alt="">
						</span>
						<div class="header-search-form">
								<?php get_search_form(); ?>
						</div>
					</div>
				</nav><!-- #site-navigation -->
			</div><!-- .header-container -->
		</header><!-- #masthead -->
