<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package stag-blocks
 */

$theme_credits = get_theme_mod( 'theme_credits', false );
?>

<footer id="colophon" class="site-footer">
	<?php get_sidebar(); ?>

	<?php
	if ( function_exists( 'jetpack_social_menu' ) ) {
		jetpack_social_menu();
	}
	?>

	<?php if ( ! $theme_credits ) : ?>
	<div class="site-info">
		<?php
			/* translators: 1: Theme name, 2: Theme author. */
			printf( esc_html__( '%1$s Theme by %2$s', 'stag-blocks' ), 'Stag Blocks', '<a href="https://codestag.com/"><img class="credits-logo" src="' . esc_url( get_theme_file_uri( '/images/codestag.svg' ) ) . '" alt="Codestag"/></a>' );
		?>
	</div><!-- .site-info -->
	<?php endif; ?>
</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
