<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package stag-blocks
 */

get_header(); ?>
<?php wp_print_styles( array( 'stag-blocks-content' ) ); ?>
<?php wp_print_styles( array( 'stag-blocks-404' ) ); ?>
	<main id="primary" class="site-main">

		<section class="error-404 not-found">
			<header class="page-header">
				<h1 class="title-404"><?php esc_html_e( '404', 'stag-blocks' ); ?></h1>
				<h1 class="description-404"><?php esc_html_e( 'Oops! The page you were looking for doesn&rsquo;t exist.', 'stag-blocks' ); ?></h1>
			</header><!-- .page-header -->

			<div class="content-404">
				<p><?php esc_html_e( 'You may have mistyped the address or the page have been moved.', 'stag-blocks' ); ?></p>
				<p><?php esc_html_e( 'Try searching again or ', 'stag-blocks' ); ?><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php esc_html_e( 'go back to the homepage.', 'stag-blocks' ); ?></a></p>

				<?php
					get_search_form();
				?>

			</div><!-- .page-content -->
		</section><!-- .error-404 -->

	</main><!-- #primary -->

<?php
get_footer();
