jQuery(function ($) {
  $('.parent-import-container').each(function () {
    var $wrap = $('<div>', { class: 'st-hosting-compare-feature' });

    var $btns = $('<div>', { class: 'st-hosting-portal-btn' });
    $('<a>', {
      href: 'https://striviothemes.com/product/hosting-wordpress-theme/',
      class: 'button button-primary st-hosting-buy-now',
      target: '_blank',
      text: 'Buy Now'
    }).appendTo($btns);
    $('<a>', {
      href: 'https://striviothemes.com/demo/st-hosting-pro/',
      class: 'button button-primary st-hosting-view-demo',
      target: '_blank',
      text: 'Demo'
    }).appendTo($btns);

    var $h2 = $('<h2>', {
      class: 'st-hosting-feature-comparison',
      text: 'Feature Comparison'
    });

    var rows = [
      ['Features', 'Pro', 'Free', true], // true => header row
      ['Animations', 'available', 'not-available'],
      ['Services Custom Posttype', 'available', 'not-available'],
      ['Booking Form', 'available', 'not-available'],
      ['About Page', 'available', 'not-available'],
      ['Contact Page', 'available', 'not-available'],
      ['Services Page', 'available', 'not-available'],
      ['Blog Page', 'available', 'not-available'],
      ['More Sections', 'available', 'not-available'],
      ['Before After Image', 'available', 'not-available'],
      ['Detailed Documentation', 'available', 'not-available']
    ];

    var $table = $('<table>', { class: 'st-hosting-compare-table' });

    rows.forEach(function (r, i) {
      var $tr = $('<tr>');
      if (r[3]) {
        $('<th>', { class: 'st-hosting-compare-th', text: r[0] }).appendTo($tr);
        $('<th>', { class: 'st-hosting-compare-th-pro', text: r[1] }).appendTo($tr);
        $('<th>', { class: 'st-hosting-compare-th', text: r[2] }).appendTo($tr);
      } else {
        $('<td>', { class: 'st-compare-td', text: r[0] }).appendTo($tr);
        $('<td>', {
          class: 'st-hosting-compare-td-pro'
        }).append($('<img>', {
          src: 'https://striviothemes.com/demo/st-demo-importer-imgs/' + r[1] + '.png',
          alt: r[1] === 'available' ? 'Available' : 'Not Available'
        })).appendTo($tr);
        $('<td>', {
          class: 'st-hosting-compare-td-free'
        }).append($('<img>', {
          src: 'https://striviothemes.com/demo/st-demo-importer-imgs/' + r[2] + '.png',
          alt: r[2] === 'available' ? 'Available' : 'Not Available'
        })).appendTo($tr);
      }
      $table.append($tr);
    });

    $wrap.append($btns, $h2, $table);
    $(this).append($wrap);
  });
});
