jQuery(function ($) {
  $('.parent-import-container').each(function () {
    var $wrap = $('<div>', { class: 'st-apostille-lite-compare-feature' });

    var $btns = $('<div>', { class: 'st-apostille-lite-portal-btn' });
    $('<a>', {
      href: 'https://striviothemes.com/product/apostille-lite-wordpress-theme/',
      class: 'button button-primary st-apostille-lite-buy-now',
      target: '_blank',
      text: 'Buy Now'
    }).appendTo($btns);
    $('<a>', {
      href: 'https://striviothemes.com/demo/st-apostille-services-pro/',
      class: 'button button-primary st-apostille-lite-view-demo',
      target: '_blank',
      text: 'Demo'
    }).appendTo($btns);

    var $h2 = $('<h2>', {
      class: 'st-apostille-lite-feature-comparison',
      text: 'Feature Comparison'
    });

    var rows = [
      ['Features', 'Pro', 'Free', true], // true => header row
      ['Animations', 'available', 'not-available'],
      ['Services Custom Posttype', 'available', 'not-available'],
      ['Booking Form', 'available', 'not-available'],
      ['About Page', 'available', 'not-available'],
      ['Contact Page', 'available', 'not-available'],
      ['Services Page', 'available', 'not-available'],
      ['Blog Page', 'available', 'not-available'],
      ['More Sections', 'available', 'not-available'],
      ['Before After Image', 'available', 'not-available'],
      ['Detailed Documentation', 'available', 'not-available']
    ];

    var $table = $('<table>', { class: 'st-apostille-lite-compare-table' });

    rows.forEach(function (r, i) {
      var $tr = $('<tr>');
      if (r[3]) {
        $('<th>', { class: 'st-apostille-lite-compare-th', text: r[0] }).appendTo($tr);
        $('<th>', { class: 'st-apostille-lite-compare-th-pro', text: r[1] }).appendTo($tr);
        $('<th>', { class: 'st-apostille-lite-compare-th', text: r[2] }).appendTo($tr);
      } else {
        $('<td>', { class: 'st-compare-td', text: r[0] }).appendTo($tr);
        $('<td>', {
          class: 'st-apostille-lite-compare-td-pro'
        }).append($('<img>', {
          src: 'https://striviothemes.com/demo/st-demo-importer-imgs/' + r[1] + '.png',
          alt: r[1] === 'available' ? 'Available' : 'Not Available'
        })).appendTo($tr);
        $('<td>', {
          class: 'st-apostille-lite-compare-td-free'
        }).append($('<img>', {
          src: 'https://striviothemes.com/demo/st-demo-importer-imgs/' + r[2] + '.png',
          alt: r[2] === 'available' ? 'Available' : 'Not Available'
        })).appendTo($tr);
      }
      $table.append($tr);
    });

    $wrap.append($btns, $h2, $table);
    $(this).append($wrap);
  });
});
