<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php if (is_singular()): ?>
			<div id="single-title">
				<?php the_title('<h1>','</h1>'); ?>
				<div id="single-title-meta">
					<?php the_author_meta('display_name'); ?> - <?php echo get_the_date(); ?> -
					<?php
						$categories = wp_get_post_categories($id);
						foreach($categories as $category){
							$data = get_category($category);
							echo esc_html($data->name) . ' <span>/</span>';
						}
					?>					
				</div>
			</div>
			<?php
				if (has_post_thumbnail()):
					the_post_thumbnail();
				endif;
			?>
			<div id="single-content">
				<?php the_content(); ?>
				<?php the_tags('<ul id="post-tags"><li>#', '</li><li>#', '</li></ul>'); ?>
				<div class="clearfix"></div>
				<?php wp_link_pages(); ?>
			</div>
		<?php else: ?>
			<div class="teaser">
				<h3 class="teaser-title">
					<a href="<?php echo esc_url(get_permalink()); ?>">
						<span><?php the_title(); ?></span>
						<span><?php echo get_the_date(); ?></span>
					</a>
				</h3>
				<div class="teaser-excerpt"><?php the_excerpt(); ?></div>
			</div>
		<?php endif; ?>
</article>
