<?php
  $tncinf_single_page_template_parts = new ClassSinglePageTemplateParts();
  $tncinf_common_page_template_parts = new ClassCommonPageTemplateParts();
?>

<div class="single-page-banner-wrapper">
  <div class="container-fluid tncinf-px-0 tncinf-mx-0">
    <div class="row tncinf-px-0 tncinf-mx-0">
      <div class="col-12 tncinf-px-0 tncinf-mx-0">
        <?php echo $tncinf_common_page_template_parts->tncinf_full_width_banner_with_search_form('Blog Details'); ?>
      </div>
    </div>
  </div>
</div>


<div class="container tncinf-single-page-article-wrapper">
	<div class="row">
		<div class="col-12">
			<?php				

				while ( have_posts() ) : the_post();
          ?>

          <article id="post-<?php the_ID(); ?>" <?php post_class( 'tncinf-single-blog-page tncinf-right-sidebar-single-blog-page' ); ?>>
            <?php if ( is_singular() ): ?>
              <?php if ( has_post_thumbnail() ) : ?>
                  <div class="tncinf-single-page-thumbnail-image">
                    <?php  the_post_thumbnail( 'full', array( 'class' => 'img-fluid tncinf-thumbnail-image' ) );	?>
                  </div>
                <?php else: ?>
                  <?php if( $tncinf_single_page_template_parts->tncinf_hide_or_show_default_featured_image_on_single_post() == true ) { ?>
                    <div class="tncinf-single-page-thumbnail-image">
                      <?php echo $tncinf_common_page_template_parts->get_default_placeholder_thumbnail_image_tag_set_by_user(); ?>
                    </div>
                  <?php } ?>
                <?php endif; ?>
                <div class="tncinf-single-page-author-date-category">
                  <span class="tncinf-single-page-author-img-and-name d-flex align-items-center">
                    <span class="tncinf-single-page-author-img">
                      <?php
                      $author_id = get_the_author_meta('ID');
                      echo tncinf_author_gravatar_image($author_id, 30);
                      ?>
                    </span>
                    <span class="tncinf-single-page-author-name">
                      <a class="text-decoration-none" href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>" title="<?php echo esc_attr(get_the_author()); ?>"><?php the_author(); ?></a>
                    </span>
                  </span>

                  <span class="d-flex align-items-center">
                    <span class="tncinf-meta-icon"><i class="icofont-clock-time"></i></span>                
                    <span class="tncinf-single-page-date">
                      <?php echo get_the_date(); ?>
                    </span>
                  </span>

                  <span class="d-flex align-items-center">
                    <span class="tncinf-meta-icon"><i class="icofont-label"></i></span>
                    <span class="tncinf-single-page-category">
                      <?php
                      $categories = get_the_category();
                      if (!empty($categories)) {
                        echo '<a class="text-decoration-none" href="' . esc_url(get_category_link($categories[0]->term_id)) . '">' . esc_html($categories[0]->name) . '</a>';
                      }
                      ?>
                    </span>
                  </span>             
                </div>
                <h1 class="teaser-heading"><?php the_title(); ?></h1>
                <div class="tncinf-single-page-content-wrapper">
                  <?php the_content(); ?>
                </div>
                <div class="tncinf-single-page-tag-and-share-options">
                  <div class="row">
                    <div class="col-md-6">
                      <div class="tag-list">
                        <?php
                          the_tags('<ul id="post-tags"><li>', '</li><li>', '</li></ul>');
                        ?>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <?php
                        $tncinf_customize_single_post_hide_social_share_setting = get_theme_mod('tncinf_customize_single_post_hide_social_share_setting', true );
                        if( $tncinf_customize_single_post_hide_social_share_setting == true ) :
                      ?>
                        <div class="social-share">
                          <ul>
                            <li>
                              <?php
                                $share_url   =  get_permalink();
                                $share_title =  get_the_title();
                                $wp_get_attachment_url = wp_get_attachment_url(get_post_thumbnail_id());

                                printf('<a title="Facebook" target="_blank" class="share-item pin-it-button" href="https://www.facebook.com/sharer/sharer.php?u=%s"><i class="icofont-facebook"></i></a>', $share_url);
                                printf('<a title="Twitter" target="_blank" class="share-item pin-it-button" href="https://twitter.com/intent/tweet?url=%s&text=%s"><i class="icofont-twitter"></i></a>', $share_url,$share_title);
                                printf('<a title="Pinterest" target="_blank" class="share-item pin-it-button" href="//www.pinterest.com/pin/create/button/?url=%s&media=%s&description=%s" data-pin-do="buttonPin" data-pin-config="above"><i class="icofont-pinterest"></i></a>', $share_url,$wp_get_attachment_url,$share_title );
                              ?>
                            </li>
                          </ul>
                        </div>
                      <?php
                        endif;
                      ?>
                    </div>
                  </div>
                </div>

            <?php else: ?>
              <div class="teaser-date"><?php if (is_sticky()): echo'<span>'; esc_html_e('Featured - ', 'tnc-infinity'); echo'</span>'; endif; ?><?php echo get_the_date(); ?></div>
              <?php the_title('<h3 class="teaser-heading"><a href="' . esc_url(get_permalink()) . '">', '</a></h3>'); ?>
              <div class="teaser-excerpt"><?php the_excerpt(); ?></div>
            <?php endif; ?>
          </article>

          <?php
          if (comments_open() || get_comments_number()):
            comments_template();
          endif;
				endwhile;
			?>
		</div>
	</div>
</div>

<?php
  $tncinf_show_hide_subscribe_button = get_theme_mod('tncinf_show_hide_subscribe_button', true );
  if( $tncinf_show_hide_subscribe_button  == true ) :
?>
<div class="tncinf-newsletter-subscribe-linkable-button-wrapper">
  <?php echo $tncinf_common_page_template_parts->tncinf_newsletter_subscribe_linkable_button(); ?>
</div>
<?php endif; ?>








