<?php
  $tncinf_blog_page_template_parts = new ClassBlogPageTemplateParts();
  $tncinf_common_page_template_parts = new ClassCommonPageTemplateParts();
?>


<?php
  if( get_theme_mod( 'tncinf_customize_blog_page_with_right_sidebar_feature_post' ) != false ) {
    $tncinf_customize_blog_page_with_right_sidebar_feature_post = get_theme_mod( 'tncinf_customize_blog_page_with_right_sidebar_feature_post', '' );
  } else {
    $tncinf_customize_blog_page_with_right_sidebar_feature_post = '';
  }

  if( get_theme_mod( 'tncinf_customize_blog_page_with_right_sidebar_popular_post' ) != false ) {
    $tncinf_customize_blog_page_with_right_sidebar_popular_post = get_theme_mod( 'tncinf_customize_blog_page_with_right_sidebar_popular_post', '' );
  } else {
    $tncinf_customize_blog_page_with_right_sidebar_popular_post = '';
  }

  if( get_theme_mod( 'tncinf_customize_blog_page_with_right_sidebar_image_gallery' ) != false ) {
    $tncinf_customize_blog_page_with_right_sidebar_image_gallery = get_theme_mod( 'tncinf_customize_blog_page_with_right_sidebar_image_gallery', '' );
  } else {
    $tncinf_customize_blog_page_with_right_sidebar_image_gallery = '';
  }
?>


<?php
  $args_main_feature_post = array ( 
    'category_name' => $tncinf_customize_blog_page_with_right_sidebar_feature_post,
    'post_status' => 'publish',
    'posts_per_page' => 1,
    'ignore_sticky_posts' => true,
  );
  $query_main_feature_post = new WP_Query( $args_main_feature_post );

  $args_popular_post = array ( 
    'category_name' => $tncinf_customize_blog_page_with_right_sidebar_popular_post,
    'post_status' => 'publish',
    'posts_per_page' => 2,
    'ignore_sticky_posts' => true,
  );
  $query_popular_post = new WP_Query( $args_popular_post );

  $args_image_gallery_post = array ( 
    'category_name' => $tncinf_customize_blog_page_with_right_sidebar_image_gallery,
    'post_status' => 'publish',
    'posts_per_page' => 1,
    'ignore_sticky_posts' => true,
  );
  $query_image_gallery_post = new WP_Query( $args_image_gallery_post );
?>


<div class="tncinf-blog-page-right-sidebar-template-wrapper">
  <div class="tncinf-blog-page-banner-wrapper">  
    <?php echo $tncinf_common_page_template_parts->tncinf_full_width_banner_with_search_form('Blog Section'); ?>
  </div>

  <div class="tncinf-blog-page-blog-cards-wrapper tncinf-all-blog-card-wrapper">
    <div class="container">
      <div class="row">
        <main class="col-md-8">

          <div class="row main-feature-post">
            <?php if ( $query_main_feature_post->have_posts() ) : while ( $query_main_feature_post->have_posts() ) :  $query_main_feature_post->the_post(); ?>
              <div class="col-12 tncinf-card-column">
                <div class="tncinf-blog-card-wrapper">
                  <?php echo $tncinf_blog_page_template_parts->tncinf_card_full_image(); ?>
                </div>
              </div>
            <?php endwhile; else : ?>
              <p><?php _e( 'Sorry, no posts matched your criteria.', 'tnc-infinity' ); ?></p>
            <?php endif; ?>
            <?php wp_reset_postdata(); ?>
          </div>

          <div class="row popular-post">
            <div class="col-12">
              <div class="row">
                <div class="col-6 tncinf-card-section-title">                  
                  <?php 
                    $tncinf_customize_blog_page_with_right_sidebar_popular_post_title = esc_html ( get_theme_mod( 'tncinf_customize_blog_page_with_right_sidebar_popular_post_title', 'POPULAR NEWS') );
                    esc_html( $tncinf_customize_blog_page_with_right_sidebar_popular_post_title, 'tnc-infinity');                  
                  ?>                
                </div>
                <div class="col-6 tncinf-card-section-pagination"><?php echo tncinf_pagination_without_page_number(); ?></div>
              </div>
            </div>
            <?php if ( $query_popular_post->have_posts() ) : while ( $query_popular_post->have_posts() ) : $query_popular_post->the_post(); ?>
              <div class="col-lg-6 col-md-6 tncinf-card-column">
                <div class="tncinf-blog-card-wrapper">
                  <?php echo $tncinf_common_page_template_parts->tncinf_card(); ?>
                </div>
              </div>
            <?php endwhile; else : ?>
              <p><?php _e( 'Sorry, no posts matched your criteria.', 'tnc-infinity' ); ?></p>
            <?php endif; ?>
            <?php wp_reset_postdata(); ?>
          </div>

          <div class="row image-gallery-post">
            <div class="col-12">
              <div class="row">
                <div class="col-6 tncinf-card-section-title">
                  <?php 
                    $tncinf_customize_blog_page_with_right_sidebar_image_gallery_title = get_theme_mod( 'tncinf_customize_blog_page_with_right_sidebar_image_gallery_title', 'IMAGE GALLERY');
                    esc_html( $tncinf_customize_blog_page_with_right_sidebar_image_gallery_title, 'tnc-infinity' );
                  ?>
                </div>
                <div class="col-6 tncinf-card-section-pagination"><?php echo tncinf_pagination_without_page_number(); ?></div>
              </div>
            </div>
            
            <?php if ( $query_image_gallery_post->have_posts() ) : while ( $query_image_gallery_post->have_posts() ) : $query_image_gallery_post->the_post(); ?>
              <div class="col-12 tncinf-card-column">
                <div class="tncinf-blog-card-wrapper">
                  <?php echo $tncinf_blog_page_template_parts->tncinf_card_full_image_and_only_title(); ?>
                </div>
              </div>
            <?php endwhile; else : ?>
              <p><?php _e( 'Sorry, no posts matched your criteria.', 'tnc-infinity' ); ?></p>
            <?php endif; ?>
            <?php
              wp_reset_postdata();
            ?>
          </div>
        </main> 


        <aside class="col-md-4 tncinf-main-sidebar tncinf-sidebar-wrapper">
          <?php add_filter( 'the_title', 'tncinf_limit_the_title_word_count_for_sidebar' ); ?>
          <?php if ( is_active_sidebar( 'tncinf-regular-pages-sidebar' ) ) : ?>
            <div id="tncinf-regular-pages-sidebar-wrapper" class="tncinf-sidebar-area tncinf-style-one">
              <?php dynamic_sidebar( 'tncinf-regular-pages-sidebar' ); ?>
            </div>
          <?php endif; ?>
          <?php remove_filter( 'the_title', 'tncinf_limit_the_title_word_count_for_sidebar' ); ?>
        </aside>

      </div>
    </div>
  </div>

  <?php
    $tncinf_show_hide_subscribe_button = get_theme_mod('tncinf_show_hide_subscribe_button', true );
    if( $tncinf_show_hide_subscribe_button  == true ) :
  ?>
  <div class="tncinf-newsletter-subscribe-linkable-button-wrapper">
    <?php echo $tncinf_common_page_template_parts->tncinf_newsletter_subscribe_linkable_button(); ?>
  </div>
  <?php endif; ?>
</div>


