<?php
// setup theme
if (!function_exists('tncinfinity_setup')):
	function tncinfinity_setup() {
		add_theme_support('automatic-feed-links');
		add_theme_support('title-tag');
		add_theme_support('post-thumbnails');
		add_theme_support('custom-logo');
		add_theme_support('html5', array('search-form', 'comment-form', 'comment-list', 'gallery', 'caption'));
  	add_editor_style(get_template_directory_uri() . '/assets/css/editor.css');
		if (!isset($content_width)) $content_width = 700;
		add_image_size( 'tncinf-thumbnail-image', 520, 320, false );
		add_theme_support( 'custom-background' );
		add_theme_support( 'responsive-embeds' );
		add_theme_support( 'align-wide' );
		add_theme_support( 'wp-block-styles' );		
	}
endif;
add_action('after_setup_theme', 'tncinfinity_setup');

/**
 * Register block style
 */
if ( !function_exists( 'tnc_infinity_register_block_style' ) ) {
	function tnc_infinity_register_block_style() {
		wp_register_style( 'tnc-infinity-block-style', get_template_directory_uri() . '/assets/css/block-style.css' );
		register_block_style(
				'core/paragraph',
				array(
					'name'         => 'tnc-infinity-block-style',
					'label'        => __( 'TNC Infinity Style', 'tnc-infinity' ),
					'style_handle' => 'tnc-infinity-block-style',
				)
		);
	}
}
add_action( 'init', 'tnc_infinity_register_block_style' );

/**
 * Register block pattern
 */
if( !function_exists( 'tnc_infinity_register_block_pattern' ) ) {
	function tnc_infinity_register_block_pattern() {
		register_block_pattern(
				'tnc-infinity/tnc-infinity-paragraph-pattern',
				array(
						'title'       => __( 'TNC Infinity Paragraph', 'tnc-infinity' ),
						'description' => __( 'A tnc infinity paragraph pattern.', 'tnc-infinity' ),
						'categories'  => array( 'text' ),
						'content'     => '<!-- wp:paragraph -->
															<p style="background: #000;color: #fff;padding: 5px 6px;" >This is a tnc infinity block pattern.</p>
															<!-- /wp:paragraph -->',
				)
		);
	}
}
add_action( 'init', 'tnc_infinity_register_block_pattern' );


/**
 * Register Custom Navigation Walker
 */
function register_navwalker(){
	if ( ! file_exists( get_template_directory() . '/class-wp-bootstrap-navwalker.php' ) ) {
    return new WP_Error( 'class-wp-bootstrap-navwalker-missing', __( 'It appears the class-wp-bootstrap-navwalker.php file may be missing.', 'tnc-infinity' ) );
	} else {
		require_once get_template_directory() . '/class-wp-bootstrap-navwalker.php';
	}

	register_nav_menus( array(
    'primary' => __( 'Primary Menu', 'tnc-infinity' ),
		'footer' => esc_html__('Footer', 'tnc-infinity')
) );
}
add_action( 'after_setup_theme', 'register_navwalker' );



/*
* >> load css / js
*/
function tncinfinity_enqueue() {
	wp_enqueue_style('tnc-infinity-icofont-min-css', get_template_directory_uri() . '/assets/css/icofont.min.css', '', '1.0.0', 'all');
	wp_enqueue_style('tnc-infinity-bootstrap-grid.min', get_template_directory_uri() . '/assets/css/bootstrap-grid.min.css', '', '1.0.0', 'all');
	wp_enqueue_style('tnc-infinity-style', get_stylesheet_uri());

	wp_enqueue_script('tnc-infinity-bootstrap-min-js', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array('jquery'), '1.0.0', true);
	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}
}
add_action('wp_enqueue_scripts', 'tncinfinity_enqueue');


/*
* >> Load fonts
*/
function tncinf_load_fonts() {
	$tncinf_add_primary_font_url = get_theme_mod( 'tncinf_add_primary_font_url' );
	$tncinf_add_heading_font_url = get_theme_mod( 'tncinf_add_heading_font_url' );

	if($tncinf_add_primary_font_url != $tncinf_add_heading_font_url ) {
		if( $tncinf_add_primary_font_url != false || $tncinf_add_primary_font_url != '' || $tncinf_add_primary_font_url != null ) {
			switch ( $tncinf_add_primary_font_url ) {
				case "default_font": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap', false);	break;
				case "arvo": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Arvo:wght@400;700&display=swap', false);	break;
				case "cabin": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Cabin:wght@400;500;600;700&display=swap', false); break;
				case "inter":	wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap', false);	break;
				case "lato": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Lato:wght@300;400;700;900&display=swap', false);	break;
				case "lora": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Lora:wght@400;500;600;700&display=swap', false);	break;
				case "merriweather": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Merriweather:wght@300;400;700;900&display=swap', false);	break;
				case "montserrat": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700;800;900&display=swap', false);	break;
				case "open_sans": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700;800&display=swap', false);	break;
				case "oswald": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Oswald:wght@300;400;500;600;700&display=swap', false);	break;
				case "oxygen": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Oxygen:wght@300;400;700&display=swap', false);	break;
				case "playfair_display": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700;800;900&display=swap', false);	break;
				case "pt_sans": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=PT+Sans:wght@400;700&display=swap', false);	break;
				case "pt_sans_narrow": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=PT+Sans+Narrow:wght@400;700&display=swap', false);	break;
				case "pt_serif": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=PT+Serif:wght@400;700&display=swap', false);	break;
				case "raleway": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700;800;900&display=swap', false);	break;
				case "roboto": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700;900&display=swap', false);	break;
				default: wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap', false);
			}
		} else {
			wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap', false);
		}
		
		if( $tncinf_add_heading_font_url != false || $tncinf_add_heading_font_url != '' || $tncinf_add_heading_font_url != null ) {
			switch ( $tncinf_add_heading_font_url ) {
				case "default_font": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap', false);	break;
				case "arvo": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Arvo:wght@400;700&display=swap', false);	break;
				case "cabin": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Cabin:wght@400;500;600;700&display=swap', false); break;
				case "inter":	wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap', false);	break;
				case "lato": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Lato:wght@300;400;700;900&display=swap', false);	break;
				case "lora": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Lora:wght@400;500;600;700&display=swap', false);	break;
				case "merriweather": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Merriweather:wght@300;400;700;900&display=swap', false);	break;
				case "montserrat": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700;800;900&display=swap', false);	break;
				case "open_sans": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700;800&display=swap', false);	break;
				case "oswald": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Oswald:wght@300;400;500;600;700&display=swap', false);	break;
				case "oxygen": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Oxygen:wght@300;400;700&display=swap', false);	break;
				case "playfair_display": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700;800;900&display=swap', false);	break;
				case "pt_sans": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=PT+Sans:wght@400;700&display=swap', false);	break;
				case "pt_sans_narrow": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=PT+Sans+Narrow:wght@400;700&display=swap', false);	break;
				case "pt_serif": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=PT+Serif:wght@400;700&display=swap', false);	break;
				case "raleway": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700;800;900&display=swap', false);	break;
				case "roboto": wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700;900&display=swap', false);	break;
				default: wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap', false);
			}
		} else {
			wp_enqueue_style('tncinf-heading-font', '//fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap', false);
		}

	} else {
		if( $tncinf_add_primary_font_url != false || $tncinf_add_primary_font_url != '' || $tncinf_add_primary_font_url != null ) {
			switch ( $tncinf_add_primary_font_url ) {
				case "default_font": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap', false);	break;
				case "arvo": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Arvo:wght@400;700&display=swap', false);	break;
				case "cabin": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Cabin:wght@400;500;600;700&display=swap', false); break;
				case "inter":	wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap', false);	break;
				case "lato": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Lato:wght@300;400;700;900&display=swap', false);	break;
				case "lora": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Lora:wght@400;500;600;700&display=swap', false);	break;
				case "merriweather": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Merriweather:wght@300;400;700;900&display=swap', false);	break;
				case "montserrat": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700;800;900&display=swap', false);	break;
				case "open_sans": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700;800&display=swap', false);	break;
				case "oswald": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Oswald:wght@300;400;500;600;700&display=swap', false);	break;
				case "oxygen": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Oxygen:wght@300;400;700&display=swap', false);	break;
				case "playfair_display": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700;800;900&display=swap', false);	break;
				case "pt_sans": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=PT+Sans:wght@400;700&display=swap', false);	break;
				case "pt_sans_narrow": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=PT+Sans+Narrow:wght@400;700&display=swap', false);	break;
				case "pt_serif": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=PT+Serif:wght@400;700&display=swap', false);	break;
				case "raleway": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700;800;900&display=swap', false);	break;
				case "roboto": wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700;900&display=swap', false);	break;
				default: wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap', false);
			}
		} else {
			wp_enqueue_style('tncinf-primary-font', '//fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap', false);
		}
	} // end - check primary and heading font are different
}
add_action('wp_enqueue_scripts', 'tncinf_load_fonts');


/*
* >> Add font family
*/
function tncinf_font_family_css() {
	$tncinf_add_primary_font_url = get_theme_mod( 'tncinf_add_primary_font_url' );
	$tncinf_add_heading_font_url = get_theme_mod( 'tncinf_add_heading_font_url' );

	// Add primary font family
	if( $tncinf_add_primary_font_url != false || $tncinf_add_primary_font_url != '' || $tncinf_add_primary_font_url != null ) {
		switch ( $tncinf_add_primary_font_url ) {
			case "default_font":	echo "<style type='text/css'> body { font-family: 'Inter', Sans-serif; }  </style>"; break;
			case "arvo": echo "<style type='text/css'> body { font-family: 'Arvo', serif; }  </style>";	break;
			case "cabin":	echo "<style type='text/css'> body { font-family: 'Cabin', sans-serif; }  </style>"; break;
			case "inter":	echo "<style type='text/css'> body { font-family: 'Inter', Sans-serif; }  </style>"; break;
			case "lato": echo "<style type='text/css'> body { font-family: 'Lato', sans-serif; }  </style>"; break;
			case "lora": echo "<style type='text/css'> body { font-family: 'Lora', serif; }  </style>"; break;
			case "merriweather": echo "<style type='text/css'> body { font-family: 'Merriweather', serif; }  </style>"; break;
			case "montserrat": echo "<style type='text/css'> body { font-family: 'Montserrat', sans-serif; }  </style>"; break;
			case "open_sans": echo "<style type='text/css'> body { font-family: 'Open Sans', sans-serif; }  </style>"; break;
			case "oswald": echo "<style type='text/css'> body { font-family: 'Oswald', sans-serif; }  </style>"; break;
			case "oxygen": echo "<style type='text/css'> body { font-family: 'Oxygen', sans-serif; }  </style>"; break;
			case "playfair_display": echo "<style type='text/css'> body { font-family: 'Playfair Display', serif; }  </style>"; break;
			case "pt_sans": echo "<style type='text/css'> body { font-family: 'PT Sans', sans-serif; }  </style>"; break;
			case "pt_sans_narrow": echo "<style type='text/css'> body { font-family: 'PT Sans Narrow', sans-serif; }  </style>"; break;
			case "pt_serif": echo "<style type='text/css'> body { font-family: 'PT Serif', serif; }  </style>"; break;
			case "raleway": echo "<style type='text/css'> body { font-family: 'Raleway', sans-serif; }  </style>"; break;
			case "roboto": echo "<style type='text/css'> body { font-family: 'Roboto', sans-serif; }  </style>"; break;
			default: echo "<style type='text/css'> body { font-family: 'Inter', Sans-serif; }  </style>";
		}
	} else {
		echo "<style type='text/css'> body { font-family: 'Inter', Sans-serif; }  </style>";
	}

	// Add heading font family
	if( $tncinf_add_heading_font_url != false || $tncinf_add_heading_font_url != '' || $tncinf_add_heading_font_url != null ) {
		switch ( $tncinf_add_heading_font_url ) {
			case "default_font":	echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Inter', Sans-serif; }  </style>"; break;
			case "arvo": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Arvo', serif; }  </style>";	break;
			case "cabin":	echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Cabin', sans-serif; }  </style>"; break;
			case "inter":	echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Inter', Sans-serif; }  </style>"; break;
			case "lato": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Lato', sans-serif; }  </style>"; break;
			case "lora": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Lora', serif; }  </style>"; break;
			case "merriweather": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Merriweather', serif; }  </style>"; break;
			case "montserrat": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Montserrat', sans-serif; }  </style>"; break;
			case "open_sans": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Open Sans', sans-serif; }  </style>"; break;
			case "oswald": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Oswald', sans-serif; }  </style>"; break;
			case "oxygen": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Oxygen', sans-serif; }  </style>"; break;
			case "playfair_display": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Playfair Display', serif; }  </style>"; break;
			case "pt_sans": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'PT Sans', sans-serif; }  </style>"; break;
			case "pt_sans_narrow": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'PT Sans Narrow', sans-serif; }  </style>"; break;
			case "pt_serif": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'PT Serif', serif; }  </style>"; break;
			case "raleway": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Raleway', sans-serif; }  </style>"; break;
			case "roboto": echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Roboto', sans-serif; }  </style>"; break;
			default: echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Inter', Sans-serif; }  </style>";
		}
	} else {
		echo "<style type='text/css'> h1, h2, h3, h4, h5, h6 { font-family: 'Inter', Sans-serif; }  </style>";
	}
}
add_action('wp_head', 'tncinf_font_family_css');

