<?php
// appearance customizer
function tncinfinity_customize_register( $wp_customize ) {

	// Header background color
	$wp_customize->add_setting('tncinf_header_bg_color', array(
    'default' => '#1D2939',
    'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_header_bg_color', array(
		'label' => esc_html__('Header Background', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_header_bg_color',
	)));

	// Site title color
	$wp_customize->add_setting('tncinf_site_title_color', array(
		'default' => '#fff',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_site_title_color', array(
		'label' => esc_html__('Site Title', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_site_title_color',
	)));

	// Site tagline color
	$wp_customize->add_setting('tncinf_site_tagline_color', array(
		'default' => '#fff',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_site_tagline_color', array(
		'label' => esc_html__('Site Tagline', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_site_tagline_color',
	)));


	// Navbar top menu color
	$wp_customize->add_setting('tncinf_top_nav_link_color', array(
    'default' => '#fff',
    'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_top_nav_link_color', array(
		'label' => esc_html__('Navbar Top Menu', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_top_nav_link_color',
	)));

	// Navbar top menu hover color
	$wp_customize->add_setting('tncinf_top_nav_link_hover_color', array(
		'default' => '#cecece',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_top_nav_link_hover_color', array(
		'label' => esc_html__('Navbar Top Menu Hover', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_top_nav_link_hover_color',
	)));

	// Navbar active color
	$wp_customize->add_setting('tncinf_active_link_color', array(
		'default' => '#cecece',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_active_link_color', array(
		'label' => esc_html__('Navbar Active', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_active_link_color',
	)));

	// Dropdown menu background color
	$wp_customize->add_setting('tncinf_dropdown_menu_bg_link_color', array(
		'default' => '#fff',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_dropdown_menu_bg_link_color', array(
		'label' => esc_html__('Dropdown Menu Background', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_dropdown_menu_bg_link_color',
	)));
	
	// Dropdown item color
	$wp_customize->add_setting('tncinf_dropdown_item_link_color', array(
		'default' => '#212529',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_dropdown_item_link_color', array(
		'label' => esc_html__('Dropdown Item Color', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_dropdown_item_link_color',
	)));

	// Dropdown item hover background color
	$wp_customize->add_setting('tncinf_dropdown_item_bg_link_color', array(
		'default' => '#183f74',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_dropdown_item_bg_link_color', array(
		'label' => esc_html__('Dropdown Item Hover Background Color', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_dropdown_item_bg_link_color',
	)));

	// Dropdown item hover color
	$wp_customize->add_setting('tncinf_dropdown_item_hover_link_color', array(
		'default' => '#fff',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_dropdown_item_hover_link_color', array(
		'label' => esc_html__('Dropdown Item Hover Color', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_dropdown_item_hover_link_color',
	)));

	// Dropdown item active color
	$wp_customize->add_setting('tncinf_dropdown_item_active_link_color', array(
		'default' => '#a8a8a8',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_dropdown_item_active_link_color', array(
		'label' => esc_html__('Dropdown Item Active Color', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_dropdown_item_active_link_color',
	)));

	// Select hamburger icon
	$wp_customize->add_setting('tncinf_select_header_hamburger_icon', array(
		'default'        => 'light',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control( 'tncinf_select_header_hamburger_icon', array(
		'label'   => esc_html__('Select Hamburger Icon:', 'tnc-infinity'),
		'section' => 'colors',
		'type'    => 'select',
		'choices'    => array(
			'light' => esc_html__('Light', 'tnc-infinity'),
			'dark' => esc_html__('Dark', 'tnc-infinity'),
		),
	));

	// Body background color
	$wp_customize->add_setting('tncinf_body_bg_color', array(
		'default' => '#ffffff',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_body_bg_color', array(
		'label' => esc_html__('Body Background Color', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_body_bg_color',
	)));

	// Body font color
	$wp_customize->add_setting('tncinf_body_font_color', array(
		'default' => '#475467',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_body_font_color', array(
		'label' => esc_html__('Font Color', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_body_font_color',
	)));

	// Link color
	$wp_customize->add_setting('tncinf_global_link_color', array(
		'default' => '#0277BD',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_global_link_color', array(
		'label' => esc_html__('Link Color', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_global_link_color',
	)));

	// Visited link color
	$wp_customize->add_setting('tncinf_global_visited_link_color', array(
		'default' => '#5d2590',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_global_visited_link_color', array(
		'label' => esc_html__('Visited Link Color', 'tnc-infinity'),
		'section' => 'colors',
		'settings' => 'tncinf_global_visited_link_color',
	)));



	/*
	* =============================
	* >> Select Page Template Panel
	* =============================
	*/
	$wp_customize->add_panel( 'tncinf_select_page_template_panel', array(
		'title' => esc_html__( 'Select Page Template', 'tnc-infinity' ),
	) );
	$wp_customize->add_section( 'tncinf_select_page_template_section', array(
		'title' => esc_html__( 'Layout', 'tnc-infinity' ),
		'description' => esc_html__( 'Select home page, blog page, single page etc', 'tnc-infinity' ),
		'panel' => '', 'tncinf_select_page_template_panel',
	) );
	// Select Home Page Template - Panel
	$wp_customize->add_setting('tncinf_selected_home_page_template', array(
		'default'        => 'home_page_without_sidebar',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control( 'tncinf_selected_home_page_template', array(
		'label'   => esc_html__('Home Page Layout:', 'tnc-infinity'),
		'section' => 'tncinf_select_page_template_section',
		'type'    => 'select',
		'choices'    => array(
			'home_page_without_sidebar' => esc_html__( 'Fullwidth', 'tnc-infinity'),
			'home_page_with_right_sidebar' => esc_html__( 'Right Sidebar', 'tnc-infinity'),
		),
	));

	// Select Archive Page Template - Panel
	$wp_customize->add_setting('tncinf_selected_archive_page_template', array(
		'default'        => 'archive_page_without_sidebar',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control( 'tncinf_selected_archive_page_template', array(
		'label'   => esc_html__('Archive Page Layout:', 'tnc-infinity'),
		'section' => 'tncinf_select_page_template_section',
		'type'    => 'select',
		'choices'    => array(
			'archive_page_without_sidebar' => esc_html__('Fullwidth', 'tnc-infinity'),
			'archive_page_with_right_sidebar' => esc_html__('Right Sidebar', 'tnc-infinity'),
		),
	));

	// Select General Page Template - Panel
	$wp_customize->add_setting('tncinf_selected_general_page_template', array(
		'default'        => 'general_page_without_sidebar',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control( 'tncinf_selected_general_page_template', array(
		'label'   => esc_html__('Single Page Layout:', 'tnc-infinity'),
		'section' => 'tncinf_select_page_template_section',
		'type'    => 'select',
		'choices'    => array(
			'general_page_without_sidebar' => esc_html__('Fullwidth', 'tnc-infinity'),
			'general_page_with_right_sidebar' => esc_html__('Right Sidebar', 'tnc-infinity'),
		),
	));

	// Select Single Page Template - Panel
	$wp_customize->add_setting('tncinf_selected_single_page_template', array(
		'default'        => 'single_page_with_right_sidebar',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control( 'tncinf_selected_single_page_template', array(
		'label'   => esc_html__('Single Post Layout:', 'tnc-infinity'),
		'section' => 'tncinf_select_page_template_section',
		'type'    => 'select',
		'choices'    => array(
			'single_page_without_sidebar' => esc_html__('Fullwidth', 'tnc-infinity'),
			'single_page_with_right_sidebar' => esc_html__('Right Sidebar', 'tnc-infinity'),
		),
	));

	// Select Search Page Template - Panel
	$wp_customize->add_setting('tncinf_selected_search_page_template', array(
		'default'        => 'search_page_without_sidebar',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control( 'tncinf_selected_search_page_template', array(
		'label'   => esc_html__('Search Page Layout:', 'tnc-infinity'),
		'section' => 'tncinf_select_page_template_section',
		'type'    => 'select',
		'choices'    => array(
			'search_page_without_sidebar' => esc_html__('Fullwidth', 'tnc-infinity'),
			'search_page_with_right_sidebar' => esc_html__('Right Sidebar', 'tnc-infinity'),
		),
	));


	// Add Element in WordPress Default "Homepage Settings" panel for customize Homepage banner title
	$wp_customize->add_setting('tncinf_customize_blog_page_banner_title', array(
		'default'        => 'Home',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control( 'tncinf_customize_blog_page_banner_title', array(
		'label'   => esc_html__('Page Title', 'tnc-infinity'),
		'section' => 	'static_front_page',
		'type'    => 'text',
	));

	
	/*
	* =============================
	* >> Customize Single Post Panel
	* =============================
	*/
	$wp_customize->add_panel( 'tncinf_customize_single_post_panel', array(
		'title' => esc_html__( 'Single Post', 'tnc-infinity' ),
	) );
	$wp_customize->add_section( 'tncinf_customize_single_post_section', array(
    'title' => esc_html__( 'Single Post', 'tnc-infinity' ),
    'panel'    => '', 'tncinf_customize_single_post_panel',
	) );

	$wp_customize->add_setting('tncinf_customize_single_post_hide_social_share_setting', array(
		'capability' => 'edit_theme_options',
		'default'    => true,
		'type'       => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('tncinf_customize_single_post_hide_social_share_setting', array(
		'section'  => 'tncinf_customize_single_post_section',
		'label'      => esc_html__('Display Social Icon', 'tnc-infinity'),
		'type'     => 'checkbox',
	));



	/*
	* =============================
	* >> Customize TNC Infinity Settings
	* =============================
	*/

	$wp_customize->add_panel( 'tncinf_general_settings_panel', array(
		'title' => esc_html__('TNC Infinity Settings', 'tnc-infinity'),
	));
	$wp_customize->add_section( 'tncinf_general_settings_section', array(
		'title' => esc_html__('General', 'tnc-infinity'),
		'panel' => 'tncinf_general_settings_panel',
	));
	$wp_customize->add_section( 'tncinf_newsletter_settings_section', array(
		'title' => esc_html__('Newsletter', 'tnc-infinity'),
		'panel' => 'tncinf_general_settings_panel',
	));

	// Add a default featured image
	$wp_customize->add_setting('tncinf_default_placeholder_featured_image_id', array(
		'default'      => '',
		'capability'   => 'edit_theme_options',
		'type'         => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_mime_type',
	));

	$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'tncinf_default_placeholder_featured_image_id', array(
  'label' => __( 'Default Featured Image', 'tnc-infinity' ),
  'section' => 'tncinf_general_settings_section',
  'mime_type' => 'image',
	) ) );

	// Eanble/Disable sticky header
	$wp_customize->add_setting('tncinf_enable_disable_sticky_header', array(
		'capability' => 'edit_theme_options',
		'default'    => false,
		'type'       => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('tncinf_enable_disable_sticky_header', array(
		'section'  => 'tncinf_general_settings_section',
		'label'   => esc_html__('Sticky Header', 'tnc-infinity'),
		'type'     => 'checkbox',
	));

	// Eanble/Disable to display Featured image on blog page
	$wp_customize->add_setting('tncinf_hide_or_show_default_featured_image', array(
	'capability' => 'edit_theme_options',
	'default'			=> true,
	'type'       => 'theme_mod',
	'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('tncinf_hide_or_show_default_featured_image', array(
		'section'  => 'tncinf_general_settings_section',
		'label'   => esc_html__('Display Featured Image On Blog Page', 'tnc-infinity'),
		'type'     => 'checkbox',
	));

	// Eanble/Disable to display Featured image on single post
	$wp_customize->add_setting('tncinf_hide_or_show_default_featured_image_on_single_post', array(
		'capability' => 'edit_theme_options',
		'default'    => true,
		'type'       => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('tncinf_hide_or_show_default_featured_image_on_single_post', array(
		'section'  => 'tncinf_general_settings_section',
		'label'   => esc_html__('Display Featured Image On Single Post', 'tnc-infinity'),
		'type'     => 'checkbox',
	));

	// Add Page Title Background Image
	$wp_customize->add_setting('tncinf_page_title_bg_image_id', array(
		'default'      => '',
		'capability'   => 'edit_theme_options',
		'type'         => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_mime_type',
	));

	$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'tncinf_page_title_bg_image_id', array(
		'label' => __( 'Page Title Background Image', 'tnc-infinity' ),
		'section' => 'tncinf_general_settings_section',
		'mime_type' => 'image',
	) ) );

	// Add primary font
	$wp_customize->add_setting('tncinf_add_primary_font_url', array(
		'default'        => 'default_font',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control( 'tncinf_add_primary_font_url', array(
		'label'   => 	esc_html__('Select Primary Font', 'tnc-infinity'),
		'section' => 'tncinf_general_settings_section',
		'type'    => 'select',
		'choices'    => array(
			'default_font' => 'Default',
			'arvo' => 'Arvo',
			'cabin' => 'Cabin',
			'inter'	=> 'Inter',
			'lato' => 'Lato',
			'lora' => 'Lora',
			'merriweather' => 'Merriweather',
			'montserrat' => 'Montserrat',			
			'open_sans' => 'Open Sans',
			'oswald' => 'Oswald',
			'oxygen' => 'Oxygen',
			'playfair_display' => 'Playfair Display',
			'pt_sans' => 'PT Sans',
			'pt_sans_narrow' => 'PT Sans Narrow',
			'pt_serif' => 'PT Serif',			
			'raleway' => 'Raleway',
			'roboto' => 'Roboto',
		),
	));

	// Add heading font
	$wp_customize->add_setting('tncinf_add_heading_font_url', array(
		'default'        => 'default_font',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control( 'tncinf_add_heading_font_url', array(
		'label'   => 	esc_html__('Select Heading Font', 'tnc-infinity'),
		'section' => 'tncinf_general_settings_section',
		'type'    => 'select',
		'choices'    => array(
			'default_font' => 'Default',
			'arvo' => 'Arvo',
			'cabin' => 'Cabin',
			'inter'	=> 'Inter',
			'lato' => 'Lato',
			'lora' => 'Lora',
			'merriweather' => 'Merriweather',
			'montserrat' => 'Montserrat',			
			'open_sans' => 'Open Sans',
			'oswald' => 'Oswald',
			'oxygen' => 'Oxygen',
			'playfair_display' => 'Playfair Display',
			'pt_sans' => 'PT Sans',
			'pt_sans_narrow' => 'PT Sans Narrow',
			'pt_serif' => 'PT Serif',			
			'raleway' => 'Raleway',
			'roboto' => 'Roboto',
		),
	));


	// Display subscriber Section
	$wp_customize->add_setting('tncinf_show_hide_subscribe_button', array(
		'capability' => 'edit_theme_options',
		'default'    => true,
		'type'       => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('tncinf_show_hide_subscribe_button', array(
		'section'  => 'tncinf_newsletter_settings_section',
		'label'   => esc_html__('Display Newsletter Section', 'tnc-infinity'),		
		'type'     => 'checkbox',
	));
	// Newsletter subheading
	$wp_customize->add_setting('tncinf_newsletter_subheading', array(
		'default'       		=> 'Business Breakthroughs:',
		'capability'     		=> 'edit_theme_options',
		'type'           		=> 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control( 'tncinf_newsletter_subheading', array(
		'label'   => 	esc_html__('Subheading', 'tnc-infinity'),
		'section' => 	'tncinf_newsletter_settings_section',
		'type'    => 	'text',
	));
	// Newsletter heading
	$wp_customize->add_setting('tncinf_newsletter_heading', array(
		'default'       		=> 'Your Monthly Guide to Strategic Consulting Success',
		'capability'     		=> 'edit_theme_options',
		'type'           		=> 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control( 'tncinf_newsletter_heading', array(
		'label'   => 	esc_html__('Heading', 'tnc-infinity'),
		'section' => 	'tncinf_newsletter_settings_section',
		'type'    => 	'text',
	));
	// Newsletter Button text
	$wp_customize->add_setting('tncinf_newsletter_button_text', array(
		'default'       		=> 'Subscribe Our Newsletter',
		'capability'     		=> 'edit_theme_options',
		'type'           		=> 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control( 'tncinf_newsletter_button_text', array(
		'label'   => 	esc_html__('Button Text', 'tnc-infinity'),
		'section' => 	'tncinf_newsletter_settings_section',
		'type'    => 	'text',
	));
	// Add Subscriber button link
	$wp_customize->add_setting('tncinf_add_subscriber_button_url', array(
		'default'       		=> '#',
		'capability'     		=> 'edit_theme_options',
		'type'           		=> 'theme_mod',
		'sanitize_callback'	=> 'sanitize_url'
	));
	$wp_customize->add_control( 'tncinf_add_subscriber_button_url', array(
		'label'   => 	esc_html__('Button URL', 'tnc-infinity'),
		'section' => 	'tncinf_newsletter_settings_section',
		'type'    => 	'url',
	));


	/*
	* =============================
	* >> Footer Customization
	* =============================
	*/

	$wp_customize->add_panel( 'tncinf_footer_customization_panel', array(
		'title' => esc_html__('Footer', 'tnc-infinity'),
	));
	$wp_customize->add_section( 'tncinf_footer_customization_section', array(
		'title' => esc_html__('Footer', 'tnc-infinity'),
		'panel' => '', 'tncinf_footer_customization_panel',
	));

	// Main footer bg color
	$wp_customize->add_setting('tncinf_main_footer_bg_color', array(
		'default' => '#fff',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_main_footer_bg_color', array(
		'label' => esc_html__('Top Footer Background', 'tnc-infinity'),
		'section' => 'tncinf_footer_customization_section',
		'settings' => 'tncinf_main_footer_bg_color',
	)));

	// Main footer padding
	$wp_customize->add_setting('tncinf_main_footer_padding', array(
		'default'       		=> '',
		'capability'     		=> 'edit_theme_options',
		'type'           		=> 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('tncinf_main_footer_padding', array(
		'label' 		=> esc_html__('Top Footer Padding', 'tnc-infinity'),
		'type'      => 'text',
		'section' 	=> 'tncinf_footer_customization_section',
		'settings'	=> 'tncinf_main_footer_padding',
	));

	// Copyright footer bg color
	$wp_customize->add_setting('tncinf_copyright_footer_bg_color', array(
		'default' => '#fff',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_copyright_footer_bg_color', array(
		'label' => esc_html__('Copyright Footer Background', 'tnc-infinity'),
		'section' => 'tncinf_footer_customization_section',
		'settings' => 'tncinf_copyright_footer_bg_color',
	)));

	// Copyright footer padding
	$wp_customize->add_setting('tncinf_copyright_footer_padding', array(
		'default'       		=> '',
		'capability'     		=> 'edit_theme_options',
		'type'           		=> 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('tncinf_copyright_footer_padding', array(
		'label' 						=> esc_html__('Copyright Footer Padding', 'tnc-infinity'),
		'type'           		=> 'text',
		'section' 					=> 'tncinf_footer_customization_section',
		'settings' 					=> 'tncinf_copyright_footer_padding',
	));

	// Footer social icon color
	$wp_customize->add_setting('tncinf_footer_social_icon_color', array(
		'default' => '#98A2B3',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tncinf_footer_social_icon_color', array(
		'label' => esc_html__('Social Icon Color', 'tnc-infinity'),
		'section' => 'tncinf_footer_customization_section',
		'settings' => 'tncinf_footer_social_icon_color',
	)));


	// customize Footer Social Share 
	$wp_customize->add_setting('tncinf_footer_social_share_facebook', array(
		'default'        => '#',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_url',
	));
	$wp_customize->add_control( 'tncinf_footer_social_share_facebook', array(
		'label'   => esc_html__('Facebook URL', 'tnc-infinity'),
		'section' => 	'tncinf_footer_customization_section',
		'type'    => 'url',
	));

	$wp_customize->add_setting('tncinf_footer_social_share_twitter', array(
		'default'        => '#',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_url',
	));
	$wp_customize->add_control( 'tncinf_footer_social_share_twitter', array(
		'label'   => esc_html__('Twitter URL', 'tnc-infinity'),
		'section' => 	'tncinf_footer_customization_section',
		'type'    => 'url',
	));

	$wp_customize->add_setting('tncinf_footer_social_share_vimeo', array(
		'default'        => '#',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_url',
	));
	$wp_customize->add_control( 'tncinf_footer_social_share_vimeo', array(
		'label'   => esc_html__('Vimeo URL', 'tnc-infinity'),
		'section' => 	'tncinf_footer_customization_section',
		'type'    => 'url',
	));

	$wp_customize->add_setting('tncinf_footer_social_share_instagram', array(
		'default'        => '#',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_url',
	));
	$wp_customize->add_control( 'tncinf_footer_social_share_instagram', array(
		'label'   => esc_html__('Instagram URL', 'tnc-infinity'),
		'section' => 	'tncinf_footer_customization_section',
		'type'    => 'url',
	));

	$wp_customize->add_setting('tncinf_footer_social_share_pinterest', array(
		'default'        => '#',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_url',
	));
	$wp_customize->add_control( 'tncinf_footer_social_share_pinterest', array(
		'label'   => esc_html__('Pinterest URL', 'tnc-infinity'),
		'section' => 	'tncinf_footer_customization_section',
		'type'    => 'url',
	));

	$wp_customize->add_setting('tncinf_footer_social_share_youtube', array(
		'default'        => '#',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback'	=> 'sanitize_url',
	));
	$wp_customize->add_control( 'tncinf_footer_social_share_youtube', array(
		'label'   => esc_html__('Youtube URL', 'tnc-infinity'),
		'section' => 	'tncinf_footer_customization_section',
		'type'    => 'url',
	));
}
add_action('customize_register', 'tncinfinity_customize_register');


/*
* =============================
* >> Customize blog page panel -> display categories as a dropdown
* =============================
*/

function tncinf_customize_register_for_display_categories( $wp_customize ) {
	$tncinf_categories_full_list = get_categories(array( 'orderby' => 'name', ));
	$tncinf_choices_list = [];
	foreach( $tncinf_categories_full_list as $tncinf_single_cat ) {
		$tncinf_choices_list[$tncinf_single_cat->slug] = $tncinf_single_cat->name;
	}

	$wp_customize->add_panel( 'tncinf_customize_blog_page_panel', array(
		'title' => esc_html__( 'Blog Page', 'tnc-infinity' ),
	) );

	$wp_customize->add_section( 'tncinf_customize_blog_page_with_right_sidebar_section', array(
    'title' => esc_html__( 'Blog Page', 'tnc-infinity' ),
    'panel'    => '', 'tncinf_customize_blog_page_panel',
	) );

	$wp_customize->add_setting('tncinf_customize_blog_page_with_right_sidebar_feature_post', array(		
		'default' 		=> 'uncategorized',
		'capability' 	=> 'edit_theme_options',
		'type'       	=> 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	) );
	$wp_customize->add_control( 'tncinf_customize_blog_page_with_right_sidebar_feature_post', array(
		'label'   => esc_html__('Featured Category', 'tnc-infinity'),		
		'section' => 'tncinf_customize_blog_page_with_right_sidebar_section',
		'type' => 'select',
		'choices' => $tncinf_choices_list,
	) );
	$wp_customize->add_setting('tncinf_customize_blog_page_with_right_sidebar_popular_post_title', array(
		'default'       		=> 'POPULAR NEWS',
		'capability'     		=> 'edit_theme_options',
		'type'           		=> 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('tncinf_customize_blog_page_with_right_sidebar_popular_post_title', array(
		'label' 						=> esc_html__('Popular News Title', 'tnc-infinity'),
		'type'           		=> 'text',
		'section' 					=> 'tncinf_customize_blog_page_with_right_sidebar_section',
	));
	$wp_customize->add_setting('tncinf_customize_blog_page_with_right_sidebar_popular_post', array(
		'default' 		=> 'uncategorized',
		'capability' 	=> 'edit_theme_options',
		'type'       	=> 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control( 'tncinf_customize_blog_page_with_right_sidebar_popular_post', array(
		'label'   => esc_html__('Popular News Category', 'tnc-infinity'),
		'section' => 'tncinf_customize_blog_page_with_right_sidebar_section',
		'type' => 'select',
		'choices' => $tncinf_choices_list,
	));




	$wp_customize->add_setting('tncinf_customize_blog_page_with_right_sidebar_image_gallery_title', array(
		'default'       		=> 'IMAGE GALLERY',
		'capability'     		=> 'edit_theme_options',
		'type'           		=> 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('tncinf_customize_blog_page_with_right_sidebar_image_gallery_title', array(
		'label' 						=> esc_html__('Image Gallery Title', 'tnc-infinity'),
		'type'           		=> 'text',
		'section' 					=> 'tncinf_customize_blog_page_with_right_sidebar_section',
	));




	$wp_customize->add_setting('tncinf_customize_blog_page_with_right_sidebar_image_gallery', array(
		'default' 		=> 'uncategorized',
		'capability' 	=> 'edit_theme_options',
		'type'       	=> 'theme_mod',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control( 'tncinf_customize_blog_page_with_right_sidebar_image_gallery', array(
		'label' 						=> esc_html__('Image Gallery Category', 'tnc-infinity'),
		'section' => 'tncinf_customize_blog_page_with_right_sidebar_section',
		'type' => 'select',
		'choices' => $tncinf_choices_list,
	));

}
add_action( 'customize_register', 'tncinf_customize_register_for_display_categories' );



/*
* =============================
* >> output customizer settings
* =============================
*/
function tncinfinity_customize_css() {
	echo '<style type="text/css">';	
	
	echo '#header {background-color:'. esc_html(get_theme_mod('tncinf_header_bg_color', '#1D2939')) .'; }';
	echo '#header #header-name {color:'. esc_html(get_theme_mod('tncinf_site_title_color', '#fff')) .'; }';
	echo '#header #header-desc {color:'. esc_html(get_theme_mod('tncinf_site_tagline_color', '#fff')) .'; }';
	echo '#header .tncinf-navbar .navbar-nav .nav-link {color:'. esc_html(get_theme_mod('tncinf_top_nav_link_color', '#fff')) .'; }';
	echo '#header .tncinf-navbar .navbar-nav .nav-link:hover {color:'. esc_html(get_theme_mod('tncinf_top_nav_link_hover_color', '#cecece')) .'; }';
	echo '#header .tncinf-navbar .navbar-nav .active > .nav-link, #header .tncinf-navbar .navbar-nav .nav-link.active, #header .tncinf-navbar .navbar-nav .nav-link.show, #header .tncinf-navbar .navbar-nav .show > .nav-link {color:'. esc_html(get_theme_mod('tncinf_active_link_color', '#cecece')) .'; }';
	echo '#header .dropdown-menu {background:'. esc_html(get_theme_mod('tncinf_dropdown_menu_bg_link_color', '#fff')) .'; }';
	echo '#header .dropdown-item {color:'. esc_html(get_theme_mod('tncinf_dropdown_item_link_color', '#212529')) .'; }';
	echo '#header .dropdown-item:hover {background:'. esc_html(get_theme_mod('tncinf_dropdown_item_bg_link_color', '#183f74')) .'; }';
	echo '#header .dropdown-item:hover, #header .dropdown-menu .active .dropdown-item:hover {color:'. esc_html(get_theme_mod('tncinf_dropdown_item_hover_link_color', '#fff')) .'; }';
	echo '#header .dropdown-menu .active .dropdown-item {color:'. esc_html(get_theme_mod('tncinf_dropdown_item_active_link_color', '#a8a8a8')) .'; }';
	echo 'body {background-color:'. esc_html(get_theme_mod('tncinf_body_bg_color', '#ffffff')) .'; }';
	echo 'body {color:'. esc_html(get_theme_mod('tncinf_body_font_color', '#475467')) .'; }';
	echo 'a {color:'. esc_html(get_theme_mod('tncinf_global_link_color', '#0277BD')) .'; }';
	echo 'a:visited {color:'. esc_html(get_theme_mod('tncinf_global_visited_link_color', '#5d2590')) .'; }';

	echo '#footer .footer-main {background-color:'. esc_html(get_theme_mod('tncinf_main_footer_bg_color', '#fff')) .'; }';
	echo '#footer .footer-main {padding:'. esc_html(get_theme_mod('tncinf_main_footer_padding', '50px 0px 40px 0px')) .'; }';
	echo '#footer .footer-copyright {background-color:'. esc_html(get_theme_mod('tncinf_copyright_footer_bg_color', '#fff')) .'; }';
	echo '#footer .footer-copyright {padding:'. esc_html(get_theme_mod('tncinf_copyright_footer_padding', '0px 0px 0px 0px')) .'; }';
	echo '#footer #footer-meta [class*=" icofont-"], #footer #footer-meta [class^="icofont-"] {color:'. esc_html(get_theme_mod('tncinf_footer_social_icon_color', '#98A2B3')) .'; }';

	echo '</style>';
}
add_action('wp_head', 'tncinfinity_customize_css');
