<?php
class ClassSinglePageTemplateParts {

	public function __construct() {
    add_filter( 'comment_form_fields', array( $this, 'tncinf_comment_fields_custom_order' ) );
  }

	/* 
  * =================================================================
  * >> Get value from customizing-options.php file - Get yes/no for hide default thumbnail image
  * =================================================================
  */
  public function tncinf_hide_or_show_default_featured_image_on_single_post() {    
    $tncinf_hide_or_show_default_featured_image_on_single_post = get_theme_mod( 'tncinf_hide_or_show_default_featured_image_on_single_post', true );
    return $tncinf_hide_or_show_default_featured_image_on_single_post;
  }

	/* 
	* =================================================================
	* >> Add Author Info Box
	* =================================================================
	*/
	public function tncinf_add_author_info_box( $iamge_size ) {
		ob_start();

		$author_id = get_the_author_meta('ID');	
		$name = get_the_author_meta('display_name', $author_id);
		$bio = get_the_author_meta('description', $author_id);

		?>	
			<div class="tncinf-author-info d-flex flex-row">
				<div class="tncinf-author-image">
					<?php echo get_avatar( $author_id, $iamge_size ); ?>
				</div>

				<div class="tncinf-author-name-and-bio">
					<div class="tncinf-author-name">
						<h4><?php echo $name; ?></h4>
					</div>

					<?php if( !empty( $bio ) ) : ?>
						<div class="tncinf-author-bio">
							<p><?php echo $bio; ?></p>
						</div>
					<?php endif; ?>
				</div>

			</div>
		<?php

		$author_info = ob_get_clean();
		return $author_info;
	}



	/* 
	* =================================================================
	* >> Customize comments list area
	* =================================================================
	*/
	public function tncinf_callback_comments($comment, $args, $depth) {
	    if ( 'div' === $args['style'] ) {
	        $tag       = 'div';
	        $add_below = 'comment';
	    } else {
	        $tag       = 'li';
	        $add_below = 'comment';
	    }?>


	    <<?php echo $tag; ?> <?php comment_class(  empty( $args['has_children'] ) ? 'children' : 'parent' ); ?> id="comment-<?php comment_ID() ?>">

	    	<?php if ( 'div' != $args['style'] ) { ?>
	        	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
	        <?php } elseif ( 'div' == $args['style'] ) { ?>
	        	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
	        <?php } ?>


	        		<div class="comment-author-image">
	        			<?php
		        			if ( $args['avatar_size'] != 0 ) {
				                echo get_avatar( $comment, $args['avatar_size'] ); 
				            }        			
	        			?>
	        		</div>

	        		<div class="comments-details-wrapper">
			        	<div class="comment-author-name-date-reply">
			        		<?php printf( __( '<div class="fn">%s</div>', 'tnc-infinity' ), get_comment_author_link() ); ?>
			        		<?php printf( __( '<div class="comment-date">%s</div>', 'tnc-infinity' ), get_comment_date() ); ?>
			        		<div class="reply">
				        		<?php 
		          				comment_reply_link( array_merge( $args, array(
		          						'reply_text' => '',
		                      'add_below' => $add_below, 
		                      'depth'     => $depth, 
		                      'max_depth' => $args['max_depth'] 
		                  ) ) );
				            ?>
				        	</div>
			        	</div>

				        <?php if ( $comment->comment_approved == '0' ) { ?>
				            <em class="comment-awaiting-moderation">
				            	<?php _e( 'Your comment is awaiting moderation.', 'tnc-infinity' ); ?>
				            </em>
				            <br/>
				        <?php } ?>				        

				        <div class="comment-content">
			        		<?php comment_text(); ?>
			        	</div>
				        
				    </div>

	        <?php if ( 'div' != $args['style'] ) { ?>
	        	</div>
		    <?php } elseif ( 'div' == $args['style'] ) { ?>
		    	 </div> <!--end div body -->
		    <?php }
	}



	/* 
	* =================================================================
	* >> Customize comments form
	* =================================================================
	*/
	public function tncinf_customize_comments_form() {	
		$comment_send = 'Send';
		$comment_reply = 'Leave a Comment';
		$comment_reply_to = 'Reply';
		$comment_author = 'ThemeNcode';
		$comment_email = 'info@themencode.com';
		$comment_body = 'Write text message';
		$comment_url = 'Website';
		$comment_cookies_1 = ' By commenting you accept the';
		$comment_cookies_2 = ' Privacy Policy';
		$comment_before = '';
		$comment_cancel = 'Cancel Reply';

		$comments_args = array(
		    'fields' => array(
		        'author' =>
		        '<div class="comment-form-author">
		        	<label for="author">'. __( 'Name:', 'tnc-infinity' ) .'</label> <span class="required">*</span>
		       		<input type="text" id="author" name="author" aria-required="true" placeholder="' . $comment_author .'"></input>
		        </div>',

		        'email' =>
		        '<div class="comment-form-email">
		        	<label for="email">'. __( 'Email:', 'tnc-infinity' ) .'</label> <span class="required">*</span>
		        	<input type="email" id="email" name="email" placeholder="' . $comment_email .'"></input>
		        </div>',

		        'url' => 	
		        '<div class="comment-form-url">
		        	<label for="url">'. __( 'Website:', 'tnc-infinity' ) .'</label>
		        	<input type="url" id="url" name="url" placeholder="' . $comment_url .'"></input>
		        </div>',

		        'cookies' => 
		        '<input type="checkbox" required>'
		        . $comment_cookies_1 . 
		        '<a href="' . get_privacy_policy_url() . '">' . $comment_cookies_2 . '</a>',
		    ),

		    'comment_field' => 
		    '<div class="comment-form-comment">
		    	<label for="comment">'. __( 'Message:', 'tnc-infinity' ) .'</label> <span class="required">*</span>
		    	<textarea id="comment" name="comment" aria-required="true" placeholder="' . $comment_body .'"></textarea>
		    </div>',

		    // 'label_submit' => __( $comment_send, 'tnc-infinity' ),
		    'label_submit' => sprintf( __( '%s', 'tnc-infinity' ), $comment_send ),
				'title_reply' => sprintf( __( '%s', 'tnc-infinity' ), $comment_reply ),
				'title_reply_to' => sprintf( __( '%s', 'tnc-infinity' ), $comment_reply_to ),
				'cancel_reply_link' => sprintf( __( '%s', 'tnc-infinity' ), $comment_cancel ),
				'comment_notes_before' => sprintf( __( '%s', 'tnc-infinity' ), $comment_before ),
				'comment_notes_after' => '',
		    'id_submit' => __( 'comment-submit', 'tnc-infinity' ),
		);
		comment_form( $comments_args );
	}


  public function tncinf_comment_fields_custom_order( $fields ) {
      $comment_field = isset( $fields['comment'] ) ? $fields['comment'] : '';
      $author_field = isset( $fields['author'] ) ? $fields['author'] : '';
      $email_field = isset( $fields['email'] ) ?  $fields['email'] : '';
      $url_field = isset( $fields['url'] ) ? $fields['url'] : '';
      $cookies_field = isset( $fields['cookies'] ) ? $fields['cookies'] : '';

      unset( $fields['comment'] );
      unset( $fields['author'] );
      unset( $fields['email'] );
      unset( $fields['url'] );
      unset( $fields['cookies'] );

      $fields['author'] = $author_field;
      $fields['email'] = $email_field;
      $fields['comment'] = $comment_field;
      return $fields;
  }

} // end class ClassSinglePageTemplateParts