<?php
class ClassCommonPageTemplateParts {

  /* 
  * =================================================================
  * >> Get value from customizing-options.php file - Get Default thumbnail Image Url Set by user
  * =================================================================
  */
  public function get_default_placeholder_thumbnail_image_url_set_by_user() {
    if( get_theme_mod( 'tncinf_default_placeholder_featured_image_id' ) != false ) {
      $tncinf_default_placeholder_featured_image_id = esc_html ( get_theme_mod( 'tncinf_default_placeholder_featured_image_id', 'yes' ) );
      $tncinf_default_placeholder_thumbnail_image_url = wp_get_attachment_image_url($tncinf_default_placeholder_featured_image_id, 'full');
    } else {
      $tncinf_default_placeholder_thumbnail_image_url = get_template_directory_uri() .'/assets/default-images/fallback-thumbnail-image.png';
    }
    return $tncinf_default_placeholder_thumbnail_image_url;
  }


  /* 
  * =================================================================
  * >> Get value from customizing-options.php file - Get Default thumbnail Image Tag Set by user
  * =================================================================
  */
  public function get_default_placeholder_thumbnail_image_tag_set_by_user() {
    if( get_theme_mod( 'tncinf_default_placeholder_featured_image_id' ) != false ) {
      $tncinf_default_placeholder_featured_image_id = esc_html ( get_theme_mod( 'tncinf_default_placeholder_featured_image_id', 'yes' ) );
      $tncinf_default_placeholder_thumbnail_image_url = wp_get_attachment_image_url($tncinf_default_placeholder_featured_image_id, 'full');
      $tncinf_default_placeholder_thumbnail_image_tag = '<img class="full tncinf-img-fluid dfsdf" src="'. $tncinf_default_placeholder_thumbnail_image_url .'" alt="">';
    } else {
      $tncinf_default_placeholder_thumbnail_image_tag = '<img class="full tncinf-img-fluid" src="'. get_template_directory_uri() .'/assets/default-images/fallback-thumbnail-image.png" alt="">';
    }
    return $tncinf_default_placeholder_thumbnail_image_tag;
  }

  /* 
  * =================================================================
  * >> Get value from customizing-options.php file - Get Default thumbnail Image Url Set by user
  * =================================================================
  */
  public function tncinf_page_title_bg_image_url_set_by_user() {
    if( get_theme_mod( 'tncinf_page_title_bg_image_id' ) != false ) {
      $tncinf_page_title_bg_image_id = esc_html ( get_theme_mod( 'tncinf_page_title_bg_image_id', 'yes' ) );
      $tncinf_page_title_bg_image_url = wp_get_attachment_image_url($tncinf_page_title_bg_image_id, 'full');
    } else {
      $tncinf_page_title_bg_image_url = get_template_directory_uri() .'/assets/default-images/about-us-page-banner.png';
    }
    return $tncinf_page_title_bg_image_url;
  }


  /* 
  * =================================================================
  * >> Card design using background image
  * =================================================================
  */
  public function tncinf_card()
  {
    ob_start();
    $tncinf_hide_or_show_default_featured_image = get_theme_mod( 'tncinf_hide_or_show_default_featured_image', true );
  ?>
    <div class="card tncinf-card" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
      <?php if (has_post_thumbnail()) : ?>
        <div>
          <a class="card-img-top tncinf-card-img-top" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" style="background-image: url(<?php the_post_thumbnail_url( 'tncinf-thumbnail-image' ); ?>)"></a>
        </div>
      <?php else : ?>
        <?php if( $tncinf_hide_or_show_default_featured_image == true ) { ?>
          <div>
            <a class="card-img-top tncinf-card-img-top" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" style="background-image: url(<?php echo $this->get_default_placeholder_thumbnail_image_url_set_by_user(); ?>)"></a>
        </div>
        <?php } ?>
      <?php endif; ?>
      <div class="card-body tncinf-card-body">
        <div>
          <h3 class="card-heading tncinf-card-heading card-title">
            <a class="text-decoration-none" title="<?php the_title(); ?>" href="<?php echo esc_url(get_permalink()); ?>">
              <?php add_filter( 'the_title', 'tncinf_limit_the_title_word_count' ); ?>
              <?php the_title(); ?>
              <?php remove_filter( 'the_title', 'tncinf_limit_the_title_word_count' ); ?>
            </a>
          </h3>
        </div>
        <div class="tncinf-excerpt-and-learn-more">
          <div class="card-text tncinf-card-text"><?php the_excerpt(); ?></div>
          <div class="tncinf-learn-more">
            <a href="<?php echo get_permalink(); ?>"><?php esc_html_e( 'Learn More', 'tnc-infinity'); ?> <i class="icofont-long-arrow-right"></i></a>
          </div>
        </div>
      </div>
    </div>
  <?php
    $card_content = ob_get_clean();
    return $card_content;
  }




  /* 
  * =================================================================
  * >> Full width banner with search form
  * =================================================================
  */
  public function tncinf_full_width_banner_with_search_form( $title ) {
    ob_start();
    $tncinf_common_page_template_parts = new ClassCommonPageTemplateParts();
    $tncinf_customize_blog_page_banner_title = esc_html( get_theme_mod('tncinf_customize_blog_page_banner_title', 'Home') );
    ?>
      <div class="tncinf-full-width-banner-with-search-form" style="background-image: url( <?php echo $this->tncinf_page_title_bg_image_url_set_by_user(); ?> );">
        <div class="container">
          <div class="row">
            <div class="col-12 tncinf-text-center">
             <div class="tncinf-breadcrumb-wrapper"><?php $tncinf_common_page_template_parts->tncinf_breadcrumb(); ?></div>
              <?php if( is_home() ) : ?>
                <h1 class="tncinf-page-title text-uppercase"><?php echo $tncinf_customize_blog_page_banner_title; ?></h1>
              <?php else : ?>
                <h1 class="tncinf-page-title text-uppercase"><?php echo esc_html($title, 'tnc-infinity'); ?></h1>
              <?php endif; ?>             
              <div class="tncinf-banner-search-form">
                <?php echo get_search_form(); ?>
              </div>
            </div>        
          </div>
        </div>
      </div>
    <?php
    $content = ob_get_clean();
    return $content;
  }


  /* 
	* =================================================================
	* >> Full Width banner without search form
	* =================================================================
	*/
  public function tncinf_full_width_banner_without_search_form() {
    ob_start();
		$tncinf_common_page_template_parts = new ClassCommonPageTemplateParts()
    ?>
      <div class="tncinf-full-width-banner-without-search-form" style="background-image: url( <?php echo $this->tncinf_page_title_bg_image_url_set_by_user(); ?> );">
        <div class="container">
          <div class="row">
            <div class="col-12 tncinf-text-center">
						 <div class="tncinf-breadcrumb-wrapper"><?php $tncinf_common_page_template_parts->tncinf_breadcrumb(); ?></div>
             <h1 class="tncinf-page-title text-uppercase"><?php the_title(); ?></h1>
            </div>        
          </div>
        </div>
      </div>
    <?php
    $content = ob_get_clean();
    return $content;
  }





  /* 
  * =================================================================
  * >> Newsletter Subscriber linkable button
  * =================================================================
  */
  public function tncinf_newsletter_subscribe_linkable_button() {
    ob_start();
    $tncinf_add_subscriber_button_url = get_theme_mod('tncinf_add_subscriber_button_url', '#');
    $tncinf_newsletter_button_text = get_theme_mod('tncinf_newsletter_button_text', 'Subscribe Our Newsletter');
    $tncinf_newsletter_subheading = get_theme_mod('tncinf_newsletter_subheading', 'Business Breakthroughs:');
    $tncinf_newsletter_heading = get_theme_mod('tncinf_newsletter_heading', 'Your Monthly Guide to Strategic Consulting Success');
    ?>
      <div class="tncinf-newsletter-subscribe-linkable-button">
        <div class="container">
          <div class="row">
            <div class="col-12">
              <div class="tncinf-newsletter-subscribe-box" style="background-image: url( <?php echo esc_url ( get_template_directory_uri() ); ?>/assets/default-images/home-page-newsletter-subscribe-background.png );">
                <div class="row">
                  <div class="col-md-8 offset-md-2">
                  <h6><?php echo esc_html( $tncinf_newsletter_subheading, 'tnc-infinity' ); ?></h6>
                  <h3><?php echo esc_html( $tncinf_newsletter_heading, 'tnc-infinity' ); ?></h3>
                  </div>
                </div>
                  <button class="newsletter-subscribe-button"><a href="<?php echo $tncinf_add_subscriber_button_url; ?>"><?php echo esc_html( $tncinf_newsletter_button_text, 'tnc-infinity' ); ?></a></button>                
              </div>
            </div>
          </div>
        </div>
      </div>
    <?php
    $content = ob_get_clean();
    return $content;
  }





  /* 
  * =================================================================
  * >> Breadcrubm
  * =================================================================
  */
  public function tncinf_breadcrumb() {
    $sep = ' / ';

    if (!is_front_page()) {

      // Start the breadcrumb with a link to your homepage
      echo '<h6 class="tncinf-breadcrumb m-0 text-uppercase">';
      echo '   <a href="     ';
      echo esc_url ( home_url() );
      echo '">';
      echo 'HOME';
      echo '</a>' . $sep;

      // Check if the current page is a category or an archive. If so show the category or archive name.
      if ( is_category() ) {
        single_cat_title();
      } elseif ( is_author() ) {
        the_author();
      } elseif( is_tag() ) {
        single_tag_title();
      } elseif( is_tax() ) {
        single_term_title();
      } elseif (is_archive()) {
        if (is_day()) {
          printf(__( '%s', 'tnc-infinity' ), get_the_date());
        } elseif (is_month()) {
          printf(__( '%s', 'tnc-infinity' ), get_the_date(_x( 'F Y', 'monthly archives date format', 'tnc-infinity')));
        } elseif (is_year()) {
          printf(__( '%s', 'tnc-infinity' ), get_the_date(_x( 'Y', 'yearly archives date format', 'tnc-infinity')));
        } else {
          _e('Blog Archives', 'tnc-infinity');
        }
      }     

      // If the current page is a single post, show its title with the separator
      if (is_single()) {
        the_title();
      }
      
      // If the current page is a search page
      if ( is_search() ) {
        echo the_search_query();
      }

      // If the current page is a static page, show its title.
      if (is_page()) {
        echo the_title();
      }

      if ( is_404() ) {
        echo '404';
      }

      // if you have a static page assigned to be you posts list page. It will find the title of the static page and display it. i.e Home >> Blog
      if (is_home()){
        global $post;
        $page_for_posts_id = get_option('page_for_posts');
        if ( $page_for_posts_id ) { 
          $post = get_post($page_for_posts_id);
          setup_postdata($post);
          the_title();
          rewind_posts();
        }
      }
      echo '</h6>';
    }
  }

} // end class ClassCommonPageTemplateParts