<?php
class ClassBlogPageTemplateParts {

  /* 
  * =================================================================
  * >> Get value from customizing-options.php file - Get Default Image Tag Set by user
  * =================================================================
  */
  public function get_default_placeholder_thumbnail_image_tag_set_by_user() {
    if( get_theme_mod( 'tncinf_default_placeholder_featured_image_id' ) != false ) {
      $tncinf_default_placeholder_featured_image_id = esc_html ( get_theme_mod( 'tncinf_default_placeholder_featured_image_id', 'yes' ) );
      $tncinf_default_placeholder_thumbnail_image_url = wp_get_attachment_image_url($tncinf_default_placeholder_featured_image_id, 'full');
      $tncinf_default_placeholder_thumbnail_image_tag = '<img class="full tncinf-img-fluid dfsdf" src="'. $tncinf_default_placeholder_thumbnail_image_url .'" alt="">';
    } else {
      $tncinf_default_placeholder_thumbnail_image_tag = '<img class="full tncinf-img-fluid" src="'. get_template_directory_uri() .'/assets/default-images/fallback-thumbnail-image.png" alt="">';
    }
    return $tncinf_default_placeholder_thumbnail_image_tag;
  }

  /* 
  * =================================================================
  * >> Card design using full image and default thumbnail iamge
  * =================================================================
  */
  public function tncinf_card_full_image()
  {
    ob_start();
    $tncinf_hide_or_show_default_featured_image = get_theme_mod( 'tncinf_hide_or_show_default_featured_image', true );
  ?>
    <div class="card tncinf-card" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
      <?php if (has_post_thumbnail()) : ?>
        <div class="tncinf-feature-image">
          <?php the_post_thumbnail( 'full', array( 'class' => 'tncinf-img-fluid' ) ); ?>
        </div>
      <?php else : ?>
        <?php if( $tncinf_hide_or_show_default_featured_image == true ) { ?>
          <div class="tncinf-feature-image">
            <?php echo $this->get_default_placeholder_thumbnail_image_tag_set_by_user(); ?>
          </div>
        <?php } ?>
      <?php endif; ?>
      <div class="card-body tncinf-card-body">
        <?php the_title('<h3 class="card-heading tncinf-card-heading card-title"><a class="text-decoration-none" href="' . esc_url(get_permalink()) . '">', '</a></h3>'); ?>
        <div class="card-text tncinf-card-text"><?php the_excerpt(); ?></div>
        <div class="tncinf-learn-more">
          <a href="<?php echo get_permalink(); ?>"><?php esc_html_e( 'Learn More', 'tnc-infinity')?> <i class="icofont-long-arrow-right"></i></a>
        </div>
      </div>
    </div>
  <?php
    $card_content = ob_get_clean();
    return $card_content;
  }


  /* 
  * =================================================================
  * >> Card design using Full Image and only title
  * =================================================================
  */
  public function tncinf_card_full_image_and_only_title()
  {
    ob_start();
    $tncinf_hide_or_show_default_featured_image = get_theme_mod( 'tncinf_hide_or_show_default_featured_image', true );
  ?>
    <div class="card tncinf-card" id="post-<?php the_ID(); ?>" <?php post_class(); ?> >
      <?php if (has_post_thumbnail()) : ?>
        <div>
          <?php the_post_thumbnail( 'full', array( 'class' => 'tncinf-img-fluid' ) ); ?>
        </div>
      <?php else: ?>
        <?php if( $tncinf_hide_or_show_default_featured_image == true ) { ?>
          <div class="tncinf-feature-image">
            <?php echo $this->get_default_placeholder_thumbnail_image_tag_set_by_user(); ?>
          </div>
        <?php } ?>
      <?php endif; ?>
      <div class="card-body tncinf-card-body">
        <?php the_title('<h3 class="card-heading tncinf-card-heading card-title"><a class="text-decoration-none" href="' . esc_url( get_permalink() ) . '">', '</a></h3>'); ?>        
      </div>
    </div>
  <?php
    $card_content = ob_get_clean();
    return $card_content;
  }

} // end class ClassBlogPageTemplateParts