<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

	<?php
		$tncinf_enable_disable_sticky_header = get_theme_mod( 'tncinf_enable_disable_sticky_header', false );
		if( $tncinf_enable_disable_sticky_header == true ) {
			$tncinf_sticky_header = 'sticky';
		} else {
			$tncinf_sticky_header = 'no-sticky';
		}
	?>
	<header id="header" class="<?php echo $tncinf_sticky_header; ?>">
		<div class="container">
		
			<nav class="navbar navbar-expand-lg tncinf-navbar" role="navigation">
					<div class="navbar-brand">
						<div id="header-branding">
							<?php
							$tncinf_custom_logo = get_theme_mod('custom_logo');
							$tncinf_brand_image_src = wp_get_attachment_image_src($tncinf_custom_logo , 'full');
							if ($tncinf_custom_logo): ?>
								<a id="header-name" href ="<?php echo esc_url(home_url('/')); ?>">
									<img src="<?php echo esc_url($tncinf_brand_image_src[0]); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" />
								</a>
							<?php else:	?>
								<a id="header-name" href ="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html(get_bloginfo('name')); ?></a>
							<?php endif; ?>
							<?php $tncinf_bloginfo_description = get_bloginfo('description'); ?>
							<?php if ($tncinf_bloginfo_description): ?>
								<div id="header-desc"><?php echo esc_html( $tncinf_bloginfo_description, 'tnc-infinity' ); ?></div>
							<?php endif; ?>
						</div>
					</div>

					<!-- Brand and toggle get grouped for better mobile display -->

					<?php					
						$tncinf_select_header_hamburger_icon = esc_html(get_theme_mod('tncinf_select_header_hamburger_icon', 'light'));
						if( $tncinf_select_header_hamburger_icon == 'light' ) {			
					?>
						<button class="navbar-toggler navbar-toggler-light" type="button" data-toggle="collapse" data-target="#tncinf-navbar-collapse-1" aria-controls="tncinf-navbar-collapse-1" aria-expanded="false" aria-label="<?php esc_attr_e( 'Toggle navigation', 'tnc-infinity' ); ?>">
								<span class="navbar-toggler-icon-light"></span>
						</button>
					<?php } elseif( $tncinf_select_header_hamburger_icon == 'dark' ) { ?>
						<button class="navbar-toggler navbar-toggler-dark" type="button" data-toggle="collapse" data-target="#tncinf-navbar-collapse-1" aria-controls="tncinf-navbar-collapse-1" aria-expanded="false" aria-label="<?php esc_attr_e( 'Toggle navigation', 'tnc-infinity' ); ?>">
							<span class="navbar-toggler-icon-dark"></span>
						</button>
					<?php } else { ?>
						<button class="navbar-toggler navbar-toggler-light" type="button" data-toggle="collapse" data-target="#tncinf-navbar-collapse-1" aria-controls="tncinf-navbar-collapse-1" aria-expanded="false" aria-label="<?php esc_attr_e( 'Toggle navigation', 'tnc-infinity' ); ?>">
								<span class="navbar-toggler-icon-light"></span>
						</button>
					<?php } ?>


					<?php
						wp_nav_menu( array(
								'theme_location'    => 'primary',
								'depth'             => 2,
								'container'         => 'div',
								'container_class'   => 'collapse navbar-collapse justify-content-end',
								'container_id'      => 'tncinf-navbar-collapse-1',
								'menu_class'        => 'nav navbar-nav',
								'fallback_cb'       => 'WP_Bootstrap_Navwalker::fallback',
								'walker'            => new WP_Bootstrap_Navwalker(),
						) );
					?>
			</nav>

		</div>
	</header>
<div class="clearfix"></div>
