<?php
include( get_template_directory() . '/inc/inc.php' );
include( get_template_directory() . '/inc/ClassCommonTemplateParts.php' );
include( get_template_directory() . '/inc/ClassBlogPageTemplateParts.php' );
include( get_template_directory() . '/inc/ClassSinglePageTemplateParts.php' );
include( get_template_directory() . '/inc/customizing-options.php' );


/* 
* =================================================================
* >> Install All Required WordPress Plugins by the TGM_Plugin_Activation .
* =================================================================
*/
require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'tncinf_register_required_plugins' );

function tncinf_register_required_plugins() {
	$plugins = array(
		array(
			'name'      => 'Elementor',
			'slug'      => 'elementor',
			'required'  => false,
		),
		array(
			'name'      => 'Contact Form 7',
			'slug'      => 'contact-form-7',
			'required'  => false,
		),
		array(
			'name'      => 'WP Carousel',
			'slug'      => 'wp-carousel-free',
			'required'  => false,
		),
	);

	$config = array(
		'id'           => 'tgmpa',
		'default_path' => '',
		'menu'         => 'tgmpa-install-plugins',
		'parent_slug'  => 'themes.php',
		'capability'   => 'edit_theme_options',
		'has_notices'  => true,
		'dismissable'  => true,
		'dismiss_msg'  => '',
		'is_automatic' => false,
		'message'      => '',
	);
	tgmpa( $plugins, $config );
}


/* 
* =================================================================
* >> Paginaton
* =================================================================
*/
if( ! function_exists( 'tncinf_pagination' ) ) {
	function tncinf_pagination () {
		ob_start();

			echo '<nav class="tncinf-pagination">';
			the_posts_pagination(array(
				'mid_size' => 1,
				'prev_text' => __(' PREVIOUS', 'tnc-infinity'),
				'next_text' => __('NEXT ', 'tnc-infinity'),
			));
			echo '</nav>';

		$get_content = ob_get_clean();
		return $get_content;
	}
}

if( ! function_exists( 'tncinf_pagination_without_page_number' ) ) {
	function tncinf_pagination_without_page_number () {
		ob_start();

			echo '<nav class="tncinf-pagination tncinf_pagination_without_page_number">';
			the_posts_pagination(array(
				'mid_size' => 1,
				'prev_text' => __('&nbsp;', 'tnc-infinity'),
				'next_text' => __('&nbsp;', 'tnc-infinity'),
				'before_page_number' => '<span class="remove-pagination-number">',
        'after_page_number' => '</span>',
			));
			echo '</nav>';

		$get_content = ob_get_clean();
		return $get_content;
	}
}


/* 
* =================================================================
* >> Widget area
* =================================================================
*/
function tncinfinity_widgets_init() {
	register_sidebar(array(
		'name' => esc_html__('Footer', 'tnc-infinity'),
		'id' => 'tncinf-primary-footer-widget',
		'before_widget' => '<div class="widget">',
		'after_widget' => '</div>',
		'before_title' => '<h4>',
		'after_title' => '</h4>',
	));

	register_sidebar( array(
		'name'          => esc_html__( 'Regular Sidebar', 'tnc-infinity' ),
		'id'            => 'tncinf-regular-pages-sidebar',
		'description'   => esc_html__( 'Add widgets here for your regular pages sidebar', 'tnc-infinity' ),
		'before_widget' => '<aside id="%1$s" class="tncinf-widget tncinf-regular-pages-widget widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h4 class="tncinf-widget-title">',
		'after_title'   => '</h4>',
	) );
}
add_action('widgets_init', 'tncinfinity_widgets_init');


/* 
* =================================================================
* >> Filter the excerpt length to 20 words.
* =================================================================
*/
function tncinf_custom_excerpt_length()
{
	return 12;
}
add_filter('excerpt_length', 'tncinf_custom_excerpt_length', 999);



/* 
* =================================================================
* >> Filter the excerpt "read more" string.
* =================================================================
*/
function tncinf_custom_excerpt_more()
{
	return '....';
}
add_filter('excerpt_more', 'tncinf_custom_excerpt_more');


/* 
* =================================================================
* >> Limit the word count in the post title
* =================================================================
*/
function tncinf_limit_the_title_word_count( $title ) {
		return wp_trim_words( $title, 8, '...' );
}


function tncinf_limit_the_title_word_count_for_sidebar( $title ) {
	return wp_trim_words( $title, 4, '...' );
}


/* 
* =================================================================
* >> Get the author gravatar
* =================================================================
*/
function tncinf_author_gravatar_image($author_id, $image_size)
{
	$get_author_gravatar = get_avatar_url($author_id, array('size' => $image_size));
	return '<img src="' . $get_author_gravatar . '" alt="' . get_the_title() . '" />';
}